/***************************************************************************
 File: sxapp.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.
			  
 You may use this Sample Code any way you please provided you do not resell 
 the code and that this notice (including the above copyright notice) is 
 reproduced on all copies.  THIS SAMPLE CODE IS PROVIDED "AS IS", WITHOUT 
 WARRANTY OF ANY KIND, AND GO CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
 WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL GO 
 CORPORATION BE LIABLE TO YOU FOR ANY CONSEQUENTIAL,INCIDENTAL, OR INDIRECT 
 DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.0  $
   $Author:   aloomis  $
     $Date:   13 Aug 1992 12:13:22  $

 This file contains the class definition and methods for clsSX.

****************************************************************************/

#ifndef APPDIR_INCLUDED
#include <appdir.h>
#endif

#ifndef APPWIN_INCLUDED
#include <appwin.h>
#endif

#ifndef INSERT_INCLUDED
#include <insert.h>
#endif

#ifndef NOTE_INCLUDED
#include <note.h>
#endif

#ifndef SERVMGR_INCLUDED
#include <servmgr.h>
#endif

#ifndef STROBJ_INCLUDED
#include <strobj.h>
#endif

#ifndef SYSGRAF_INCLUDED
#include <sysgraf.h>
#endif

#ifndef TK_INCLUDED
#include <tk.h>
#endif

#ifndef _STDIO_H_INCLUDED
#include <stdio.h>
#endif

#ifndef XGESTURE_INCLUDED
#include <xgesture.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef INTL_INCLUDED
#include <intl.h>
#endif

#ifndef SXAPP_INCLUDED
#include "sxapp.h"
#endif
#include "methods.h"

/*
 * SX is an example for doing some simple serial I/O. Serial input is read by
 * a semaphore-controlled subtask which places the received characters in a
 * textview. Output is entered in an IP and send by the main task.
 *
 * For demonstration purposes SX creates its own serial option card, instead of
 * using the standard one provided. This is more work than you need to do, you
 * can use the option card SIO provides (see sio.h)
 *
 * The hardest part of doing serial I/O is often the cable. In PenPoint, DSR
 * is used to detect connection to a serial peripheral. So DSR must be high
 * (marking the 'connected' state) before any serial I/O is possible.
 * Wiring used for this app with a Televideo 925 terminal was as follows
 * (using a SmartCable):
 *
 * 								TV		PP
 * 								2	-	3
 * 								3	-	2
 * 								8	-	4
 * 								20	-	11
 * 								-8  -   20
 *
 * 6 (DRS) was manually toggled high and low to make and break connection.
 *
 * The Status field in the Serial option card indicates whether PenPoint
 * considers the peripheral to be connected or not.
 *
 * SX will compile and run under both PenPoint 1.0 and a future (unspecified)
 * international release (coming soon to a tablet near you).  PP1_0 is defined
 * by default in the header file; comment out this line to run under any 
 * other release.
 * 
 */

/* Buttons for IP Command bar */
static const TK_TABLE_ENTRY	sxCommandBar[] = {
	{ tagSXSendStr, msgSXIPCommand, 0, 0, tkLabelStringId},
	{tagSXClearStr, msgSXIPCommand, 1, 0, tkLabelStringId},
	{pNull}
};

/* Button for error note. Defined in sxser.c */
extern const TK_TABLE_ENTRY sxNoteButton[];

/*
 * Respond to msgAppExecuteGesture.
 *
 * Filter out Find, Print and Spell, they're not relevant for SX.
 */
MsgHandlerWithTypes(SXAppExecuteGesture, P_GWIN_GESTURE, PP_SX_APP_DATA)
{
	STATUS s;

	/* Deny Find, Print and Spell */
	Dbg(Debugf(U_L("SXAppExecuteGesture >>")););

#ifdef PP1_0
	switch (pArgs->msg) {
#else
	switch(pArgs->gesture) {
#endif
		case xgsFGesture:
		case xgsPGesture:
		case xgsSGesture:
			s = stsRequestDenied;
			break;

		default:
			s = ObjectCallAncestor(msg, self, pArgs, ctx);
			break;
	}

	Dbg(Debugf(U_L("<< SXAppExecuteGesture"));)

	return s;

	MsgHandlerParametersNoWarning;
} /* SXAppExecuteGesture */

/*
 * Respond to msgAppOpen.
 *
 * Create all windows and a list of serial port services.
 *
 */
MsgHandlerWithTypes(SXAppOpen, P_APP_OPEN, PP_SX_APP_DATA)
{
	P_SX_APP_DATA pInst = *pData;
	APP_METRICS am;
	TBL_LAYOUT_NEW tln;
	WIN_METRICS wm;
	IP_NEW in;
	IM_GET_SET_NAME gn;
	TV_NEW tvn;
	OBJECT win;
	SCROLL_WIN_STYLE sws;
	COMMAND_BAR_NEW cbn;
	OBJECT serlist;
	LIST_NEW ln;
	LIST_ENTRY le;
	STROBJ_NEW sn;
	CHAR buffer[nameBufLength];
	U16 n;
	TAG errorTag;
	BOOLEAN haveName = false;
	STATUS s;

	Dbg(Debugf(U_L("SXAppOpen >>")););

	/* Create the table layout which will hold two windows (vertically);
	 * a textview (inserted in a scrollwindow) above an embedded
	 * insertion pad.
	 * For each part in AppOpen I set errorTag to the tag whose string
	 * sort of describes what might have gone wrong if there is a failure.
	 * This string will be used to popup a note for the user.
	 */
	errorTag = tagSXNoWindowErrorStr;

	ObjCallWarn(msgNewDefaults, clsTableLayout, &tln);
	tln.border.style.leftMargin = bsMarginSmall;
	tln.border.style.rightMargin = bsMarginSmall;
	tln.tableLayout.numCols.constraint = tlAbsolute;
	tln.tableLayout.numCols.value = 1;
	tln.tableLayout.numRows.constraint = tlAbsolute;
	tln.tableLayout.numRows.value = 2;
	tln.tableLayout.rowHeight.constraint = tlMaxFit;
	tln.tableLayout.colWidth.constraint = tlMaxFit;
	tln.tableLayout.rowHeight.gap = 1;
	tln.tableLayout.colWidth.gap = 1;
	ObjCallJmp(msgNew, clsTableLayout, &tln, s, error);

	/* Keep UID of this window */
	pInst->sxWin = tln.object.uid;

	/* Create the textview to display serial input */
	ObjCallWarn(msgNewDefaults, clsSXView, &tvn);
	tvn.border.style.edge = bsEdgeTop|bsEdgeBottom;
	tvn.border.style.lineStyle = bsLineDouble;
	/* no IPs here */
	tvn.tv.flags &= ~tvFillWithIP;

	StsJmp(TextCreateTextScrollWin(&tvn, &win), s, error1);

	ObjCallWarn(msgScrollWinGetStyle, win, &sws);
	sws.autoVertScrollbar = false;
	sws.vertScrollbar = true;
	ObjCallWarn(msgScrollWinSetStyle, win, &sws);

	wm.parent = pInst->sxWin;
	wm.options = wsPosTop;
	ObjCallJmp(msgWinInsert, win, &wm, s, error1);

	/* Store data object for subtask */
	pInst->sxSubTaskData->sdTextObject = tvn.view.dataObject;

	/* Create the insertion pad to receive text for serial output */
	ObjCallWarn(msgNewDefaults, clsIP, &in);
	in.ip.style.embeddedLook = true;
	in.win.flags.style |= wsSendGeometry|wsSendFile|wsShrinkWrapHeight;
	in.border.style.resize = bsResizeNone;
	in.border.style.drag = bsDragNone;
	in.border.style.shadow = bsShadowNone;
	in.border.style.edge = bsEdgeTop;
	in.border.style.lineStyle = bsLineDouble;
	in.ip.client = self;
	in.ip.style.displayType = ipsCharBox;
	/* I'll replace the standard command bar with my own below */
	in.ip.style.buttonType = ipsBottomButtons;
	in.ip.style.delayed = false;

	ObjCallJmp(msgNew, clsIP, &in, s, error1);
	pInst->sxIPWin = in.object.uid;

	wm.parent = pInst->sxWin;
	wm.options = wsPosTop;
	ObjCallJmp(msgWinInsert, in.object.uid, &wm, s, error1);

	/* Create the custom commandbar for the insertion pad */
	ObjCallWarn(msgNewDefaults, clsCommandBar, &cbn);
	cbn.gWin.style.gestureEnable = false;
	cbn.win.flags.style |= wsClipChildren;
	cbn.win.tag = tagIPCommandBar;
	cbn.tkTable.client = self;

	cbn.border.style.edge = bsEdgeTop;
	cbn.border.style.leftMargin = cbn.border.style.rightMargin = 
		cbn.border.style.topMargin = cbn.border.style.bottomMargin =
		bsMarginNone;
	cbn.border.style.topMargin = bsMarginMedium;

	cbn.border.style.backgroundInk = bsInkWhite;
	cbn.tkTable.buf.button.style.feedback = bsFeedbackInvert;
	cbn.tkTable.buf.border.style.backgroundInk = bsInkWhite;
	cbn.tkTable.buf.border.style.borderInk = bsInkGray33;
	cbn.tkTable.buf.border.style.join = bsJoinSquare;

	cbn.tkTable.pEntries = sxCommandBar;
	ObjCallJmp(msgNew, clsCommandBar, &cbn, s, error1);

	wm.parent = in.object.uid;
	wm.options = wsPosTop;
	ObjCallJmp(msgWinInsert, cbn.object.uid, &wm, s, error1);

	/* Ewout: Sneaky. Let the IP create a command bar and the layout.
	 * I replace it however with my own command bar, which is more 
	 * appropriate for this particular usage of the IP.
	 */
	if (win = (WIN) ObjectCall(msgWinFindTag, in.object.uid,
			(P_ARGS)tagIPCommandBar)) {

		wm.parent = in.object.uid;
		ObjCallWarn(msgWinExtract, win, &wm);
		ObjCallWarn(msgFree, win, pNull);

		wm.parent = in.object.uid;
		wm.options = wsPosTop;
		ObjCallWarn(msgWinInsert, cbn.object.uid, &wm);

	}

	/* Get my frame */
	ObjCallJmp(msgAppGetMetrics, self, &am, s, error1);

	/* And insert my tablelayout window */
	ObjCallJmp(msgFrameSetClientWin, am.mainWin, \
		(P_ARGS)pInst->sxWin, s, error1);

	pArgs->childAppParentWin = pInst->sxWin;

	/* Create a list to hold the name of the serial port drivers.
	 * Default is good enough for me.
	 */
	ObjCallJmp(msgNewWithDefaults, clsList, &ln, s, error1);

	/* Get the serial port driver list, copy names */
	ObjCallJmp(msgIMGetList, theSerialDevices, &serlist, s, error2);
	/* How many? */
	ObjCallJmp(msgListNumItems, serlist, &n, s, error2);

	if (n == 0) {
		/* there aren't any service instances! Bug out */
		errorTag = tagSXNoServiceErrorStr;
		goto error2;
	}

	/* use a generic error string if I can't clone the service instance
	 * list.
	 */
	errorTag = tagSXServMgrErrorStr;

/* If a previous selected default service instance is no longer available,
 * jump back here to walk the list again, and find a new default.
 */
getname:

	/* Get the list of available service instances from theSerialDevices.
	 * Walk down the list, get the name of each instance and store it in my
	 * own list. Check if a service instance should be default (if none has
	 * been stored as default yet), or compare it with a previously stored
	 * service name.
	 */
	for (le.position = 0; le.position < n; le.position++) {
		ObjCallJmp(msgListGetItem, serlist, &le, s, error2);
		if (le.item != pNull) {
			gn.handle = (OBJECT) le.item;
			gn.pName = buffer;
			ObjCallJmp(msgIMGetName, theSerialDevices, &gn, s, error2);

			/* Copy name */
			ObjCallWarn(msgNewDefaults, clsString, &sn);
			sn.strobj.pString = buffer;
			ObjCallJmp(msgNew, clsString, &sn, s, error2);

			/* Add it to the end of the list */
			ObjCallJmp(msgListAddItem, ln.object.uid, sn.object.uid, s, error2);

			/* Check if this is this one is selected or that I
			 * should make a default.
			 */
			if (pInst->sxSerPrefs.spSerServ[0] == 0 && le.position == 0) {
				Dbg(Debugf(U_L("Setting default SerialServ to %s"), buffer););

				Ustrncpy(pInst->sxSerPrefs.spSerServ, buffer,
					nameBufLength * SizeOf(CHAR));
				pInst->sxSerServIndex = 0;
				haveName = true;
			} else {
				if ((Ustrcmp(pInst->sxSerPrefs.spSerServ, buffer)) == 0) {
					Dbg(Debugf(
							U_L("Setting default SerialServ to %s"), buffer););
					pInst->sxSerServIndex = le.position;
					haveName = true;
				}
			}
		}
	}

	if (haveName == false) {
		/* Apparently previously selected driver is not available,
		 * try again to get the first one available.
		 */
		if (pInst->sxSerPrefs.spSerServ[0] != 0) {
			pInst->sxSerPrefs.spSerServ[0] = 0;
			goto getname;
		} else {
			goto error2;
		}
	}

	/* Destroy the service instance list */
	ObjCallWarn(msgDestroy, serlist, pNull);
		
	/* Keep list uid */
	pInst->sxSerialNameList = ln.object.uid;

	/* Set errorTag to 'error opening serial port' both for
	 * failing to get a semaphore and for begin unable to open
	 * the port.
	 */
	errorTag = tagSXSerialErrorStr;
	/* Create a semaphore to signal subtask with */
	s = OSSemaCreate(&pInst->sxSubTaskData->sdEventSemaphore);
	if (s >= stsOK) {

		/* Open serial port. */
		ObjCallJmp(msgSXOpenSerial, self, (P_ARGS)pNull, s, error3);

		Dbg(Debugf(U_L("<< SXAppOpen")););

		return stsOK;
	}

/* Jumped to if opening the serial port failed. Clean up */
error3:
	StsWarn(OSSemaDelete(pInst->sxSubTaskData->sdEventSemaphore));

/* Jumped to if creating the list failed. Clean up */
error2:
	{
	LIST_FREE lf;

	lf.key = objWKNKey;
	lf.mode = listFreeItemsAsObjects;

	ObjCallWarn(msgListFree, ln.object.uid, &lf);

	}

/* Jumped to on an error while creating/inserting the windows */
error1:
	ObjCallWarn(msgDestroy, tln.object.uid, (P_ARGS)pNull);

error:
	/* Give the user an idea why opening this app failed */
	{
	NOTE_NEW nn;
	NOTE_RES_ID nri;
	MESSAGE m;
	STATUS s;

	memset(&nri, 0, SizeOf(NOTE_RES_ID));
	nri.resId = resSXToolKit;
	nri.index = (U32)TagNum(errorTag);

	ObjCallWarn(msgNewDefaults, clsNote, &nn);
	/* Make this note system modal to keep the app framework
	 * from moving on and taking it down before I have a change to
	 * read it.
	 */
	nn.note.metrics.flags =
		nfAppTitle|nfAutoDestroy|nfResContent|nfSystemModal;
	nn.note.pContentEntries	= &nri;
	nn.note.pCmdBarEntries	= sxNoteButton;
	ObjCallJmp(msgNew, clsNote, &nn, s, nonote);

	ObjCallWarn(msgNoteShow, nn.object.uid, &m);

	}

nonote:
	return stsFailed;

	MsgHandlerParametersNoWarning;
} /* SXAppOpen */

/*
 * Respond to msgAppClose.
 *
 * Close serial port, destroy windows and serial name list.
 */
MsgHandlerWithTypes(SXAppClose, P_ARGS, PP_SX_APP_DATA)
{
	APP_METRICS am;
	LIST_FREE lf;
	STATUS s;

	Dbg(Debugf(U_L("SXAppClose >>")););

	/* Close serial port (will also terminate subtask) and delete
	 * the semaphore I used.
	 */
	ObjCallWarn(msgSXCloseSerial, self, (P_ARGS)pNull);
	StsWarn(OSSemaDelete((*pData)->sxSubTaskData->sdEventSemaphore));

	/* Get Metrics */
	ObjCallRet(msgAppGetMetrics, self, &am, s);

	/* Remove my window */
	ObjCallWarn(msgFrameSetClientWin, am.mainWin, (P_ARGS)objNull);

	/* And destroy it */
	ObjCallWarn(msgDestroy, (*pData)->sxWin, Nil(P_ARGS));

	/* Destroy option sheet */
	if ((*pData)->sxOptWin)
		ObjCallWarn(msgDestroy, (*pData)->sxOptWin, Nil(P_ARGS));

	lf.key = objWKNKey;
	lf.mode = listFreeItemsAsObjects;
	ObjCallWarn(msgListFree, (*pData)->sxSerialNameList, &lf);

	Dbg(Debugf(U_L("<< SXAppClose")););

	return(stsOK);

	MsgHandlerParametersNoWarning;
} /* SXAppClose */

/*
 * Respond to msgSave.
 *
 * Write out the serial preferences of the instance data.
 */
MsgHandlerWithTypes(SXSave, P_OBJ_SAVE, PP_SX_APP_DATA)
{
	P_SX_SER_PREFS pSerPrefs;
	STREAM_READ_WRITE fsWrite;
	STATUS s;

	Dbg(Debugf(U_L("SXSave >>")););

	/* Save partial instance data (only serial prefs at the moment) */
	pSerPrefs = &((*pData)->sxSerPrefs);

	fsWrite.numBytes = SizeOf(SX_SER_PREFS);
	fsWrite.pBuf = pSerPrefs;
	ObjCallRet(msgStreamWrite, pArgs->file, &fsWrite, s);

	Dbg(Debugf(U_L("<< SXSave")););

	return(stsOK);

	MsgHandlerParametersNoWarning;
} /* SXSave */

/*
 * Respond to msgRestore.
 *
 * Restore serial prefs in instance data.
 */
MsgHandlerWithTypes(SXRestore, P_OBJ_RESTORE, PP_SX_APP_DATA)
{
	P_SX_APP_DATA pInst = *pData;
	P_SX_SER_PREFS pSerPrefs;
	STREAM_READ_WRITE fsRead;
	STATUS s;

	Dbg(Debugf(U_L("SXRestore >>")););

	pSerPrefs = &(pInst->sxSerPrefs);

	/* Restore partial instance data (serial prefs) */
	fsRead.numBytes	= SizeOf(SX_SER_PREFS);
	fsRead.pBuf = pSerPrefs;
	ObjCallRet(msgStreamRead, pArgs->file, &fsRead, s);

	/* Update instance data */
	StsWarn(ObjectWrite(self, ctx, &pInst));

	Dbg(Debugf(U_L("<< SXRestore")););

	return(stsOK);

	MsgHandlerParametersNoWarning;
} /* SXRestore */

/*
 * Respond to msgInit.
 *
 * Allocate memory for instance data and structure which is passed to a 
 * subtask. Initialize instance data.
 */
MsgHandlerWithTypes(SXInit, P_APP_NEW, PP_SX_APP_DATA)
{
	P_SX_APP_DATA pInst;
	STATUS s;

	Dbg(Debugf(U_L("SXInit >>")););

	/* Allocate memory to hold instance data. This is not protected,
	 * nor written out upon termination, apart from the serial prefs. */
	StsRet(OSHeapBlockAlloc(osProcessHeapId, SizeOf(SX_APP_DATA), \
		&pInst), s);

	/* Get some memory to pass to subtask */
	StsJmp(OSHeapBlockAlloc(osProcessHeapId, SizeOf(SX_SUBTASK_DATA), \
		&pInst->sxSubTaskData), s, error);

	pInst->sxWin = objNull;
	pInst->sxOptWin = objNull;
	pInst->sxIPWin = objNull;
	pInst->sxSubTaskID = 0;

	pInst->sxSerialNameList = objNull;

	/* Set default serial settings */
	pInst->sxSerServIndex = 0;
	pInst->sxSerPrefs.spSerServ[0] = 0;
	pInst->sxSerPrefs.spBaudRate = 9600;
	pInst->sxSerPrefs.spParity = sioNoParity;
	pInst->sxSerPrefs.spDataBits = sioEightBits;
	pInst->sxSerPrefs.spStopBits = sioOneStopBit;
	pInst->sxSerPrefs.spFlowControl = sioXonXoffFlowControl;

	StsWarn(ObjectWrite(self, ctx, &pInst));

	Dbg(Debugf(U_L("<< SXInit")););

	return(stsOK);

error:
	StsWarn(OSHeapBlockFree(pInst));
	
	MsgHandlerParametersNoWarning;
} /* SXInit */

/*
 * Respond to msgFree.
 *
 * Free memory allocated for instance data and subtask info structure.
 */
MsgHandlerWithTypes(SXFree, P_ARGS, PP_SX_APP_DATA)
{

	Dbg(Debugf(U_L("SXFree >>")););

	StsWarn(OSHeapBlockFree((*pData)->sxSubTaskData));
	StsWarn(OSHeapBlockFree(*pData));

	Dbg(Debugf(U_L("<< SXFree")););
	return(stsOK);

	MsgHandlerParametersNoWarning;
} /* SXFree */

/*
 * Create clsSX...
 */
STATUS ClsSXInit(void)
{
	APP_MGR_NEW new;
	STATUS s;

	// Install this class
	ObjCallWarn(msgNewDefaults, clsAppMgr, &new);
	new.object.uid = clsSX;
	new.cls.pMsg = clsSXAppTable;
	new.cls.ancestor = clsApp;
	new.cls.size = SizeOf(P_SX_APP_DATA);
	new.cls.newArgsSize = SizeOf(APP_NEW);

	new.appMgr.flags.accessory = true;
	new.appMgr.flags.allowEmbedding = false;
	new.appMgr.flags.stationery = false;
	new.appMgr.flags.hotMode = false;
	new.appMgr.flags.lowMemoryApp = false;

#ifdef PP1_0
	Ustrcpy(new.appMgr.company, U_L("GO Corporation"));
	Ustrcpy(new.appMgr.defaultDocName, U_L("Serial I/O Demo"));
#endif

	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return(stsOK);
} /* ClsSXInit */

/*
 * Main entry point...
 */
void CDECL main(S32 argc, CHAR **argv, U32 processCount)
{

	if (processCount == 0) {
		ClsSXInit();
		AppMonitorMain(clsSX, objNull);
	} else {
		ClsSXViewInit();
		AppMain();
	}
	Unused(argc); Unused(argv);
} /* main */

