/****************************************************************************
 File: LBList.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.2  $
 $Author:   cbazzare  $
 $Date:   17 Mar 1992 13:56:16  $

 This file contains the implementation of clsLBList.
****************************************************************************/

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef WIN_INCLUDED
#include <win.h>
#endif

#ifndef VIEW_INCLUDED
#include <view.h>
#endif

#ifndef SYSGRAF_INCLUDED
#include <sysgraf.h>
#endif

#ifndef APPTAG_INCLUDED
#include <apptag.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef CONTROL_INCLUDED
#include <control.h>
#endif

#ifndef RESFILE_INCLUDED
#include <resfile.h>
#endif

#ifndef XGESTURE_INCLUDED
#include <xgesture.h>
#endif

#ifndef PEN_INCLUDED
#include <pen.h>
#endif

#ifndef STDIO_INCLUDED
#include <stdio.h>
#endif

#ifndef SYSGRAF_INCLUDED
#include <sysgraf.h>
#endif

#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif

#ifndef PREFS_INCLUDED
#include <prefs.h>
#endif

#ifndef LISTBOX_INCLUDED
#include <listbox.h>
#endif

#ifndef LIMITS_INCLUDED
#include <limits.h>
#endif

#ifndef SEL_INCLUDED
#include <sel.h>
#endif

#ifndef LABEL_INCLUDED
#include <label.h>
#endif

#ifndef KEY_INCLUDED
#include <key.h>
#endif

#ifndef STRING_INCLUDED
#include <string.h>
#endif

#ifndef LBDEMO_INCLUDED
#include "lbdemo.h"
#endif

#ifndef LBLIST_INCLUDED
#include "lblist.h"
#endif

#include <methods.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc		   	       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define MAXLENGTH	255

// default strings used for a list box row
static STRING	defaultString1[] = "NewItem";
static STRING	defaultString2[] = "Forced string";

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines					       	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 HighlightRow
****************************************************************************/
STATIC STATUS
HighlightRow (
	P_LIST_BOX_ENTRY		pArgs,
	PP_LBDEMO_APP_DATA 	pData)
{
	STATUS						s;

	// should I de-select a previous row ?
	if (  (*pData)->deselect )
		ObjCallRet(msgBorderSetSelected, (*pData)->previousSelWin, \
											(P_ARGS) false, s);
		 
	// Did I select the previous selected row (win) ?		
	if ( (*pData)->previousSelWin == pArgs->win )
	{
		// if so, update state variable 
		ObjCallRet(msgBorderSetSelected, pArgs->win, \
											(P_ARGS) pArgs->state, s);
		pArgs->state = ! pArgs->state;
		ObjCallRet(msgListBoxSetEntry, pArgs->listBox, \
											(P_ARGS) pArgs, s);
	}
	else 
	{
		// if not, reset state variable
		pArgs->state = false;
		ObjCallRet(msgBorderSetSelected, pArgs->win, \
											(P_ARGS) true, s);
	}

	(*pData)->deselect 		 = true;
	(*pData)->previousSelWin = pArgs->win;
	(*pData)->previousPos	 = pArgs->position;

} /* HighlightRow */

/****************************************************************************
	LBUtilWrite
****************************************************************************/
STATUS PASCAL
LBUtilWrite(
	OBJECT				file,
	U32					numBytes,
	P_UNKNOWN			pBuf)
{
	STREAM_READ_WRITE	write;

	write.numBytes = numBytes;
	write.pBuf = pBuf;
	return ObjCallWarn(msgStreamWrite, file, &write);
} /* LBUtilWrite */

/****************************************************************************
	LBUtilRead
****************************************************************************/
STATUS PASCAL
LBUtilRead(
	OBJECT		file,
	U32			numBytes,
	P_UNKNOWN	pBuf)
{
	STREAM_READ_WRITE	read;

	read.numBytes = numBytes;
	read.pBuf = pBuf;
	return ObjCallWarn(msgStreamRead, file, &read);
} /* LBUtilRead */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers				   	           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 LBProvideEntry
****************************************************************************/
MsgHandlerArgType(LBProvideEntry, P_LIST_BOX_ENTRY)
{
	STATUS				s;
	LIST_BOX_METRICS	metrics;
	LABEL_NEW			ln;

	Dbg(Debugf("List Box demo[%p]: msgListBoxProvideEntry", self);)

	ObjCallRet(msgListBoxGetMetrics, pArgs->listBox, &metrics, s);
	if (pArgs->position >= metrics.nEntries)
		return stsFailed;

	if ( !pArgs->data )
	{	// Allocate the instance data storage
		StsRet(OSHeapBlockAlloc(osProcessHeapId, strlen(defaultString2)+1, \
			&(pArgs->data) ), s);

		// set pArgs->data to the defaultString2 string
		strcpy (pArgs->data, defaultString2);
	}
	
	ObjCallWarn(msgNewDefaults, clsLabel, &ln);
	ln.win.flags.style |= wsParentClip;
	ln.win.flags.style &= ~(wsClipChildren | wsClipSiblings);
	ln.border.style.edge	= bsEdgeBottom;
	ln.label.pString = pArgs->data;
	ObjCallRet(msgNew, clsLabel, &ln, s);

	pArgs->win = ln.object.uid;
	pArgs->freeEntry = lbFreeDataWhenDestroyed;
	pArgs->state = false;

	// free pArgs->data
	StsWarn(OSHeapBlockFree(pArgs->data));

	pArgs->data = pNull;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBProvideEntry */

/****************************************************************************
 LBEntryGesture
****************************************************************************/
MsgHandlerWithTypes(LBEntryGesture, P_LIST_BOX_ENTRY, PP_LBDEMO_APP_DATA)
{
	P_GWIN_GESTURE			pGesture;
	BOOLEAN					copy;
	STATUS					s;

	Dbg(Debugf("List Box demo[%p]: msgListBoxEntryGesture", self);)

	copy = FALSE;
	pGesture = pArgs->arg;

	switch(ClsNum(pGesture->msg))
	{
		case ClsNum(clsXGesture):
			switch(MsgNum(pGesture->msg))
			{
				case MsgNum(xgs1Tap):
					Dbg(Debugf("xgs1Tap");)
					HighlightRow ( pArgs, pData );
					break;

				case MsgNum(xgsTapHold):
					Dbg(Debugf("xgsTapHold");)
					copy = true;
					// fall through
	
				case MsgNum(xgsPressHold):
					if ( ! copy )
					{
						Dbg(Debugf("xgsPressHold");)
					}

					// Highlight row properly
					pArgs->state = true;    			// force highlight
					HighlightRow ( pArgs, pData );

					// Give the selection to my list box
					ObjCallRet(msgSelSetOwner, theSelectionManager, 
								   		(P_ARGS) (*pData)->swWin, s);

					// initiate copy/move protocol
					ObjCallRet((copy ? msgSelBeginCopy : msgSelBeginMove), 
								  		(*pData)->swWin, 0L, s);

					break;

				case MsgNum(xgsUpCaret):
					Dbg(Debugf("xgsUpCaret");)

					// if list is empty
					if (pArgs->position == USHRT_MAX )
						pArgs->position = -1;		

					// Allocate the instance data storage
					StsRet(OSHeapBlockAlloc(osProcessHeapId, 		\
							strlen(defaultString1)+1, &(pArgs->data) ), s);

					// set pArgs->data to the defaultString1 string
					strcpy (pArgs->data, defaultString1);

					pArgs->win  = objNull;
					ObjCallWarn(msgListBoxAppendEntry, pArgs->listBox, pArgs);
					
					break;

				case MsgNum(xgsScratchOut):
				case MsgNum(xgsCross):
					Dbg(Debugf("xgsCross or xgsScratchOut");)

					ObjCallWarn(msgListBoxRemoveEntry, pArgs->listBox,	\
								  		 (P_ARGS) pArgs->position);

					(*pData)->deselect = false;
					break;

				default:
					Dbg(Debugf("Letting ancestor handle gesture");)
					return ObjCallAncestorCtxWarn(ctx);
			}
			break;

		default:
			Dbg(Debugf("Letting ancestor handle gesture");)
			return ObjCallAncestorCtxWarn(ctx);
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	LBListInit
	
	Initialize instance data of new object.
****************************************************************************/
MsgHandlerWithTypes(LBListInit, P_LB_LIST_NEW, PP_LBDEMO_APP_DATA)
{
	P_LBDEMO_APP_DATA			pInst;

	// set instance data (pointer) from newDefaults structure
	pInst = pArgs->lbList.data;

	// write instance data back to object
	ObjectWrite(self, ctx, &pInst);

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBListInit */


/****************************************************************************
	LBListFree
	
	Respond to msgFree. my listbox automatically frees list data as it 
	builds the row window. if you change my storage policy you have to 
	supply this method. 
****************************************************************************/
MsgHandlerWithTypes(LBListFree, P_ARGS, PP_LBDEMO_APP_DATA)
{
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* LBListFree */

/****************************************************************************
	LBListSave
	
	Save self to a file.
****************************************************************************/
MsgHandlerWithTypes(LBListSave, P_OBJ_SAVE, PP_LBDEMO_APP_DATA)
{
	LIST_BOX_METRICS	lbm;
	LIST_BOX_ENTRY		lbn;
  	CONTROL_STRING		cntrString;
	STRING				buf[MAXLENGTH];
	U16					i;
	STATUS 				s;

	Dbg(Debugf("List Box : save");)

	// get number of elements in the list box 
	ObjCallRet(msgListBoxGetMetrics, self, &lbm, s);

	// write number of elements out
	StsRet(LBUtilWrite(pArgs->file, SizeOf(U16), &lbm.nEntries), s);

	// write list contents out
  	for (i=0; i<lbm.nEntries; i++)
	{
		// get label window for position i
		lbn.position = i;
		ObjCallRet(msgListBoxGetEntry, self, &lbn, s);
		
		// get label string size
		cntrString.len = 0;
		ObjCallRet(msgLabelGetString, lbn.win, &cntrString, s);

		// write label string size out
		StsRet(LBUtilWrite(pArgs->file, SizeOf(U16), &cntrString.len), s);

		// get label string
		cntrString.pString = buf;
		ObjCallRet(msgLabelGetString, lbn.win, &cntrString, s);
		
		// write label string out
		StsRet(LBUtilWrite(pArgs->file, cntrString.len, buf), s);
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* LBListSave */


/****************************************************************************
	LBListRestore
	
	Restore self from a file.
****************************************************************************/
MsgHandlerWithTypes(LBListRestore, P_OBJ_RESTORE, PP_LBDEMO_APP_DATA)
{
	P_STRING			buf;
	LIST_BOX_ENTRY		lbe;
	U16					i,num,len;
	STATUS 				s;

	Dbg(Debugf("List Box : restore");)

	// read number of elements of the list
	StsRet(LBUtilRead(pArgs->file, SizeOf(U16), &num), s);

	// read list contents in
	for (i=0; i<num; i++)
	{
		// read label string size in
		StsRet(LBUtilRead(pArgs->file, SizeOf(U16), &len), s);

		// Allocate data for the label string
		StsRet(OSHeapBlockAlloc(osProcessHeapId, len, &buf), s);

		// read label string in
		StsRet(LBUtilRead(pArgs->file, len, buf), s);

		// add element to the list
		lbe.position = i;		
		lbe.data = buf;
		lbe.win  = objNull;
		ObjCallWarn(msgListBoxInsertEntry, self, &lbe);
	}

	return stsOK;
	MsgHandlerParametersNoWarning;
} /* LBListRestore */


/****************************************************************************
	LBListSelYield
	
	msgSelYield from selection manager.
	if somebody gets the selection from you, you should unhighlight
	your selection. My listbox doesn't since I want the row selected 
	to be always highlighted.
****************************************************************************/
MsgHandlerWithTypes(LBListSelYield, P_ARGS, PP_LBDEMO_APP_DATA)
{

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBListSelYield */

/****************************************************************************
	LBListRemoveSel
	
	 msgListBoxRemoveSel, this message removes the previous selection
****************************************************************************/
MsgHandlerWithTypes(LBListRemoveSel, P_ARGS, PP_LBDEMO_APP_DATA)
{

	ObjCallWarn(msgListBoxRemoveEntry, self, 	 \
								(P_ARGS) (*pData)->previousPos);

	(*pData)->deselect = false;

	return stsOK;
	MsgHandlerParametersNoWarning;

} /* LBListRemoveSel */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Installation 	 						  	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	ClsLBListInit
	
	Install the class.
****************************************************************************/
STATUS PASCAL
ClsLBListInit (void)
{
	CLASS_NEW		new;
	STATUS			s;

//	Debugger();

	// install the class
	ObjCallJmp(msgNewDefaults, clsClass, &new, s, Error);
	new.object.uid			= clsLBList;
	new.object.key			= 0;
	new.cls.pMsg			= clsLBListTable;
	new.cls.ancestor		= clsListBox;
	new.cls.size			= SizeOf(P_LBDEMO_APP_DATA);
	new.cls.newArgsSize	= SizeOf(LB_LIST_NEW);
	ObjCallJmp(msgNew, clsClass, &new, s, Error);

	return stsOK;

Error:
	return s;
} /* ClsLBListInit */
