*Version for 8 Khz/ 12 LPC coefficients
*
*
	   OPTION BUNLIST,DUNLIST
***********************************************************
*   Start of program
***********************************************************
	   AORG	  #0000
	   SBR	  GOGO	     -Power up Vector
	   SBR	  GOGO		(twice makes unconditional)
GOGO	   BR	  GO	     -Branch to	start of program
*
***********************************************************
*   Interrupt vectors
***********************************************************
	   AORG	  #0010
	   SBR	  INT2_01    -Timer Underflow, PCM=0, LPC=1
	   SBR	  INT2_01    -Timer Underflow, PCM=0, LPC=1
	   SBR	  INT2_00    -Timer Underflow, PCM=0, LPC=0
	   SBR	  INT2_00    -Timer Underflow, PCM=0, LPC=0
	   SBR	  INT2_11    -Timer Underflow, PCM=1, LPC=1
	   SBR	  INT2_11    -Timer Underflow, PCM=1, LPC=1
	   SBR	  INT2_10    -Timer Underflow, PCM=1, LPC=0
	   SBR	  INT2_10    -Timer Underflow, PCM=1, LPC=0
	   SBR	  INT1_01    -PPC < 200	hex interrupt
	   SBR	  INT1_01    -PPC < 200	hex interrupt
	   SBR	  INT1_00    -Pin (B1) goes low	interrupt
	   SBR	  INT1_00    -Pin (B1) goes low	interrupt
	   SBR	  INT1_11    -10 kHz Clock interrupt
	   SBR	  INT1_11    -10 kHz Clock interrupt
	   SBR	  INT1_10    -20 kHz Clock interrupt
	   SBR	  INT1_10    -20 kHz Clock interrupt
*
INT1_01	   BR	  INTP	     -PPC < 200	hex interrupt
*
INT2_01
INT2_10
INT2_11
INT1_00
INT1_10
INT1_11	   CLA
	   RETI
*
INT2_00
	   CLA
	   RETI
*+-----------------------------------------------+
*   TSP50C10 LPC SYNTHESIS PROGRAM		 +
*+-----------------------------------------------+
*   COPYRIGHT 1989 TI -	SPEECH PRODUCTS
*+-----------------------------------------------+
*   This program uses D6   speech data tables
*+-----------------------------------------------+
*   RAM	MAP
*+-----------------------------------------------+
*    +----+----+----+----+----+----+----+----+
*    | 00 | 01 | 02 | 03 | 04 |	05 | 06	| 07 |
*    +----+----+----+----+----+----+----+----+
*    |EN- | EN | K12| K11| K10|	K9 | K8	| K7 |
*    |TMP |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 08 | 09 | 0A | 0B | 0C |	0D | 0E	| 0F |
*    +----+----+----+----+----+----+----+----+
*    | K6 | K5 | K4 | K3 | K2 |	K1 | C1	| C2 |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 10 | 11 | 12 | 13 | 14 |	15 | 16	| 17 |
*    +----+----+----+----+----+----+----+----+
*    | EN      | EN	 | PH |	   | PH	|    |
*    | V2      | V1	 | V2 |	   | V1	|    |
*    +----+----+----+----+----+----+----+----+
*    | 18 | 19 | 1A | 1B | 1C |	1D | 1E	| 1F |
*    +----+----+----+----+----+----+----+----+
*    | K1      | K1	 | K2	   | K2	|    |
*    | V2      | V1	 | V2	   | V1	|    |
*    +----+----+----+----+----+----+----+----+
*    | 20 | 21 | 22 | 23 | 24 |	25 | 26	| 27 |
*    +----+----+----+----+----+----+----+----+
*    | K3 |    | K3 |	 | K4 |	   | K4	|    |
*    | V2 |    | V1 |	 | V2 |	   | V1	|    |
*    +----+----+----+----+----+----+----+----+
*    | 28 | 29 | 2A | 2B | 2C |	2D | 2E	| 2F |
*    +----+----+----+----+----+----+----+----+
*    | K5 | K5 | K6 | K6 | K7 |	K7 | K8	| K8 |
*    | V2 | V1 | V2 | V1 | V2 |	V1 | V2	| V1 |
*    +----+----+----+----+----+----+----+----+
*    | 30 | 31 | 32 | 33 | 34 |	35 | 36	| 37 |
*    +----+----+----+----+----+----+----+----+
*    | K9 | K9 | K10| K10| K11|	K11| K12| K12|
*    | V2 | V1 | V2 | V1 | V2 |	V1 | V2	| V1 |
*    +----+----+----+----+----+----+----+----+
*    | 38 | 39 | 3A | 3B | 3C |	3D | 3E	| 3F |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 40 | 41 | 42 | 43 | 44 |	45 | 46	| 47 |
*    +----+----+----+----+----+----+----+----+
*    |TIMR|SCAL|FLAG|FLAG|MODE|	   |	|    |
*    |	  |    |    | 1	 |BUF |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 48 | 49 | 4A | 4B | 4C |	4D | 4E	| 4F |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 50 | 51 | 52 | 53 | 54 |	55 | 56	| 57 |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 58 | 59 | 5A | 5B | 5C |	5D | 5E	| 5F |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 60 | 61 | 62 | 63 | 64 |	65 | 66	| 67 |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 68 | 69 | 6A | 6B | 6C |	6D | 6E	| 6F |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 70 | 71 | 72 | 73 | 74 |	75 | 76	| 77 |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*    | 78 | 79 | 7A | 7B | 7C |	7D | 7E	| 7F |
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|    |
*    |	  |    |    |	 |    |	   |	|    |
*    +----+----+----+----+----+----+----+----+
*	    FLAG BYTE (42)
*    +----+----+----+----+----+----+----+----+
*    | BT7| BT6| BT5| BT4| BT3|	BT2| BT1| BT0|
*    +----+----+----+----+----+----+----+----+
*    |UNVO|SLNO|NOIN|UNVN|SLNN|UPDT|REPT|STOP|
*	    FLAG BYTE (43)
*    +----+----+----+----+----+----+----+----+
*    | BT7| BT6| BT5| BT4| BT3|	BT2| BT1| BT0|
*    +----+----+----+----+----+----+----+----+
*    |	  |    |    |	 |    |	   |	|INTF|
*    +----+----+----+----+----+----+----+----+
*	    MODE BYTE (44)
*    +----+----+----+----+----+----+----+----+
*    | BT7| BT6| BT5| BT4| BT3|	BT2| BT1| BT0|
*    +----+----+----+----+----+----+----+----+
*    |UNV |SLV |RAM |EXTR|INT2|PCM |LPC	|INT1|
*    +----+----+----+----+----+----+----+----+
*-------------------------------------------------
*|     ADDRESS LABELS FOR SYNTHESIS ROUTINE	 |
*-------------------------------------------------
********************************************
*      SYNTHESIZER RAM LOCATIONS
********************************************
* NOTE - NEVER CHANGE LOCATIONS	#01 TO #0F
*
EN_TEMP	   EQU	  #00	 -Temp storage for EN value
EN	   EQU	  #01	 -Energy working value
K12	   EQU	  #02	 -K12 Working Value
K11	   EQU	  #03	 -K11 Working Value
K10	   EQU	  #04	 -K10 Working Value
K9	   EQU	  #05	 -K9 Working Value
K8	   EQU	  #06	 -K8 Working Value
K7	   EQU	  #07	 -K7 Working Value
K6	   EQU	  #08	 -K6 Working Value
K5	   EQU	  #09	 -K5 Working Value
K4	   EQU	  #0A	 -K4 Working Value
K3	   EQU	  #0B	 -K3 Working Value
K2	   EQU	  #0C	 -K2 Working Value
K1	   EQU	  #0D	 -K1 Working Value
C1	   EQU	  #0E	 -C1 Parameter
C2	   EQU	  #0F	 -C2 Parameter
ENV2	   EQU	  #10	 -ENERGY New Value MSB
ENV1	   EQU	  #12	 -ENERGY Current Value MSB
PHV2	   EQU	  #14	 -PITCH	New Value MSB
PHV1	   EQU	  #16	 -PITCH	Current	Value MSB
K1V2	   EQU	  #18	 -K1 New Value MSB
K1V1	   EQU	  #1A	 -K1 Current Value MSB
K2V2	   EQU	  #1C	 -K2 New Value MSB
K2V1	   EQU	  #1E	 -K2 Current Value MSB
K3V2	   EQU	  #20	 -K3 New Value MSB
K3V1	   EQU	  #22	 -K3 Current Value MSB
K4V2	   EQU	  #24	 -K4 New Value MSB
K4V1	   EQU	  #26	 -K4 Current Value MSB
K5V2	   EQU	  #28	 -K5 New Value
K5V1	   EQU	  #29	 -K5 Current Value
K6V2	   EQU	  #2A	 -K6 New Value
K6V1	   EQU	  #2B	 -K6 Current Value
K7V2	   EQU	  #2C	 -K7 New Value
K7V1	   EQU	  #2D	 -K7 Current Value
K8V2	   EQU	  #2E	 -K8 New Value
K8V1	   EQU	  #2F	 -K8 Current Value
K9V2	   EQU	  #30	 -K9 New Value
K9V1	   EQU	  #31	 -K9 Current Value
K10V2	   EQU	  #32	 -K10 New Value
K10V1	   EQU	  #33	 -K10 Current Value
K11V2	   EQU	  #34	 -K11 New Value
K11V1	   EQU	  #35	 -K11 Current Value
K12V2	   EQU	  #36	 -K12 New Value
K12V1	   EQU	  #37	 -K12 Current Value
*
*
*    LPC status	variable locations
*
TIMER	   EQU	  #40	 -Stored Timer value for update
SCALE	   EQU	  #41	 -Timer	register value used in INTP
FLAGS	   EQU	  #42	 -Flags	used in	LPC synthesis
FLAG1	   EQU	  #43	 -Flags	used in	LPC synthesis
MODE_BUF   EQU	  #44	 -Stored value of Mode register

*+---------------------------------------------------------+
* Constant definitions					   +
*+---------------------------------------------------------+
*	Data Port address constants.
*
PORTA		EQU    #80	-Data Input A
PORTB		EQU    #84	-Data Input B
PERAA		EQU    #81	-Pull Up Enable A
PERBA		EQU    #85	-Pull Up Enbale B
DDRAA		EQU    #82	-A direction.
DDRBA		EQU    #86	-B direction.
DORAA		EQU    #83	-A Data Output.
DORBA		EQU    #87	-B Data Output.
*
*	Data direction and I/O INIT and Control value CONSTANTS
*
LED_ON          EQU     #04     ORCM for A2 ON.
LED_OFF         EQU     #FB     ANDCM for A3 OFF.
SPEAKIT		EQU	#01	TSTCA constant for switches.
REPEAT		EQU	#02	TSTCA constant for switches.
*
PERAC           EQU     #03     A0-A1 has pull-up; A4-A7 are o.p.
PERBC           EQU     #03     B0/1 has pull-up.
DDRAC           EQU     #FC     PA4 to PA7 are O.P.
DDRBC		EQU	0	All at input for Port B.
*
*
TBEEP		EQU	10	Beep for timeout; 2 secs min.
T_END		EQU	60	Power out time; approx. 30 seconds.
END_SENT        	EQU     	8	Last sentence in list.
P_UP            	EQU     	08      	Set power on bit.
*====================================================
************************************************************
*   Constant Definitions
************************************************************
*
*   Bit	Size of	Speech parameters
*
EBITS	   EQU	  4	 -Number of Energy Bits
PBITS	   EQU	  7	 -Number of Pitch Bits
RBITS	   EQU	  1	 -Number of Repeat Bits
K1BITS	   EQU	  6	 -Number of K1 Bits
K2BITS	   EQU	  6	 -Number of K2 Bits
K3BITS	   EQU	  5	 -Number of K3 Bits
K4BITS	   EQU	  5	 -Number of K4 Bits
K5BITS	   EQU	  4	 -Number of K5 Bits
K6BITS	   EQU	  4	 -Number of K6 Bits
K7BITS	   EQU	  4	 -Number of K7 Bits
K8BITS	   EQU	  3	 -Number of K8 Bits
K9BITS	   EQU	  3	 -Number of K9 Bits
K10BITS	   EQU	  3	 -Number of K10	Bits
K11BITS    EQU	  3	 -Number of K11 Bits
K12BITS    EQU	  3	 -Number of K12 Bits
*
*   Prescale Values
*
*   PSvalue = Round(Samples * 2	* 30)/256  - 1
*
*   This comes from the	fact that samples come every 30
*   instruction	cycles in LPC mode.  The factor	of 2
*   accounts for the cycle steal that happens in
*   LPC	mode.  When not	in LPC mode, samples come
*   every 60 instruction cycles, so it comes out the
*   same.  The 256 divider is the full scale Timer
*   register value.  The 0.5 addition is there
*   to take care of rounding.
*
SAMPLES	   EQU	  160			-Samples per frame 20 msec at 8 Khz
PSVALUE	   EQU	  (SAMPLES*60/256)+(1/2) -Prescale Value
*
*   Device Constants
*
C1_Value   EQU	  #F61	 -C1 Value
C2_Value   EQU	  #B67	 -C2 Value
MAX_RAM	   EQU	  #7F	 -Highest RAM location
ISAMPLE	   EQU	  #32	 -Instruction cycles per sample
*
*   Special Energy Values
*
ESTOP	   EQU	  15	-Stop code
ESILENCE   EQU	  0	-Silence Code
*
*   Special Pitch Value
*
PUnVoiced  EQU	  0	-UnVoiced Frame	Code
UNV_PITCH  EQU	  #18	-Pitch used for	Unvoiced Frames
*
*   End	of sentence signal
*
StopWord   EQU	  #FF
*
*   FLAGS bit usage (and Set Masks)
*
STOPFLAG   EQU	  #01	-Stop frame reached = 1
R_FLAG	   EQU	  #02	-Repeat	Frame =	1
Update_Flg EQU	  #04	-Set high on update
Sil_Flg1   EQU	  #08	-New frame is silent = 1
Unv_Flg1   EQU	  #10	-New frame is unvoiced = 1
Int_Inh	   EQU	  #20	-Change	between	Voice and UnV =	1
Sil_Flg2   EQU	  #40	-Current frame is silent = 1
Unv_Flg2   EQU	  #80	-Current frame is unvoiced = 1
*
*   FLAG1 bit usage (and Set Masks)
*
Int_Off	   EQU	  #01	-Disable INTP routine =	1
*
*   MODE Register Bit Definitions
*
INT1	   EQU	  #01	-Enable	Level 1	interrupt
LPC	   EQU	  #02	-Enable	LPC synthesis
PCM	   EQU	  #04	-Enable	PCM synthesis
ENA2	   EQU	  #08	-Enable	Level 2	interrupt
EXTROM	   EQU	  #10	-Set external ROM mode
RAMROM	   EQU	  #20	-Enable	GETs from RAM
MASTER	   EQU	  #40	-Master/Slave Toggle
UNV	   EQU	  #80	-Enable	Unvoiced excitation
***********************************************************
* Application Program Variables
*
CONC_NUM   EQU    #50
PHR_NUM    EQU    #51
LSW_ADDR   EQU    #52
MSW_ADDR   EQU    #53
CUR_CONC   EQU    #54
***********************************************************
*   Do program INITs
***********************************************************
GO	   TMAD	  0
*
	   CLA		     -Initialize mode register
	   TAMODE
*
	   CLX
RAM_LOOP   TAMIX	     -Initialize All RAM to zeros
	   XGEC	  MAX_RAM+1
	   BR	  PROGRAM    -Go excecute program.
	   BR	  RAM_LOOP
*
***********************************************************
*   Speak Utterance - Phrase number in A register
***********************************************************
SPEAK	   INTGR
	   SALA		     -Double index to get offset
	   ACAAC  PHRTABLE   -Add base of table
	   LUAB		     -get address MSB
	   IAC
	   LUAA		     -Get address LSB
	   XBA
	   SALA4	     -Combine MSB and LSB
	   SALA4
	   ABAAC
	   LUAPS	     -Load Speech Address Register

	   CLA		     -Kill K11 and K12 parameters
	   TAMD	  K11
	   TAMD	  K12

	   TAMD	  FLAGS	     -Init flags for speech

	   CLA		     -Load C2 parameter
	   ACAAC  C2_Value	 (a device constant)
	   TAMD	  C2

	   CLA		      -Load C1 parameter
	   ACAAC  C1_Value	 (a device constant)
	   TAMD	  C1
* * * *	*
* Now we give an initial value to the Pitch in case the
* utterance starts with	a silent frame.
* * * *	*
	   ACAAC  #0C
	   TAMD	  PHV1
	   TAMD	  PHV2
* * * *	*
* Now we preload the first two frames.
* * * *	*
	   CALL	  UPDATE     -Load first frame
	   CALL	  UPDATE     -Load 2nd frame
* * * *	*
* Now we give some values to the Timer and Prescaler so
* that we can do a valid interpolation on the first call to
* INTP.	 Then I	do the first call to INTP to preload the
* first	valid interpolation.
* * * *	*
	   TCA	  PSVALUE    -Initialize prescale
	   TAPSC
	   TCA	  #7F	     -Pretend there was	a previous
	   TAMD	  TIMER		 update
	   TCA	  #FF	     -Set timer	to max value to
	   TATM			 disable interpolation
	   CALL	  INTP	     -Do first interpolation

* * * *	*
* Now we enable	the synthesizer	for speech
*
* We do	this in	two stages so that we can reset	the
* interrupt pending latch without it being immediately
* set again by the B1(low) interrupt.
* * * *	*
	   TCX	  MODE_BUF   -Turn on LPC synthesizer
	   ORCM	  LPC
	   TMA
	   TAMODE

	   RETI		     -Reset interrupt pending latch

	   ORCM	  INT1	     -Enable interrupt
	   TMA
	   TAMODE

* * * *	*
* Now we loop until the	utterance is complete.	When the
* utterance is finished, the routine UPDATE will execute a
* RETN instruction which will exit this	routine.  In the
* mean time, this loop will poll the Timer register and
* update the frame whenever it underflows.
* * * *	*
SPEAK_LP
	   TCX	  FLAGS
	   TSTCM  Update_Flg -Is Update	already	done?
	   BR	  SPEAK_LP	yes, loop

	   TCX	  TIMER	     -Get old timer
	   TMA			register value
	   TAB			into B register

	   TTMA		     -Get new timer register
	   SARA			value and scale	it.

	   TAM		     -Store new	value
	   XBA		     -Exchange new and old values
	   SBAAN	     -Subtract new from	old
	   BR	  UPDATE     -If underflowed, do an update

	   TMA		     -Get new timer value again.
	   ANEC	  0	     -Is it about to underflow?
	   BR	  SPEAK_LP	 no, loop again
	   BR	  UPDATE	 yes, do update	now
* * * *	*
* INTERPOLATION	ROUTINE
* * * *	*
* First	we need	to get the current value of the	timer
* register and store it	away.  It will be divided by two
* with the SARA	instruction so that the	most significant
* bit is guaranteed to be zero so that it will always be
* interpreted as a positive number during the
* interpolation.
* * * *	*
INTP	INTGR		     -Ensure we	are in integer mode
	TTMA		     -Get timer	register contents
	SARA			shift to make positive
	TAMD	SCALE		and store it
* * * *	*
* See if this routine is enabled.  If it is not, exit
* the routine.
* * * *	*
	TCX	FLAG1	     -Point to flag
	TSTCM	Int_Off	     -If routine disabled...
	BR	IRETI	      ...branch	to exit	point
* * * *	*
* Next we need to see if the frame type	has changed between
* voiced and unvoiced frames.  If it has, we do	not want to
* interpolate between them; we just want to use	the current
* frame	values until we	have two frames	of the same type to
* interpolate between.
* * * *	*
TINTP	TCX	FLAGS	     -Point to status flags
	TSTCM	Int_Inh	     -Is interpolation inhibited?
	BR	NOINT		yes, use inhibit code
	BR	INTPCH		no, use	interpolation code
* * * *	*
* The following	code is	reached	if interpolation is
* inhibited. It	sets the stored	timer value to #7F which
* effectively forces the interpolation to yield	the old
* values for the working values, thus effectively disabling
* interpolation.
* * * *	*
NOINT	TCA	#7F	     -Set Scale	factor to
	TAMD	SCALE		highest	value
*
* If the new frame has a voicing different from	the last
* frame, we want to zero the energy until the Unvoiced bit
* in the mode register is changed and the K parameters are
* all to the correct values.  We therefore check in this
* section of code to see if the	frame voicing is different
* from the setting in the Mode Register.  If it	is, we zero
* the energy until after the Mode Register is modified.
*
	TCX	FLAGS
	TSTCM	Unv_Flg2      Is new frame unvoiced?
	BR	Uv		 yes, go to unvoiced branch

	TCX	Mode_Buf      New frame	is voiced
	TSTCM	UNV	      Has mode changed to unvoiced?
	BR	ClrEN		  yes, clear the energy
	BR	INTPCH		  no, no action	required

Uv	TCX	Mode_Buf      New frame	is unvoiced
	TSTCM	UNV	      Has voicing mode changed?
	BR	INTPCH		  no, no action	required

ClrEN	CLA		     Zero Energy during	update
	TAMD	EN
	BR	INTPCH

* * * *	*
* Interpolate Pitch and	write the result to the	pitch
* register
* * * *	*
INTPCH	TCX	PHV2	     Combine new pitch and fractional
	TMAIX		     pitch and leave in
	SALA4		     the B register
	AMAAC
	IXC
	TAB
	TMAIX		  -Combine current pitch and
	SALA4		     current fractional	pitch
	AMAAC		     and leave in A register

	SBAAN		  -(Pcurrent - Pnew)
	TCX	SCALE
	AXMA		  -(Pcurrent - Pnew) * Timer
	ABAAC		  -Pnew	+ (Pcurrent - Pnew)* Timer
	SALA		  -Double value	to index excitation
	TASYN		  -Write to pitch register

* * * *	*
* Interpolate Energy and store the result in the working
* register
* * * *	*
	TCX	ENV2	  -Combine new energy and fractional
	TMAIX		     energy and	leave in
	SALA4		     the B register
	AMAAC
	IXC
	TAB
	TMAIX		  -Combine current energy and
	SALA4		     current fractional	energy &
	AMAAC		     leave in A	register

	SBAAN		  -(Ecurrent - Enew)
	TCX	SCALE
	AXMA		  -(Ecurrent - Enew) * Timer
	ABAAC		  -Enew	+ (Ecurrent - Enew)*Timer
	TAMD	EN_TEMP	  -Store Energy	till mode is switched

	EXTSG		  -Allow negative K parameters
* * * *	*
* Interpolate K1 and store the result in the working K1
* register
* * * *	*
	TCX	K1V2	  -Combine New K1 and New
	TMAIX		      fractional K1 and
	SALA4		      leave in the B register
	AMAAC
	IXC
	TAB

	TMAIX		  -Combine current K1 and
	SALA4		     current fractional	K1 and
	AMAAC		     leave in the A register

	SBAAN		  -(K1current -	K1new)
	TCX	SCALE
	AXMA		  -(K1current -	K1new) * Timer
	ABAAC		  -K1new+(K1current-K1new)* Timer
	TAMD	K1	  -Load	interpolated K1	value
* * * *	*
* Interpolate K2 and store the result in the
* working K2 register
* * * *	*
	TCX	K2V2	  -Combine New K2 and New
	TMAIX		     fractional	K2 and
	SALA4		     leave in the B register
	AMAAC
	IXC
	TAB

	TMAIX		  -Combine current K2 and
	SALA4		     current fractional	K2 and
	AMAAC		     leave in the A register

	SBAAN		  -(K2current -	K2new)
	TCX	SCALE
	AXMA		  -(K2current -	K2new) * Timer
	ABAAC		  -K2new+(K2current-K2new)* Timer
	TAMD	K2	  -Load	interpolated K2	value
* * * *	*
* Interpolate K3 and store the result in the working K3
* register
* * * *	*
	TCX	K3V2	  -Combine New K3 and New
	TMAIX		     fractional	K3 and
	SALA4		     leave in the B register
	AMAAC
	IXC
	TAB

	TMAIX		  -Combine current K3 and
	SALA4		     current fractional	K3 and
	AMAAC		     leave in the A register

	SBAAN		  -(K3current -	K3new)
	TCX	SCALE
	AXMA		  -(K3current -	K3new) * Timer
	ABAAC		  -K3new+(K3current-K3new)* Timer
	TAMD	K3	  -Load	interpolated K3	value
* * * *	*
* Interpolate K4 and store the result in the working K4
* register
* * * *	*
	TCX	K4V2	  -Combine New K4 and New
	TMAIX		     fractional	K4 and
	SALA4		     leave in the B register
	AMAAC
	IXC
	TAB

	TMAIX		  -Combine current K4 and
	SALA4		     current fractional	K4 and
	AMAAC		     leave in the A register

	SBAAN		  -(K4current -	K4new)
	TCX	SCALE
	AXMA		  -(K4current -	K4new) * Timer
	ABAAC		  -K4new+(K4current-K4new)* Timer
	TAMD	K4	  -Load	interpolated K4	value
* * * *	*
* Interpolate K5 and store the result in the working K5
* register
* * * *	*
	TCX	K5V2	  -Put New K5 (adjusted	to
	TMAIX		     12	bits) in B register
	SALA4
	TAB
	TMAIX		  -Put Current K5 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K5current -	K5new)
	TCX	SCALE
	AXMA		  -(K5current -	K5new) * Timer
	ABAAC		  -K5new+(K5current-K5new)* Timer
	TAMD	K5	  -Load	interpolated K5	value
* * * *	*
* Interpolate K6 and store the result in the working K6
* register
* * * *	*
	TCX	K6V2	  -Put New K6 (adjusted	to
	TMAIX		     12	bits) in B register
	SALA4
	TAB
	TMAIX		  -Put Current K6 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K6current -	K6new)
	TCX	SCALE
	AXMA		  -(K6current -	K6new) * Timer
	ABAAC		  -K6new+(K6current-K6new)* Timer
	TAMD	K6	  -Load	interpolated K6	value
* * * *	*
* Interpolate K7 and store the result in the working K7
* register
* * * *	*
	TCX	K7V2	  -Put New K7 (adjusted	to
	TMAIX		     12	bits) in B register
	SALA4
	TAB
	TMAIX		  -Put Current K7 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K7current -	K7new)
	TCX	SCALE
	AXMA		  -(K7current -	K7new) * Timer
	ABAAC		  -K7new+(K7current-K7new)* Timer
	TAMD	K7	  -Load	interpolated K7	value
* * * *	*
* Interpolate K8 and store the result in the working K8
* register
* * * *	*
	TCX	K8V2	  -Put New K8 (adjusted	to
	TMAIX		     12	bits) in B register
	SALA4
	TAB

	TMAIX		  -Put Current K8 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K8current -	K8new)
	TCX	SCALE
	AXMA		  -(K8current -	K8new) * Timer
	ABAAC		  -K8new+(K8current-K8new)* Timer
	TAMD	K8	  -Load	interpolated K8	value
* * * *	*
* Interpolate K9 and store the result in the working K9
* register
* * * *	*
	TCX	K9V2	  -Put New K9 (adjusted	to
	TMAIX		     12	bits) in B register
	SALA4
	TAB

	TMAIX		  -Put Current K9 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K9current -	K9new)
	TCX	SCALE
	AXMA		  -(K9current -	K9new) * Timer
	ABAAC		  -K9new+(K9current-K9new)* Timer
	TAMD	K9	  -Load	interpolated K8	value
* * * *	*
* Interpolate K10 and store the	result in the working K10
* register
* * * *	*
	TCX	K10V2	  -Put New K10 (adjusted to
	TMAIX		     12	bits) in B register
	SALA4
	TAB

	TMAIX		  -Put Current K10 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K10current - K10new)
	TCX	SCALE
	AXMA		  -(K10current - K10new) * Timer
	ABAAC		  -K10new+(K10current-K10new)*Timer
	TAMD	K10	  -Load	interpolated K10 value
* * * *	*
* K11 and K12 are  needed for LPC 12
*
* Interpolate K11 and store the	result in the working K11
* register
*
	TCX	K11V2	  -Put New K11 (adjusted to
	TMAIX		     12	bits) in B register
	SALA4
	TAB

	TMAIX		  -Put Current K11 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K11current - K11new)
	TCX	SCALE
	AXMA		  -(K11current - K11new) * Timer
	ABAAC		  -K11new+(K11current-K11new)*Timer
	TAMD	K11	  -Load	interpolated K11 value
*
* Interpolate K12 and store the	result in the working
* K12 register
*
	TCX	K12V2	  -Put New K12 (adjusted to
	TMAIX		     12	bits) in B register
	SALA4
	TAB

	TMAIX		  -Put Current K12 (adjusted to
	SALA4		     12	bits) in A register

	SBAAN		  -(K12current - K12new)
	TCX	SCALE
	AXMA		  -(K12current - K12new) * Timer
	ABAAC		  -K12new+(K12current-K12new)*Timer
	TAMD	K12	  -Load	interpolated K12 value
*
* * * *	*
* Set voiced/unvoiced mode according to	current	frame type.
* This is done in a two	step fashion:  first the value in
* the MODE_BUF register	is adjusted with an AND	or OR
* operation, then the result is	written	to the synthesizer
* with a TAMODE	operation.  We do it this way to keep a	copy
* of the current status	of the synthesizer mode	at all time.
* * * *	*
STMODE	INTGR		      -Back to integer mode
	TCX	FLAGS
	ANDCM	~Update_Flg   -Signal that interp done
	TSTCM	Unv_Flg2      -Is current frame	unvoiced?
	BR	SETUV	      -yes, set	mode to	unvoiced
	TCX	MODE_BUF	 no, ...
	ANDCM	~UNV		 ...set	mode to	voiced
	TMA
	TAMODE

	TMAD	EN_TEMP	      -Change Energy parameter
	TAMD	EN		  to correct value

	RETI		      -Return from interrupt
	RETN		      -Return from first call

SETUV	TCX	MODE_BUF      -Current frame is	unvoiced, so
	ORCM	UNV	      -set mode	to unvoiced.
	TMA
	TAMODE

	TMAD	EN_TEMP	      -Change Energy parameter
	TAMD	EN		 to correct value.

IRETI	RETI		      -Return from interrupt
	RETN		      -Return from first call
* * * *	*
* Update the parameters	for a new frame
* * * *	*
* First	we inhibit the operation of the	interpolation
* routine.
* * * *	*
UPDATE	TCX	MODE_BUF
	ANDCM	~INT1
	TMA
	TAMODE
* * * *	*
* To prevent double updates, if	the stored value of the
* timer	register is zero, then we need to change it to #7F.
* If we	do not do this,	then the polling routine will
* discover an underflow	and call Update	a second time.
* * * *	*
	TCX	TIMER	     -Get stored value
	TMA			of Timer into A

	ANEC	0	     -Is it zero?
	BR	UPDT00		no, do nothing
	TCA	#7F		yes, replace value
	TAM
* * * *	*
* First	we need	to test	to see if a stop frame was
* encountered on the last pass through the routine.   If the
* previous frame was a stop frame, we need to turn off the
* synthesizer and stop speaking.
* * * *	*
UPDT00	TCX	FLAGS
	TSTCM	STOPFLAG     -Was stop frame encountered
	BR	STOP		yes, stop speaking
* * * *	*
* Transfer the state of	the previous frame to the Unvoiced
* flag (Current).
* * * *	*
	TSTCM	Unv_Flg1     -Was previous frame unvoiced?
	BR	SUNVL		yes, current frame=unvoiced
	ANDCM	~Unv_Flg2	no, current frame=voiced
	BR	TSIL		    and	continue

SUNVL	ORCM	Unv_Flg2     -Set current frame	unvoiced.
* * * *	*
* Transfer the state of	the previous frame to the
* Silence flag (Current).
* * * *	*
TSIL	TSTCM	Sil_Flg1     -Was previous frame silent?
	BR	SSIL		yes, current frame  = silent
	ANDCM	~Sil_Flg2	no, current frame not silent
	BR	ZROFLG		    and	continue

SSIL	ORCM	Sil_Flg2     -Set current frame	silent
* * * *	*
* Reset	the Repeat Flag, new Silence Flag, new Unvoiced
* Flag,	and Interpolation Inhibit flag so that new
* values can be	loaded in this routine.
* * * *	*
ZROFLG	TCX	FLAGS
	ANDCM	#C5
* * * *	*
* Transfer the new frame parameters into the
* storage location used	for the	current	frame parameters.
* * * *	*
	TCX	ENV2	   -Transfer new frame energy
	TMAIX		      to current frame location
	TAMD	ENV1
	TMAIX		   -Transfer new fractional energy
	IXC		      to current frame location
	TAMIX
*-----PITCH-----
	TMAIX		   -Transfer new frame pitch
	TAMD	PHV1	      to current frame location

	TMAIX		   -Transfer new fractional pitch
	IXC		      to current frame location
	TAMIX
*-----K1-----
	TMAIX		   -Transfer new frame K1 parameter
	TAMD	K1V1	      to current frame location
	TMAIX		   -Transfer new fractional K1
	IXC		      to current frame location
	TAMIX
*-----K2-----
	TMAIX		   -Transfer new frame K2 parameter
	TAMD	K2V1	      to current frame location
	TMAIX		   -Transfer new fractional K2
	IXC		      to current frame location
	TAMIX
*-----K3-----
	TMAIX		   -Transfer new frame K3 parameter
	TAMD	K3V1	      to current frame location
	TMAIX		   -Transfer new fractional K3
	IXC		      to current frame location
	TAMIX
*-----K4-----
	TMAIX		   -Transfer new frame K4 parameter
	TAMD	K4V1	      to current frame location
	TMAIX		   -Transfer new fractional K4
	IXC		      to current frame location
	TAMIX
*-----K5-----
	TMAIX		   -Transfer new frame K5 parameter
	TAMIX		      to current frame location
*-----K6-----
	TMAIX		   -Transfer new frame K6 parameter
	TAMIX		      to current frame location
*-----K7-----
	TMAIX		   -Transfer new frame K7 parameter
	TAMIX		      to current frame location
*-----K8-----
	TMAIX		   -Transfer new frame K8 parameter
	TAMIX		      to current frame location
*-----K9-----
	TMAIX		   -Transfer new frame K9 parameter
	TAMIX		      to current frame location
*-----K10-----
	TMAIX		   -Transfer new frame K10 parameter
	TAMIX		      to current frame location
* * * *	*
* K11 and K12 are  used in LPC 12 synthesis.	 
* * * *	*
*-----K11-----
	TMAIX		  -Transfer new	frame K11 parameter
	TAMIX		  -to current frame location
*-----K12-----
	TMAIX		  -Transfer new	frame K12 parameter
	TAMIX		  -to current frame location
*-----
* * * *	*
* We have now discarded	the "current" values by	replacing
* them with the	"new" values.  We now need to read in
* another frame	of speech data and use them as the
* new "new" values.
* * * *	*
*----- ENERGY -----
	CLA
	TCX	FLAGS
	GET	EBITS		   -Get	coded energy
	ANEC	ESILENCE	   -Is it a silent frame?
	BR	UPDT0		      No, continue
	ORCM	Sil_Flg1+Int_Inh      Yes, set silence flag
	BR	ZeroKs			   and zero K params
*
UPDT0	ANEC	ESTOP		   -Is it a stop frame?
	BR	UPDT1		      no, continue
	ORCM	STOPFLAG+Sil_Flg1+Int_Inh   yes, set flags
	BR	ZeroKs				 and zero Ks
*
UPDT1	ACAAC	TBLEN	     -Add table	offset to energy
	LUAA		     -Get decoded energy
	TAMD	ENV2	     -Store the	Energy in RAM
* * * *	*
* If this is a silent frame, we	are done with the update If
* the previous frame was silent, the new frame should be
* spoken immediately with no ramp up due to interpolation
* * * *	*
	TCX	FLAGS
	TSTCM	Sil_Flg1     -Is this a	silent frame?
	BR	RTN		yes, exit
* * * *	*
* A repeat frame will use the K	parameter from the previous
* frame.  If it	is, we need to set a flag.
* * * *	*
UPDT2	GET	RBITS	     -Get the Repeat bit
	TSTCA	#01	     -Is this a	repeat frame?
	BR	SFLG1		yes, set repeat	flag
	BR	UPDT3

SFLG1	ORCM	R_FLAG	     -Set repeat flag

*----- PITCH -----

UPDT3	CLA
	GET	4	     -Get coded	pitch
	GET	3	     -Get coded	pitch
	ANEC	PUnVoiced    -Is the frame unvoiced?
	SBR	UPDT3A		no, continue
	ORCM	Unv_Flg1	yes, set unvoiced flag

UPDT3A	SALA		     -Double coded pitch and
	ACAAC	TBLPH		add table offset to point

	LUAB		     -Get decoded pitch
	IAC
	LUAA		     -Get decoded fractional pitch
	TCX	PHV2	     -Store the	pitch and fractional
	TBM		     -pitch in RAM
	IXC
	TAM
* * * *	*
* If the voicing has changed with the new frame, then we
* need to change the voicing in	the mode register.
* * * *	*
	TCX	FLAGS
	TSTCM	Unv_Flg1     -Is the new frame unvoiced?
	SBR	UPDT3B		yes, continue
	BR	VOICE		no, go to voiced code
* * * *	*
* The following	code is	reached	if the new frame is
* unvoiced. We inspect the flags to see	if the previous
* frame	was either silent or voiced. If	either condition
* applies, then	we branch to code which	inhibits
* interpolation.
* * * *	*
UPDT3B	TSTCM	Sil_Flg2     -Was the previous frame silent?
	BR	UPDT5		yes, inhibit interpolation

	TSTCM	Unv_Flg2     -Was the previous frame unvoiced
	BR	UPDT4		yes, no	need to	change anything
	BR	UPDT5		no, inhibit interpolation
* * * *	*
* The following	code is	reached	if the new frame is
* voiced. We inspect the flags to see if the previous
* frame	was also voiced. If it was not,	we need	to inhibit
* interpolation.
* * * *	*
VOICE	TSTCM	Unv_Flg2     -Was the previous frame voiced?
	BR	UPDT5		no, set	no interpolation flag
	BR	UPDT4		yes, no	need to	change anything

UPDT5	ORCM	Int_Inh	     -Inhibit interpolation
* * * *	*
* Now we test the repeat flag.	If the new frame is a repeat
* frame, then the current values are used for the K factors,
* so new values	do not need to be loaded and we	can exit the
* routine now.
* * * *	*
UPDT4	TSTCM	R_FLAG	     -Is repeat	flag set?
	BR	RTN		yes, exit routine
* * * *	*
* Now we need to load the "new"	K factors (K1 through K10).
* Each K factor	is a 12	bit value which	will be	stored in
* two bytes.  The most significant 8 bits in the first byte,
* and the least	significant 4 bits (called the fractional
* value) in the	second byte. For K3 through K12, the
* fractional part is assumed to	be zero.  K11 and K12 are
* not used in LPC10 synthesis, and the code loading them is
* commented out.  A coded factor is read into the A
* register.  It	is then	converted to a pointer to a table
* element which	contains the uncoded factor. Since the K1
* and K2 table elements	consist	of two bytes, the conversion
* consists of doubling the coded factor	and adding the
* result to the	start of the table.  Since the K4 & K4 table
* elements consist of one byte,	the coded factor is added
* directly to the start	of the table.  Once the	pointer	has
* been set up, the uncoded factor is fetched and stored	into
* RAM.
* * * *	*
*-----K1-----
	CLA
	GET	4	     -Get coded	K1
	GET	2	     -Get coded	K1
	SALA		     -Convert it to a
	ACAAC	TBLK1	       pointer to table	element
	LUAB		     -Fetch MSB	of uncoded K1
	IAC
	LUAA		     -Fetch fractional K1
	TCX	K1V2
	TBM		     -Store uncoded K1
	IXC
	TAM		     -Store fractional K1
*-----K2-----
	CLA
	GET	4	     -Get coded	K2
	GET	2	     -Get coded	K2

	SALA		     -Convert it to a
	ACAAC	TBLK2	       pointer to table	element

	LUAB		     -Fetch MSB	of uncoded K2
	IAC
	LUAA		     -Fetch fractional K2
	TCX	K2V2
	TBM		     -Store uncoded K2
	IXC
	TAM		     -Store fractional K2
*-----K3-----
	CLA
	GET	4	     -Get Index	into K3	table
	GET	1	     -Get Index	into K3	table
	ACAAC	TBLK3		and add	offset of table	to it

	LUAA		     -Get uncoded K3
	TAMD	K3V2	     -and store	it in RAM
	CLA
	TAMD	K3V2+1
*-----K4-----
	CLA
	GET	4	     -Get Index	into K4	table
	GET	1	     -Get Index	into K4	table
	ACAAC	TBLK4		and add	offset of table	to it
	LUAA		     -Get uncoded K4
	TAMD	K4V2	     -and store	it in RAM
	CLA
	TAMD	K4V2+1
* * * *	*
* If this is an	unvoiced frame,	we only	use four K factors,
* so we	load zeroes to the rest	of the K factors.  If this
* is a voiced frame, load the rest of the uncoded factors.
* * * *	*
	TCX	FLAGS
	TSTCM	Unv_Flg1     -Is this an unvoiced frame?
	BR	UNVC		Yes, zero rest of factors
* * * *	*
* The following	code is	executed if the	new frame is
* voiced.  Since we assume that	the fractional parameter is
* zero for the remaining K factors, the	table elements are
* only one byte	long.  As with K3 and K4, the conversion to
* a table pointer consists of adding the coded factor to the
* start	of the table.
* * * *	*
*-----K5-----
	CLA
	GET	K5BITS	     -Get Index	into K5	table
	ACAAC	TBLK5		and add	offset of table	to it

	LUAA		     -Get uncoded K5
	TAMD	K5V2		and store it in	RAM
*-----K6-----
	CLA
	GET	K6BITS	     -Get Index	into K6	table
	ACAAC	TBLK6		and add	offset of table	to it
	LUAA		     -Get uncoded K6
	TAMD	K6V2		and store it in	RAM
*-----K7-----
	CLA
	GET	K7BITS	     -Get Index	into K7	table
	ACAAC	TBLK7		and add	offset of table	to it
	LUAA		     -Get uncoded K7
	TAMD	K7V2		and store it in	RAM
*-----K8-----
	CLA
	GET	K8BITS	     -Get Index	into K8	table
	ACAAC	TBLK8		and add	offset of table	to it
	LUAA		     -Get uncoded K8
	TAMD	K8V2		and store it in	RAM
*-----K9-----
	CLA
	GET	K9BITS	     -Get Index	into K9	table
	ACAAC	TBLK9		and add	offset of table	to it
	LUAA		     -Get uncoded K9
	TAMD	K9V2		and store it in	RAM
*-----K10-----
	CLA
	GET	K10BITS	     -Get Index	into K10 table
	ACAAC	TBLK10		and add	offset of table	to it
	LUAA		     -Get uncoded K10
	TAMD	K10V2		and store it in	RAM
* * * *	*
* Since	K11 and	K12 are	 used in LPC	12
* * * *	*
*-----K11-----
	CLA
	GET	K11BITS	     -Get Index	into K11 table
	ACAAC	TBLK11		and add	offset of table	to it
	LUAA		     -Get uncoded K11
	TAMD	K11V2		and store it in	RAM
*-----K12-----
	CLA
	GET	K12BITS	     -Get Index	into K12 table
	ACAAC	TBLK12		and add	offset of table	to it
	LUAA		     -Get uncoded K12
	TAMD	K12V2		and store it in	RAM
*-----
	BR	RTN
* * * *	*
* The following	code is	executed if the	K parameters need to
* be zeroed out.  If  the new frame is a stop frame or a
* silent frame,	we zero	out all	K parameters and set the
* energy to zero.  If the new frame is an unvoiced frame,
* then we need to zero out the unused upper K parameters.
* * * *	*
*
ZeroKs	CLA
	TAMD	ENV2	     -Kill Energy
	TAMD	ENV2+1
	TAMD	K1V2	     -Kill K1
	TAMD	K1V2+1
	TAMD	K2V2	     -Kill K2
	TAMD	K2V2+1
	TAMD	K3V2	     -Kill K3
	TAMD	K3V2+1
	TAMD	K4V2	     -Kill K4
	TAMD	K4V2+1
UNVC	CLA
	TAMD	K5V2	     -Kill K5
	TAMD	K6V2	     -Kill K6
	TAMD	K7V2	     -Kill K7
	TAMD	K8V2	     -Kill K8
	TAMD	K9V2	     -Kill K9
	TAMD	K10V2	     -Kill K10
	TAMD	K11V2	     -Kill K11
	TAMD	K12V2	     -Kill K12
	BR	RTN
* * * *	*
* STOP AND RETURN
* * * *	*
* The following	code has two entry points. STOP	is reached
* if the current frame is a stop flag, it turns	off
* synthesis and	returns	to the program.	 RTN is	the general
* exit point for the UPDATE routine, it	sets the Update	flag
* and leaves the routine.
* * * *	*
STOP	TCX    MODE_BUF
	ANDCM  ~LPC	   -Turn off synthesis
	ANDCM  ~INT1	   -Disable interrupt
	ANDCM  ~UNV	   -Go back to voiced for next word
	ORCM	PCM	   -Enable PCM mode
	TMA
	TAMODE		   -Set	mode per above setting
	CLA
	TASYN		   -Write a zero to the	DAC
	TCA	#FA
BACK	iac		   -Wait for minimum of	30
	br	out	       instruction cycles
	br	back
OUT	TCX	MODE_BUF   -Disable PCM
	ANDCM	~PCM
	TMA
	TAMODE		   -Set	mode per above setting
	RETN		   -Go back for	next word

RTN	TCX	FLAGS	   -Set	a flag indicating that
	ORCM	Update_Flg    the parameters are update				d

	TCX	MODE_BUF   -Get	mode
	TSTCM	LPC	   -Are	we speaking yet?
	BR	RTN1	      yes, reenable interrupt
	RETN		      no, return for more data

RTN1	TCX	FLAG1	   -Inhibit the	execution of the
	ORCM	Int_Off	      pending interpolation interrupt

	TCX	MODE_BUF   -Reenable the interrupt
	ORCM	INT1
	TMA
	TAMODE

	TCX	FLAG1	   -Reenable execution
	ANDCM	~Int_Off      of the interpolation routine
	BR	SPEAK_LP   -Go back to loop
* * * *	*
* D6 SPEECH DECODING TABLES.
* * * *	*
* Energy decoding table
* * * *	*
TBLEN	BYTE	#00,#01,#02,#03,#04,#05,#07,#0B
	BYTE	#11,#1A,#29,#3F,#55,#70,#7F,#00

* * * *	*
* Pitch	period decoding	table
* * * *	*
TBLPH	BYTE	#0C,#00
	BYTE	#10,#00
	BYTE	#10,#04
	BYTE	#10,#08
	BYTE	#11,#00
	BYTE	#11,#04
	BYTE	#11,#08
	BYTE	#11,#0C
	BYTE	#12,#04
	BYTE	#12,#08
	BYTE	#12,#0C
	BYTE	#13,#04
	BYTE	#13,#08
	BYTE	#14,#00
	BYTE	#14,#04
	BYTE	#14,#0C
	BYTE	#15,#00
	BYTE	#15,#08
	BYTE	#15,#0C
	BYTE	#16,#04
	BYTE	#16,#0C
	BYTE	#17,#00
	BYTE	#17,#08
	BYTE	#18,#00
	BYTE	#18,#04
	BYTE	#18,#0C
	BYTE	#19,#04
	BYTE	#19,#0C
	BYTE	#1A,#04
	BYTE	#1A,#0C
	BYTE	#1B,#04
	BYTE	#1B,#0C
	BYTE	#1C,#04
	BYTE	#1C,#0C
	BYTE	#1D,#04
	BYTE	#1D,#0C
	BYTE	#1E,#04
	BYTE	#1F,#00
	BYTE	#1F,#08
	BYTE	#20,#00
	BYTE	#20,#0C
	BYTE	#21,#04
	BYTE	#21,#0C
	BYTE	#22,#08
	BYTE	#23,#00
	BYTE	#23,#0C
	BYTE	#24,#08
	BYTE	#25,#00
	BYTE	#25,#0C
	BYTE	#26,#08
	BYTE	#27,#04
	BYTE	#28,#00
	BYTE	#28,#0C
	BYTE	#29,#08
	BYTE	#2A,#04
	BYTE	#2B,#00
	BYTE	#2B,#0C
	BYTE	#2C,#08
	BYTE	#2D,#04
	BYTE	#2E,#04
	BYTE	#2F,#00
	BYTE	#30,#00
	BYTE	#30,#0C
	BYTE	#31,#0C
	BYTE	#32,#08
	BYTE	#33,#08
	BYTE	#34,#08
	BYTE	#35,#08
	BYTE	#36,#08
	BYTE	#37,#08
	BYTE	#38,#08
	BYTE	#39,#08
	BYTE	#3A,#08
	BYTE	#3B,#0C
	BYTE	#3C,#0C
	BYTE	#3D,#0C
	BYTE	#3F,#00
	BYTE	#40,#04
	BYTE	#41,#04
	BYTE	#42,#08
	BYTE	#43,#0C
	BYTE	#45,#00
	BYTE	#46,#04
	BYTE	#47,#08
	BYTE	#49,#00
	BYTE	#4A,#04
	BYTE	#4B,#0C
	BYTE	#4D,#00
	BYTE	#4E,#08
	BYTE	#50,#00
	BYTE	#51,#04
	BYTE	#52,#0C
	BYTE	#54,#08
	BYTE	#56,#00
	BYTE	#57,#08
	BYTE	#59,#04
	BYTE	#5A,#0C
	BYTE	#5C,#08
	BYTE	#5E,#04
	BYTE	#60,#00
	BYTE	#61,#0C
	BYTE	#63,#08
	BYTE	#65,#04
	BYTE	#67,#04
	BYTE	#69,#00
	BYTE	#6B,#00
	BYTE	#6D,#00
	BYTE	#6F,#00
	BYTE	#71,#00
	BYTE	#73,#04
	BYTE	#75,#04
	BYTE	#77,#08
	BYTE	#79,#0C
	BYTE	#7C,#00
	BYTE	#7E,#04
	BYTE	#80,#08
	BYTE	#82,#0C
	BYTE	#85,#04
	BYTE	#87,#0C
	BYTE	#8A,#04
	BYTE	#8C,#0C
	BYTE	#8F,#08
	BYTE	#92,#00
	BYTE	#94,#0C
	BYTE	#97,#08
	BYTE	#9A,#04
	BYTE	#9D,#00
	BYTE	#A0,#00

* * * *	*
* K1 parameter decoding	table
* * * *	*
TBLK1	BYTE	#81,#00
	BYTE	#82,#04
	BYTE	#83,#04
	BYTE	#84,#08
	BYTE	#85,#0C
	BYTE	#87,#00
	BYTE	#88,#04
	BYTE	#89,#0C
	BYTE	#8B,#04
	BYTE	#8C,#0C
	BYTE	#8E,#04
	BYTE	#90,#00
	BYTE	#91,#0C
	BYTE	#93,#08
	BYTE	#95,#08
	BYTE	#97,#04
	BYTE	#99,#08
	BYTE	#9B,#08
	BYTE	#9D,#08
	BYTE	#9F,#0C
	BYTE	#A2,#00
	BYTE	#A4,#04
	BYTE	#A6,#0C
	BYTE	#A9,#04
	BYTE	#AB,#08
	BYTE	#AE,#00
	BYTE	#B0,#0C
	BYTE	#B3,#08
	BYTE	#B6,#04
	BYTE	#B9,#00
	BYTE	#BC,#00
	BYTE	#BF,#04
	BYTE	#C2,#04
	BYTE	#C5,#08
	BYTE	#C8,#0C
	BYTE	#CC,#04
	BYTE	#CF,#0C
	BYTE	#D3,#08
	BYTE	#D7,#08
	BYTE	#DB,#04
	BYTE	#DF,#04
	BYTE	#E3,#08
	BYTE	#E7,#0C
	BYTE	#EC,#00
	BYTE	#F0,#04
	BYTE	#F4,#0C
	BYTE	#F9,#0C
	BYTE	#FE,#0C
	BYTE	#04,#04
	BYTE	#09,#0C
	BYTE	#0F,#04
	BYTE	#15,#08
	BYTE	#1C,#08
	BYTE	#23,#08
	BYTE	#2A,#0C
	BYTE	#32,#08
	BYTE	#3A,#08
	BYTE	#42,#0C
	BYTE	#4B,#08
	BYTE	#54,#00
	BYTE	#5C,#04
	BYTE	#65,#00
	BYTE	#6E,#00
	BYTE	#78,#08

* * * *	*
* K2 parameter decoding	table
* * * *	*
TBLK2	BYTE	#8A,#00
	BYTE	#98,#00
	BYTE	#A3,#0C
	BYTE	#AD,#0C
	BYTE	#B4,#08
	BYTE	#BA,#08
	BYTE	#C0,#00
	BYTE	#C5,#00
	BYTE	#C9,#0C
	BYTE	#CE,#04
	BYTE	#D2,#0C
	BYTE	#D6,#0C
	BYTE	#DA,#0C
	BYTE	#DE,#08
	BYTE	#E2,#00
	BYTE	#E5,#0C
	BYTE	#E9,#04
	BYTE	#EC,#0C
	BYTE	#F0,#00
	BYTE	#F3,#04
	BYTE	#F6,#08
	BYTE	#F9,#0C
	BYTE	#FD,#00
	BYTE	#00,#00
	BYTE	#03,#04
	BYTE	#06,#04
	BYTE	#09,#04
	BYTE	#0C,#04
	BYTE	#0F,#04
	BYTE	#12,#08
	BYTE	#15,#08
	BYTE	#18,#08
	BYTE	#1B,#08
	BYTE	#1E,#08
	BYTE	#21,#08
	BYTE	#24,#0C
	BYTE	#27,#0C
	BYTE	#2A,#0C
	BYTE	#2D,#0C
	BYTE	#30,#0C
	BYTE	#34,#00
	BYTE	#37,#00
	BYTE	#3A,#04
	BYTE	#3D,#00
	BYTE	#40,#00
	BYTE	#43,#00
	BYTE	#46,#00
	BYTE	#49,#00
	BYTE	#4C,#00
	BYTE	#4F,#04
	BYTE	#52,#04
	BYTE	#55,#04
	BYTE	#58,#04
	BYTE	#5B,#04
	BYTE	#5E,#00
	BYTE	#61,#00
	BYTE	#63,#0C
	BYTE	#66,#08
	BYTE	#69,#04
	BYTE	#6C,#00
	BYTE	#6F,#00
	BYTE	#72,#00
	BYTE	#76,#04
	BYTE	#7C,#00

* * * *	*
* K3 parameter decoding	table
* * * *	*
TBLK3	BYTE	#8B,#9A,#A2,#A9,#AF,#B5,#BB,#C0
	BYTE	#C5,#CA,#CF,#D4,#D9,#DE,#E2,#E7
	BYTE	#EC,#F1,#F6,#FB,#01,#07,#0D,#14
	BYTE	#1A,#22,#29,#32,#3B,#45,#53,#6D

* * * *	*
* K4 parameter decoding	table
* * * *	*
TBLK4	BYTE	#94,#B0,#C2,#CB,#D3,#D9,#DF,#E5
	BYTE	#EA,#EF,#F4,#F9,#FE,#03,#07,#0C
	BYTE	#11,#15,#1A,#1F,#24,#29,#2E,#33
	BYTE	#38,#3E,#44,#4B,#53,#5A,#64,#74

* * * *	*
* K5 parameter decoding	table
* * * *	*
TBLK5	BYTE	#A3,#C5,#D4,#E0,#EA,#F3,#FC,#04
	BYTE	#0C,#15,#1E,#27,#31,#3D,#4C,#66

* * * *	*
* K6 parameter decoding	table
* * * *	*
TBLK6	BYTE	#AA,#D7,#E7,#F2,#FC,#05,#0D,#14
	BYTE	#1C,#24,#2D,#36,#40,#4A,#55,#6A

* * * *	*
* K7 parameter decoding	table
* * * *	*
TBLK7	BYTE	#A3,#C8,#D7,#E3,#ED,#F5,#FD,#05
	BYTE	#0D,#14,#1D,#26,#31,#3C,#4B,#67

* * * *	*
* K8 parameter decoding	table
* * * *	*
TBLK8	BYTE	#C5,#E4,#F6,#05,#14,#27,#3E,#58

* * * *	*
* K9 parameter decoding	table
* * * *	*
TBLK9	BYTE	#B9,#DC,#EC,#F9,#04,#10,#1F,#45

* * * *	*
* K10 parameter	decoding table
* * * *	*
TBLK10	
TBLK11
TBLK12
	BYTE	#C3,#E6,#F3,#FD,#06,#11,#1E,#43
*
*************************************************************
*						
*    Main Program starts here. 
*    The program will pronounce all the concatenations defined
*    and loop back
*************************************************************
PROGRAM
	CLA
	TAMD CONC_NUM
*
* address of concatenation is in A and CONC_NUM
*
*
LOOPCONC
*
* loop on all concatenations
*
*******************************************************
CONC_ADDR
   TCX CONC_NUM
   TMA                           
   TCX CUR_CONC	
   TAM				; we have a copy of the concatenation number in CUR_CONC
   CLA
   ACAAC CNCTABLE		; address of conc_table in A
   TAB                          ; copy it in B
LOOP_ADDR
   DECMN
   SBR FOUND_ADDR               ; we are at the right number
*;**
*; to get to the correct concatenation, we read all concatenations until we find the
*; one we are looking for. The FF byte at the end of each concatenation allows us to count
*;
*;**
LOOP1
          LUAA                          ;read byte at current conc data address
          IBC                           ;increment conc data address
          ANEC >FF
          SBR LOOK_AGAIN
          XBA
          TAB                           ; conc data address is incremented
          SBR LOOP_ADDR
LOOK_AGAIN
          XBA
          TAB
          SBR LOOP1
FOUND_ADDR
*;
*; the starting address of concatenation is in A and B
*; we save it in MSW_ADDR and LSW_ADDR
*;
          CALL SAVE_ADDR
*;
*; now that we have the starting address of the concat
*; we will loop on speak_word until we find an FF byte
*;
*; first, check if we have reached the end of concats
*; if the first byte read is FF, we have reached the last concatenation
*; we then go back to the beginning
****************************************************
	  INTGR
          TCX LSW_ADDR
          TMAIX                         ;LSB in A, X->MSW_ADDR
          TAB                           ;LSB in B
          TMA                           ;MSB in A
          SALA4
          SALA4                         ;MSB in place
          ABAAC                         ;conc data address in A
          TAB                           ;save a copy in B
          LUAA                          ;read the byte of conc data
          ANEC >FF                      ;is it a stop code?
	  BR SPEAKWRD			;no
          BR PROGRAM                    ;yes,start over
****************************************************
SPEAKWRD
*;
*; form address of conc data from LSW_ADDR and MSB_ADDR
*;
          INTGR
          TCX LSW_ADDR
          TMAIX                         ;LSB in A, X->MSW_ADDR
          TAB                           ;LSB in B
          TMA                           ;MSB in A
          SALA4
          SALA4                         ;MSB in place
          ABAAC                         ;conc data address in A
          TAB                           ;save a copy in B
          LUAA                          ;read the byte of conc data
          ANEC >FF                      ;is it a stop code?
          BR NOSTOP                    ;no
          BR STOPCODE                   ;yes
NOSTOP
*;
*;we save the incremented address
*;
          XBA                           ;non incremented address in A, conc data
          IAC                           ;increment address
          INTGR                         ;to force status
          CALL SAVE_ADDR                ;save it
          XBA                           ;conc data byte in A, incremented address
SAY_WRD	
	CALL	SPEAK			;Go speak the sentence.
	BR SPEAKWRD

STOPCODE
	TCX CONC_NUM
	INCMC
	BR LOOPCONC
	BR LOOPCONC
*******************************************************
SAVE_ADDR
          TCX LSW_ADDR
          TAMIX                         ;LSB of address in LSW_ADDR, X-> MSW_ADD
          AXCA 1                        ;shift right 7
          SARA
          TAM                           ;MSB of addr in MSW_ADDR
          ANDCM >3F                     ;take care of potential sign problem
          RETN
*******************************************************
*

 
*
*-----------------------------------------------------------------*
*	Data and tables.
*--------------------------------------------------------------*
*;;;;
*
* Insert phrase table here
*
	copy sample.pfm
*
* Insert concatenation table here
*
	copy sample.cfm
*
* Insert speech data here
*
	copy sample.sfm


*
**EXCITATION FUNCTION
*
          AORG  >4000
	BYTE >0,>A2,>0,>AF,>0,>BA,>0,>C2
	BYTE >0,>C7,>0,>C9,>0,>CA,>0,>C6
	BYTE >0,>C2,>0,>BC,>0,>B5,>0,>AD
	BYTE >0,>A5,>0,>9E,>0,>9A,>0,>95
	BYTE >0,>95,>0,>98,>0,>9F,>0,>A8
	BYTE >0,>B8,>0,>CA,>0,>E3,>0,>FE
	BYTE >1,>1F,>1,>41,>1,>69,>1,>91
	BYTE >1,>BD,>1,>E8,>2,>16,>2,>40
	BYTE >2,>6C,>2,>92,>2,>B9,>2,>D9
	BYTE >2,>F8,>3,>F,>3,>25,>3,>32
	BYTE >3,>3F,>3,>43,>3,>47,>3,>45
	BYTE >3,>45,>3,>3F,>3,>3D,>3,>3A
	BYTE >3,>3D,>3,>41,>3,>4E,>3,>5F
	BYTE >3,>7B,>3,>A0,>3,>D2,>4,>D
	BYTE >4,>57,>4,>AD,>5,>11,>5,>82
	BYTE >6,>0,>6,>8A,>7,>1F,>7,>BD
	BYTE >8,>64,>9,>11,>9,>C1,>A,>74
	BYTE >B,>26,>B,>D5,>C,>7F,>D,>20
	BYTE >D,>B7,>E,>40,>E,>BB,>F,>24
	BYTE >F,>7A,>F,>BC,>F,>E9,>F,>FF
	BYTE >F,>FF,>F,>E9,>F,>BC,>F,>7A
	BYTE >F,>24,>E,>BB,>E,>40,>D,>B7
	BYTE >D,>20,>C,>7F,>B,>D5,>B,>26
	BYTE >A,>74,>9,>C1,>9,>11,>8,>64
	BYTE >7,>BD,>7,>1F,>6,>8A,>6,>0
	BYTE >5,>82,>5,>11,>4,>AD,>4,>57
	BYTE >4,>D,>3,>D2,>3,>A0,>3,>7B
	BYTE >3,>5F,>3,>4E,>3,>41,>3,>3D
	BYTE >3,>3A,>3,>3D,>3,>3F,>3,>45
	BYTE >3,>45,>3,>47,>3,>43,>3,>3F
	BYTE >3,>32,>3,>25,>3,>F,>2,>F8
	BYTE >2,>D9,>2,>B9,>2,>92,>2,>6C
	BYTE >2,>40,>2,>16,>1,>E8,>1,>BD
	BYTE >1,>91,>1,>69,>1,>41,>1,>1F
	BYTE >0,>FE,>0,>E3,>0,>CA,>0,>B8
	BYTE >0,>A8,>0,>9F,>0,>98,>0,>95
	BYTE >0,>95,>0,>9A,>0,>9E,>0,>A5
	BYTE >0,>AD,>0,>B5,>0,>BC,>0,>C2
	BYTE >0,>C6,>0,>CA,>0,>C9,>0,>C7
	BYTE >0,>C2,>0,>BA,>0,>AF,>0,>A2
	BYTE >5,>80,>5,>80,>5,>80,>5,>80
	BYTE >5,>80,>5,>80,>5,>80,>5,>80
	BYTE >5,>80,>5,>80,>5,>80,>5,>80
	BYTE >5,>80,>5,>80,>5,>80,>5,>80
	BYTE >3A,>80,>3A,>80,>3A,>80,>3A,>80
	BYTE >3A,>80,>3A,>80,>3A,>80,>3A,>80
	BYTE >3A,>80,>3A,>80,>3A,>80,>3A,>80
	BYTE >3A,>80,>3A,>80,>3A,>80,>3A,>80

