;       PCjr INT 9, keyboard interrupt, fix device driver
;
; first, the interrupt area
;
kbint           equ     09H
oseg    segment at 0H
        org 4*kbint
i9off           dw      ?
i9seg           dw      ?
oseg    ends
CSEG    SEGMENT PARA PUBLIC 'CODE'
        org 0h
;
XDV             PROC FAR
                ASSUME CS:CSEG,DS:CSEG,ES:CSEG
BEGIN:
START           EQU $
;  Header for DOS Device Drivers
NEXT_DEV        DW  -1         ; fake pointer to next device driver
                dw -1
ATTRIBUTE       DW  08000H     ;character device with IOCTL capability
STRATEGY        DW  XDV_STRAT  ;pointer to function which queues request header
FUNC_CALL       DW  XDV_FUNC   ;pointer to operating functions switch
DEV_NAME        DB  '&JRINT9%' ;8-byte device name field
;
;  Pointer to function request from DOS
RH_OFF          DW  ?    
RH_SEG          DW  ?
;
;  Device Strategy - set pointer to request header from DOS
XDV_STRAT:      MOV  CS:RH_SEG,ES
                MOV  CS:RH_OFF,BX
                RET
;
;  Device Interrupt Handler 
XDV_FUNC:       ;preserve machine state
                PUSHF
                CLD
                PUSH  DS
                PUSH  ES
                PUSH  AX
                PUSH  BX
                PUSH  CX
                PUSH  DX
                PUSH  DI
                PUSH  SI
;      Set DS to CS value
                PUSH  CS
                POP   DS
;      Load ES and BX with RH_SEG and RH_OFF
                LES   BX,DWORD PTR CS:RH_OFF
;      Branch to INIT ONLY
                MOV   AL,ES:[BX+2]      ; get function code byte
                OR    AL,AL             ;INIT?
                JNZ   DONE              ;NO, DO NOTHING
;  Device Initialization
INIT:
                MOV     AL,0            ;zero al
                mov     dx,0a0h         ;NMI port
                OUT     dx,AL           ;disable NMI
                CLI                     ;disable interrupts
                xor     AX,AX           ;zero ax
                MOV     DS,AX           ;point to interrupt area
        assume ds:oseg
                MOV     ax,i9off   ;save old int9
                MOV     cs:old9off,ax
                MOV     ax,i9seg
                MOV     cs:old9seg,ax
                MOV     ax,offset new9  ;set new int9
                MOV     i9off,ax
                MOV     ax,cs
                MOV     i9seg,ax
                sti                     ;enable interrupts
                MOV     AL,080H         ;al=80
                mov     dx,0a0h         ;nmi port
                OUT     dx,AL           ;enable nmi
                MOV     ax,OFFSET LASTWORD      ;end offset of XDV
                MOV  ES:[BX+14],ax      ;dx:0 points to end of buffer
                MOV  ES:[BX+16],cs
;
done:           MOV  WORD PTR ES:[BX+3],0100H ;DONE, NOERROR
;  Restore registers and exit
                POP  SI
                POP  DI
                POP  DX
                POP  CX
                POP  BX
                POP  AX
                POP  ES                  
                POP  DS
                POPF
                RET
;
XDV             ENDP
;
kbport  equ     060H
old9    label dword                                     ;where to store ...
old9off dw ?                                            ; old 9 stuff
old9seg dw ?
NEW9    PROC    FAR                                     ;new int 9
        in al,kbport
        jmp dword ptr cs:old9
NEW9    ENDP
;
LASTWORD        label byte         ;end of XDV - used for TSR
CSEG            ENDS
                END  BEGIN

