TITLE 12/08/83 ORGS
.XLIST
INCLUDE DSEG.SRC
INCLUDE POSTEQU.SRC
.LIST
INCLUDE SEGMENT.SRC
ASSUME CS:CODE, DS:DATA

EXTRN	K16:NEAR
EXTRN	INT_287:NEAR
EXTRN	DSKETTE_SETUP:NEAR
EXTRN	DISK_SETUP:NEAR
EXTRN	SEEK:NEAR
EXTRN	RTC_INT:NEAR
EXTRN	START_1:NEAR
EXTRN	NMI_INT_1:NEAR
EXTRN	BOOT_STRAP_1:NEAR
EXTRN	KEYBOARD_IO_1:NEAR
EXTRN	KB_INT_1:NEAR
EXTRN	DISKETTE_IO_1:NEAR
EXTRN	DISK_INT_1:NEAR
EXTRN	PRINTER_IO_1:NEAR
EXTRN	VIDEO_IO_1:NEAR
EXTRN	MEMORY_SIZE_DETERMINE_1:NEAR
EXTRN	EQUIPMENT_1:NEAR
EXTRN	CASSETTE_IO_1:NEAR
EXTRN	TIME_OF_DAY_1:NEAR
EXTRN	TIMER_INT_1:NEAR
EXTRN	D11:NEAR
EXTRN	RS232_IO_1:NEAR
EXTRN	DUMMY_RETURN_1:NEAR
EXTRN	PRINT_SCREEN_1:NEAR
EXTRN	C11:NEAR
EXTRN	C30:NEAR
EXTRN	TST4_B:NEAR
EXTRN	TST4_C:NEAR
EXTRN	TST4_D:NEAR
EXTRN	E30B:NEAR
EXTRN	E30C:NEAR
EXTRN	RE_DIRECT:NEAR

PUBLIC	BOOT_INVA
PUBLIC	TUTOR
PUBLIC	START
PUBLIC	C1
PUBLIC	C2
PUBLIC	C8042A
PUBLIC	OBF_42B
PUBLIC	OBF_42A
PUBLIC	C8042B
PUBLIC	C8042C
PUBLIC	E0
PUBLIC	E0_A
PUBLIC	E0_B
PUBLIC	VIR_ERR
PUBLIC	E1
PUBLIC	F3A
PUBLIC	D1
PUBLIC	D2
PUBLIC	D2A
PUBLIC	F3D
PUBLIC	F3D1
PUBLIC	F1
PUBLIC	F1_A
PUBLIC	F1_B
PUBLIC	F3
PUBLIC	LOCK
PUBLIC	CM1
PUBLIC	CM2
PUBLIC	CM3
PUBLIC	CM4

PUBLIC	CM4_A
PUBLIC	CM4_B
PUBLIC	CM4_C
PUBLIC	CM4_D
PUBLIC	F3B
PUBLIC	F4
PUBLIC	F4E
PUBLIC	E1_A
PUBLIC	E1_B
PUBLIC	E1_C
PUBLIC	ADERR
PUBLIC	ADERR1
PUBLIC	VECTOR_TABLE
PUBLIC	SLAVE_VECTOR_TABLE
PUBLIC	DISK_BASE
PUBLIC	VIDEO_PARMS
PUBLIC	M4
PUBLIC	M5
PUBLIC	M6
PUBLIC	M7
PUBLIC	CRT_CHAR_GEN
PUBLIC	PRINT_SCREEN
PUBLIC	A1
PUBLIC	K6
PUBLIC	K6L
PUBLIC	K7
PUBLIC	K8
PUBLIC	K9
PUBLIC	K10
PUBLIC	K11
PUBLIC	K12
PUBLIC	K13
PUBLIC	K14
PUBLIC	K15
PUBLIC	RS232_IO
PUBLIC	DUMMY_RETURN
PUBLIC	NMI_INT
PUBLIC	BOOT_STRAP
PUBLIC	KEYBOARD_IO
PUBLIC	KB_INT
PUBLIC	DISKETTE_IO
PUBLIC	DISK_INT
PUBLIC	PRINTER_IO
PUBLIC	VIDEO_IO
PUBLIC	MEMORY_SIZE_DETERMINE
PUBLIC	EQUIPMENT
PUBLIC	CASSETTE_IO
PUBLIC	TIME_OF_DAY
PUBLIC	TIMER_INT
PUBLIC	HRD
PUBLIC	FLOPPY
PUBLIC	SEEKS_1
PUBLIC	F1780
PUBLIC	F1781
PUBLIC	F1782
PUBLIC	F1790
PUBLIC	F1791
PUBLIC	FD_TBL

;-------------------------------------------------------------------------------
;  THIS MODULE HAS BEEN ADDED TO FACILITATE THE EXPANSION OF THIS PROGRAM.     :
;  IT ALLOWS FOR THE FIXED ORG STATEMENT ENTRY POINTS THAT HAVE TO REMAIN      :
;  AT THE SAME ADDRESSES. ADDED ON 9/16/82				       :
;-------------------------------------------------------------------------------


;--------------------
; COPYRIGHT NOTICE
;--------------------
;		ORG	0E000H

		DB	'6181028 COPR. IBM 1984'

;		ORG	0E05BH
		ORG	0005BH
RESET		LABEL	FAR
START:
		JMP	START_1

;+++++++++++++++++++++++

;-------------------------
; TEMPORARY STACK FOR POST
;-------------------------
C1		DW	C11
C2		DW	C30
C8042A		DW	TST4_B
OBF_42A 	DW	TST4_C
C8042B		DW	TST4_D
C8042C		DW	E30B
OBF_42B 	DW	E30C

;-------------------------
; POST ERROR MESSAGES
;-------------------------
E0	  DB	' 101-System Board Error',13,10 ; INTERRUPT FAILURE
E0_A	  DB	' 102-System Board Error',13,10 ; TIMER FAILURE
E0_B	  DB	' 103-System Board Error',13,10 ; TIMER INTERRUPT FAILURE
VIR_ERR   DB	' 104-System Board Error',13,10 ; PROTECTED MODE FAILURE
CM4	  DB	' 105-System Board Error',13,10 ; LAST 8042 COMMAND NOT ACCEPTED
E1	  DB	' 201-Memory Error',13,10
E1_B	  DB	' 401-CRT Error',13,10
E1_C	  DB	' 501-CRT Error',13,10
ADERR1	  DB	' 202-Memory Address Error',13,10    ; LINE ERROR 00->15
ADERR	  DB	' 203-Memory Address Error',13,10    ; LINE ERROR 16->23
F3A	  DB	'ROM Error',13,10                    ; ROM CHECKSUM
F3B	  DB	' KB OK',13                          ; KB FOR MEMORY SIZE
D1	  DB	'PARITY CHECK 2',13,10
D2	  DB	'PARITY CHECK 1',13,10
D2A	  DB	'?????',13,10
F3D	  DB	' (RESUME = "F1" KEY)',13,10
F3D1	  DB	'    -Unlock System Unit Keylock',13,10
F1	  DB	' 301-Keyboard Error',13,10          ; KEYBOARD ERROR
LOCK	  DB	' 302-System Unit Keylock is Locked',13,10   ; KEYBOARD LOCK ON
F1_A	  DB	' 303-Keyboard Or System Unit Error',13,10
F3	  DB	' 601-Diskette Error',13,10          ; DISKETTE ERROR
CM1	  DB	' 161-System Options Not Set-(Run SETUP)',13,10  ; DEAD BATTERY
CM2	  DB	' 162-System Options Not Set-(Run SETUP)',13,10
						     ;CMOS CHECKSUM ERROR
CM3	  DB	' 163-Time & Date Not Set-(Run SETUP)',13,10
				; CLOCK NOT UPDATING
;------------------------
; PRINTER TABLE
;------------------------
F4		LABEL	WORD
		DW	3BCH
		DW	378H
		DW	278H
F4E		LABEL	WORD

;--------- NMI ENTRY

;		ORG	0E2C3H
		ORG	002C3H
NMI_INT 	EQU	$

		JMP	NMI_INT_1

CM4_A		DB	' 106-System Board Error',13,10 ; CONVERTING LOGIC TEST
CM4_B		DB	' 107-System Board Error',13,10 ; HOT NMI TEST
CM4_C		DB	' 108-System Board Error',13,10 ; TIMER BUS TEST
CM4_D		DB	' 109-System Board Error',13,10 ; LOW MEG CHIP SELECT TEST
;---------- MEMORY SIZE ERROR
E1_A		DB	' 164-Memory Size Error-(Run SETUP)',13,10
					; CMOS DOES NOT MATCH SYSTEM
;---------- KEYBOARD/SYSTEM ERROR
F1_B		DB	' 304-Keyboard Or System Unit Error',13,10
					; KEYBOARD CLOCK LINE HIGH
;---------- DISKETTE BOOT RECORD IS NOT VALID
BOOT_INVA	DB	' 602-Diskette Boot Record Error',13,10
;---------- HARD FILE ERROR MSG
F1780	DB	'1780-Disk 0 Failure',0DH,0AH
F1781	DB	'1781-Disk 1 Failure',0DH,0AH
F1782	DB	'1782-Disk Controller Failure',0DH,0AH
F1790	DB	'1790-Disk 0 Error',0DH,0AH
F1791	DB	'1791-Disk 1 Error',0DH,0AH

;--------------------------------------------------------
; INITIALIZE DRIVE CHARACTERISTICS			:
;							:
; FIXED DISK PARAMETER TABLE				:
;							:
;  -  THE TABLE IS COMPOSED OF A BLOCK DEFINED AS:	:
;							:
;  +0	(1 WORD) - MAXIMUM NUMBER OF CYLINDERS		:
;  +2	(1 BYTE) - MAXIMUM NUMBER OF HEADS		:
;  +3	(1 WORD) - NOT USED/SEE PC-XT			:
;  +5	(1 WORD) - STARTING WRITE PRECOMPENSATION CYL	:
;  +7	(1 BYTE) - NOT USED/SEE PC-XT			:
;  +8	(1 BYTE) - CONTROL BYTE 			:
;		   BIT	  7 DISABLE RETRIES -OR-	:
;		   BIT	  6 DISABLE RETRIES		:
;		   BIT	  3 MORE THAN 8 HEADS		:
;  +9	(3 BYTES)- NOT USED/SEE PC-XT			:
; +12	(1 WORD) - LANDING ZONE 			:
; +14	(1 BYTE) - NUMBER OF SECTORS/TRACK		:
; +15	(1 BYTE) - RESERVED FOR FUTURE USE		:
;							:
;	 - TO DYNAMICALLY DEFINE A SET OF PARAMETERS	:
;	   BUILD A TABLE FOR UP TO 15 TYPES AND PLACE	:
;	   THE CORRESPONDING VECTOR INTO INTERRUPT 41	:
;	   FOR DRIVE 0 AND INTERRUPT 46 FOR DRIVE 1.	:
;							:
;--------------------------------------------------------

FD_TBL:

;----- DRIVE TYPE 01

	DW	0306D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0128D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0305D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 02

	DW	0615D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0615D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 03

	DW	0615D			; CYLINDERS
	DB	06D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0615D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 04

	DW	0940D			; CYLINDERS
	DB	08D			; HEADS
	DW	0
	DW	0512D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0940D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 05

	DW	0940D			; CYLINDERS
	DB	06D			; HEADS
	DW	0
	DW	0512D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0940D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 06

	DW	0615D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0615D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 07

	DW	0462D			; CYLINDERS
	DB	08D			; HEADS
	DW	0
	DW	0256D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0511D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 08

	DW	0733D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0733D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 09

	DW	0900D			; CYLINDERS
	DB	15D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	008H			; CONTROL BYTE
	DB	0,0,0
	DW	0901D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 10

	DW	0820D			; CYLINDERS
	DB	03D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0820D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 11

	DW	0855D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0855D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 12

	DW	0855D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0855D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 13

	DW	0306D			; CYLINDERS
	DB	08D			; HEADS
	DW	0
	DW	0128D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0319D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 14

	DW	0733D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0733D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;----- DRIVE TYPE 15	RESERVED     ****  DO NOT USE  ****

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;---------- BOOT LOADER INTERRUPT

;		ORG	0E6F2H
		ORG	006F2H
BOOT_STRAP	EQU	$
		JMP	BOOT_STRAP_1

;---------------BAUD RATE INIT

;		ORG	0E729H
		ORG	00729H
A1		LABEL	WORD

	DW	1047	; 110 BAUD	; TABLE OF INIT VALUES
	DW	768	; 150
	DW	384	; 300
	DW	192	; 600
	DW	96	; 1200
	DW	48	; 2400
	DW	24	; 4800
	DW	12	; 9600

;-------------- RS232

;		ORG	0E739H
		ORG	00739H
RS232_IO	EQU	$
		JMP	RS232_IO_1

;--------------- KEYBOARD

;		ORG	0E82EH
		ORG	0082EH
KEYBOARD_IO	EQU	$
		JMP	KEYBOARD_IO_1

;------ TABLE OF SHIFT KEYS AND MASK VALUES (EARLY PC)

;		ORG	0E87EH
		ORG	0087EH

K6	LABEL	BYTE
	DB	INS_KEY 		; INSERT KEY
	DB	CAPS_KEY,NUM_KEY,SCROLL_KEY,ALT_KEY,CTL_KEY
	DB	LEFT_KEY,RIGHT_KEY
K6L	EQU	$-K6

;------ SHIFT_MASK_TABLE

K7	LABEL	BYTE
	DB	INS_SHIFT		; INSERT MODE SHIFT
	DB	CAPS_SHIFT,NUM_SHIFT,SCROLL_SHIFT,ALT_SHIFT,CTL_SHIFT
	DB	LEFT_SHIFT,RIGHT_SHIFT

;------ SCAN CODE TABLES

K8		DB	27,-1,0,-1,-1,-1,30,-1
		DB	-1,-1,-1,31,-1,127,-1,17
		DB	23,5,18,20,25,21,9,15
		DB	16,27,29,10,-1,1,19
		DB	4,6,7,8,10,11,12,-1,-1
		DB	-1,-1,28,26,24,3,22,2
		DB	14,13,-1,-1,-1,-1,-1,-1
		DB	' ',-1
;------ CTL TABLE SCAN
K9	LABEL	BYTE
		DB	94,95,96,97,98,99,100,101
		DB	102,103,-1,-1,119,-1,132,-1
		DB	115,-1,116,-1,117,-1,118,-1
		DB	-1

;------ LC TABLE
K10	LABEL	BYTE
		DB	01BH,'1234567890-=',08H,09H
		DB	'qwertyuiop[]',0DH,-1,'asdfghjkl;',027H
		DB	60H,-1,5CH,'zxcvbnm,./',-1,'*',-1,' '
		DB	-1

;------ UC TABLE
K11	LABEL	BYTE
		DB	27,'!@#$',37,05EH,'&*()_+',08H,0
		DB	'QWERTYUIOP{}',0DH,-1,'ASDFGHJKL:"'
		DB	07EH,-1,'|ZXCVBNM<>?',-1,0,-1,' ',-1

;------ UC TABLE SCAN
K12	LABEL	BYTE
		DB	84,85,86,87,88,89
		DB	90,91,92,93
;------ ALT TABLE SCAN
K13	LABEL	BYTE
		DB	104,105,106,107,108
		DB	109,110,111,112,113

;------ NUM STATE TABLE
K14	LABEL	BYTE
		DB	'789-456+1230.'

;------ BASE CASE TABLE
K15	LABEL	BYTE
		DB	71,72,73,-1,75,-1,77
		DB	-1,79,80,81,82,83

;------ KEYBOARD INTERRUPT

;		ORG	0E987H
		ORG	00987H
KB_INT		EQU	$
		JMP	KB_INT_1

;------- DISKETTE I/O

;		ORG	0EC59H
		ORG	00C59H
DISKETTE_IO	EQU	$
		JMP	DISKETTE_IO_1

;-------- DISKETTE INTERRUPT

;		ORG	0EF57H
		ORG	00F57H
DISK_INT	EQU	$
		JMP	DISK_INT_1

;------ DISKETTE PARMS

;		ORG	0EFC7H
		ORG	00FC7H

;-------------------------------------------------
; DISK_BASE
;  THIS IS THE SET OF PARAMETERS REQUIRED FOR
;  DISKETTE OPERATION.	THEY ARE POINTED AT BY THE
;  DATA VARIABLE DISK_POINTER.	TO MODIFY THE PARAMETERS,
;  BUILD ANOTHER PARAMETER BLOCK AND POINT AT IT
;--------------------------------------------------

DISK_BASE	LABEL	BYTE

	DB	11011111B	; SRT=D, HD UNLOAD=0F - 1ST SPECIFY BYTE
	DB	2		; HD LOAD=1, MODE=DMA - 2ND SPECIFY BYTE
	DB	MOTOR_WAIT	; WAIT TIME AFTER OPERATION TILL MOTOR OFF
	DB	2		; 512 BYTES/SECTOR
	DB	15		; EOT ( LAST SECTOR ON TRACK)
	DB	01BH		; GAP LENGTH
	DB	0FFH		; DTL
	DB	054H		; GAP LENGTH FOR FORMAT
	DB	0F6H		; FILL BYTE FOR FORMAT
	DB	15		; HEAD SETTLE TIME (MILLISECONDS)
	DB	8		; MOTOR START TIME (1/8 SECONDS)

;------- PRINTER IO

;		ORG	0EFD2H
		ORG	00FD2H
PRINTER_IO	EQU	$
		JMP	PRINTER_IO_1

;-------- VIDEO IO

;--------- ADDED FOR POSSIBLE COMPATIBILITY ENTRY POINTS

	      ;ORG     0F045H
	       ORG     01045H
       ASSUME  CS:CODE,DS:DATA,ES:VIDEO_RAM

EXTRN SET_MODE:NEAR
EXTRN SET_CTYPE:NEAR
EXTRN SET_CPOS:NEAR
EXTRN READ_CURSOR:NEAR
EXTRN READ_LPEN:NEAR
EXTRN ACT_DISP_PAGE:NEAR
EXTRN SCROLL_UP:NEAR
EXTRN SCROLL_DOWN:NEAR
EXTRN READ_AC_CURRENT:NEAR
EXTRN WRITE_AC_CURRENT:NEAR
EXTRN WRITE_C_CURRENT:NEAR
EXTRN SET_COLOR:NEAR
EXTRN WRITE_DOT:NEAR
EXTRN READ_DOT:NEAR
EXTRN WRITE_TTY:NEAR
EXTRN VIDEO_STATE:NEAR

M1	LABEL	WORD	;  TABLE OF ROUTINES WITHIN VIDEO I/O
	DW	OFFSET	SET_MODE
	DW	OFFSET	SET_CTYPE
	DW	OFFSET	SET_CPOS
	DW	OFFSET	READ_CURSOR
	DW	OFFSET	READ_LPEN
	DW	OFFSET	ACT_DISP_PAGE
	DW	OFFSET	SCROLL_UP
	DW	OFFSET	SCROLL_DOWN
	DW	OFFSET	READ_AC_CURRENT
	DW	OFFSET	WRITE_AC_CURRENT
	DW	OFFSET	WRITE_C_CURRENT
	DW	OFFSET	SET_COLOR
	DW	OFFSET	WRITE_DOT
	DW	OFFSET	READ_DOT
	DW	OFFSET	WRITE_TTY
	DW	OFFSET	VIDEO_STATE
M1L	EQU	$-M1

;		ORG	0F065H
		ORG	01065H
VIDEO_IO	EQU	$
		JMP	VIDEO_IO_1

;--------- VIDEO PARMS

;		ORG	0F0A4H
		ORG	010A4H
VIDEO_PARMS	LABEL	BYTE

	DB	38H,28H,2DH,0AH,1FH,6,19H	; SET UP FOR 40X25
	DB	1CH,2,7,6,7
	DB	0,0,0,0
M4	EQU	$-VIDEO_PARMS

	DB	71H,50H,5AH,0AH,1FH,6,19H	; SET UP FOR 80X25
	DB	1CH,2,7,6,7
	DB	0,0,0,0

	DB	38H,28H,2DH,0AH,7FH,6,64H	; SETUP FOR GRAPHICS
	DB	70H,2,1,6,7
	DB	0,0,0,0

	DB	61H,50H,52H,0FH,19H,6,19H	; SETUP FOR 80X25 B&W CARD
	DB	19H,2,0DH,0BH,0CH
	DB	0,0,0,0

M5	LABEL	WORD			; TABLE OF REGEN LENGTHS
	DW	2048		; 40X25
	DW	4096		; 80X25
	DW	16384		; GRAPHICS
	DW	16384		;

;------ COLUMNS
M6	LABEL	BYTE
	DB	40,40,80,80,40,40,80,80

;------ C_REG_TAB
M7	LABEL	BYTE			; TABLE OF MODE SETS
	DB	2CH,28H,2DH,29H,2AH,2EH,1EH,29H

;-------- MEMORY SIZE

;		ORG	0F841H
		ORG	01841H
MEMORY_SIZE_DETERMINE	EQU  $
		JMP	MEMORY_SIZE_DETERMINE_1

;--------- EQUIPMENT DETERMINE

;		ORG	0F84DH
		ORG	0184DH
EQUIPMENT	EQU  $
		JMP	EQUIPMENT_1

;---------- CASSETTE (NO BIOS SUPPORT)

;		ORG	0F859H
		ORG	01859H
CASSETTE_IO	EQU  $
		JMP	CASSETTE_IO_1

;----------------------------------------------------------------------
; CHARACTER GENERATOR GRAPHICS FOR 320X200 AND 640X200 GRAPHICS       :
;----------------------------------------------------------------------
;		ORG	0FA6EH
		ORG	01A6EH
CRT_CHAR_GEN	LABEL	BYTE
	DB	000H,000H,000H,000H,000H,000H,000H,000H ; D_00
	DB	07EH,081H,0A5H,081H,0BDH,099H,081H,07EH ; D_01
	DB	07EH,0FFH,0DBH,0FFH,0C3H,0E7H,0FFH,07EH ; D_02
	DB	06CH,0FEH,0FEH,0FEH,07CH,038H,010H,000H ; D_03
	DB	010H,038H,07CH,0FEH,07CH,038H,010H,000H ; D_04
	DB	038H,07CH,038H,0FEH,0FEH,07CH,038H,07CH ; D_05
	DB	010H,010H,038H,07CH,0FEH,07CH,038H,07CH ; D_06
	DB	000H,000H,018H,03CH,03CH,018H,000H,000H ; D_07
	DB	0FFH,0FFH,0E7H,0C3H,0C3H,0E7H,0FFH,0FFH ; D_08
	DB	000H,03CH,066H,042H,042H,066H,03CH,000H ; D_09
	DB	0FFH,0C3H,099H,0BDH,0BDH,099H,0C3H,0FFH ; D_0A
	DB	00FH,007H,00FH,07DH,0CCH,0CCH,0CCH,078H ; D_0B
	DB	03CH,066H,066H,066H,03CH,018H,07EH,018H ; D_0C
	DB	03FH,033H,03FH,030H,030H,070H,0F0H,0E0H ; D_0D
	DB	07FH,063H,07FH,063H,063H,067H,0E6H,0C0H ; D_0E
	DB	099H,05AH,03CH,0E7H,0E7H,03CH,05AH,099H ; D_0F

	DB	080H,0E0H,0F8H,0FEH,0F8H,0E0H,080H,000H ; D_10
	DB	002H,00EH,03EH,0FEH,03EH,00EH,002H,000H ; D_11
	DB	018H,03CH,07EH,018H,018H,07EH,03CH,018H ; D_12
	DB	066H,066H,066H,066H,066H,000H,066H,000H ; D_13
	DB	07FH,0DBH,0DBH,07BH,01BH,01BH,01BH,000H ; D_14
	DB	03EH,063H,038H,06CH,06CH,038H,0CCH,078H ; D_15
	DB	000H,000H,000H,000H,07EH,07EH,07EH,000H ; D_16
	DB	018H,03CH,07EH,018H,07EH,03CH,018H,0FFH ; D_17
	DB	018H,03CH,07EH,018H,018H,018H,018H,000H ; D_18
	DB	018H,018H,018H,018H,07EH,03CH,018H,000H ; D_19
	DB	000H,018H,00CH,0FEH,00CH,018H,000H,000H ; D_1A
	DB	000H,030H,060H,0FEH,060H,030H,000H,000H ; D_1B
	DB	000H,000H,0C0H,0C0H,0C0H,0FEH,000H,000H ; D_1C
	DB	000H,024H,066H,0FFH,066H,024H,000H,000H ; D_1D
	DB	000H,018H,03CH,07EH,0FFH,0FFH,000H,000H ; D_1E
	DB	000H,0FFH,0FFH,07EH,03CH,018H,000H,000H ; D_1F

	DB	000H,000H,000H,000H,000H,000H,000H,000H ; SP D_20  SPACE
	DB	030H,078H,078H,030H,030H,000H,030H,000H ; ! D_21
	DB	06CH,06CH,06CH,000H,000H,000H,000H,000H ; " D_22
	DB	06CH,06CH,0FEH,06CH,0FEH,06CH,06CH,000H ; # D_23
	DB	030H,07CH,0C0H,078H,00CH,0F8H,030H,000H ; $ D_24
	DB	000H,0C6H,0CCH,018H,030H,066H,0C6H,000H ; PER CENT D_25
	DB	038H,06CH,038H,076H,0DCH,0CCH,076H,000H ; & D_26
	DB	060H,060H,0C0H,000H,000H,000H,000H,000H ; ' D_27
	DB	018H,030H,060H,060H,060H,030H,018H,000H ; ( D_28
	DB	060H,030H,018H,018H,018H,030H,060H,000H ; ) D_29
	DB	000H,066H,03CH,0FFH,03CH,066H,000H,000H ; * D_2A
	DB	000H,030H,030H,0FCH,030H,030H,000H,000H ; + D_2B
	DB	000H,000H,000H,000H,000H,030H,030H,060H ; , D_2C
	DB	000H,000H,000H,0FCH,000H,000H,000H,000H ; - D_2D
	DB	000H,000H,000H,000H,000H,030H,030H,000H ; . D_2E
	DB	006H,00CH,018H,030H,060H,0C0H,080H,000H ; / D_2F

	DB	07CH,0C6H,0CEH,0DEH,0F6H,0E6H,07CH,000H ; 0 D_30
	DB	030H,070H,030H,030H,030H,030H,0FCH,000H ; 1 D_31
	DB	078H,0CCH,00CH,038H,060H,0CCH,0FCH,000H ; 2 D_32
	DB	078H,0CCH,00CH,038H,00CH,0CCH,078H,000H ; 3 D_33
	DB	01CH,03CH,06CH,0CCH,0FEH,00CH,01EH,000H ; 4 D_34
	DB	0FCH,0C0H,0F8H,00CH,00CH,0CCH,078H,000H ; 5 D_35
	DB	038H,060H,0C0H,0F8H,0CCH,0CCH,078H,000H ; 6 D_36
	DB	0FCH,0CCH,00CH,018H,030H,030H,030H,000H ; 7 D_37
	DB	078H,0CCH,0CCH,078H,0CCH,0CCH,078H,000H ; 8 D_38
	DB	078H,0CCH,0CCH,07CH,00CH,018H,070H,000H ; 9 D_39
	DB	000H,030H,030H,000H,000H,030H,030H,000H ; : D_3A
	DB	000H,030H,030H,000H,000H,030H,030H,060H ; ; D_3B
	DB	018H,030H,060H,0C0H,060H,030H,018H,000H ; < D_3C
	DB	000H,000H,0FCH,000H,000H,0FCH,000H,000H ; = D_3D
	DB	060H,030H,018H,00CH,018H,030H,060H,000H ; > D_3E
	DB	078H,0CCH,00CH,018H,030H,000H,030H,000H ; ? D_3F

	DB	07CH,0C6H,0DEH,0DEH,0DEH,0C0H,078H,000H ; @ D_40
	DB	030H,078H,0CCH,0CCH,0FCH,0CCH,0CCH,000H ; A D_41
	DB	0FCH,066H,066H,07CH,066H,066H,0FCH,000H ; B D_42
	DB	03CH,066H,0C0H,0C0H,0C0H,066H,03CH,000H ; C D_43
	DB	0F8H,06CH,066H,066H,066H,06CH,0F8H,000H ; D D_44
	DB	0FEH,062H,068H,078H,068H,062H,0FEH,000H ; E D_45
	DB	0FEH,062H,068H,078H,068H,060H,0F0H,000H ; F D_46
	DB	03CH,066H,0C0H,0C0H,0CEH,066H,03EH,000H ; G D_47
	DB	0CCH,0CCH,0CCH,0FCH,0CCH,0CCH,0CCH,000H ; H D_48
	DB	078H,030H,030H,030H,030H,030H,078H,000H ; I D_49
	DB	01EH,00CH,00CH,00CH,0CCH,0CCH,078H,000H ; J D_4A
	DB	0E6H,066H,06CH,078H,06CH,066H,0E6H,000H ; K D_4B
	DB	0F0H,060H,060H,060H,062H,066H,0FEH,000H ; L D_4C
	DB	0C6H,0EEH,0FEH,0FEH,0D6H,0C6H,0C6H,000H ; M D_4D
	DB	0C6H,0E6H,0F6H,0DEH,0CEH,0C6H,0C6H,000H ; N D_4E
	DB	038H,06CH,0C6H,0C6H,0C6H,06CH,038H,000H ; O D_4F

	DB	0FCH,066H,066H,07CH,060H,060H,0F0H,000H ; P D_50
	DB	078H,0CCH,0CCH,0CCH,0DCH,078H,01CH,000H ; Q D_51
	DB	0FCH,066H,066H,07CH,06CH,066H,0E6H,000H ; R D_52
	DB	078H,0CCH,0E0H,070H,01CH,0CCH,078H,000H ; S D_53
	DB	0FCH,0B4H,030H,030H,030H,030H,078H,000H ; T D_54
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,0FCH,000H ; U D_55
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,078H,030H,000H ; V D_56
	DB	0C6H,0C6H,0C6H,0D6H,0FEH,0EEH,0C6H,000H ; W D_57
	DB	0C6H,0C6H,06CH,038H,038H,06CH,0C6H,000H ; X D_58
	DB	0CCH,0CCH,0CCH,078H,030H,030H,078H,000H ; Y D_59
	DB	0FEH,0C6H,08CH,018H,032H,066H,0FEH,000H ; Z D_5A
	DB	078H,060H,060H,060H,060H,060H,078H,000H ; [ D_5B
	DB	0C0H,060H,030H,018H,00CH,006H,002H,000H ; BACKSLASH D_5C
	DB	078H,018H,018H,018H,018H,018H,078H,000H ; ] D_5D
	DB	010H,038H,06CH,0C6H,000H,000H,000H,000H ; CIRCUMFLEX D_5E
	DB	000H,000H,000H,000H,000H,000H,000H,0FFH ; _ D_5F

	DB	030H,030H,018H,000H,000H,000H,000H,000H ; ` D_60
	DB	000H,000H,078H,00CH,07CH,0CCH,076H,000H ; LOWER CASE A D_61
	DB	0E0H,060H,060H,07CH,066H,066H,0DCH,000H ; L.C. B D_62
	DB	000H,000H,078H,0CCH,0C0H,0CCH,078H,000H ; L.C. C D_63
	DB	01CH,00CH,00CH,07CH,0CCH,0CCH,076H,000H ; L.C. D D_64
	DB	000H,000H,078H,0CCH,0FCH,0C0H,078H,000H ; L.C. E D_65
	DB	038H,06CH,060H,0F0H,060H,060H,0F0H,000H ; L.C. F D_66
	DB	000H,000H,076H,0CCH,0CCH,07CH,00CH,0F8H ; L.C. G D_67
	DB	0E0H,060H,06CH,076H,066H,066H,0E6H,000H ; L.C. H D_68
	DB	030H,000H,070H,030H,030H,030H,078H,000H ; L.C. I D_69
	DB	00CH,000H,00CH,00CH,00CH,0CCH,0CCH,078H ; L.C. J D_6A
	DB	0E0H,060H,066H,06CH,078H,06CH,0E6H,000H ; L.C. K D_6B
	DB	070H,030H,030H,030H,030H,030H,078H,000H ; L.C. L D_6C
	DB	000H,000H,0CCH,0FEH,0FEH,0D6H,0C6H,000H ; L.C. M D_6D
	DB	000H,000H,0F8H,0CCH,0CCH,0CCH,0CCH,000H ; L.C. N D_6E
	DB	000H,000H,078H,0CCH,0CCH,0CCH,078H,000H ; L.C. O D_6F

	DB	000H,000H,0DCH,066H,066H,07CH,060H,0F0H ; L.C. P D_70
	DB	000H,000H,076H,0CCH,0CCH,07CH,00CH,01EH ; L.C. Q D_71
	DB	000H,000H,0DCH,076H,066H,060H,0F0H,000H ; L.C. R D_72
	DB	000H,000H,07CH,0C0H,078H,00CH,0F8H,000H ; L.C. S D_73
	DB	010H,030H,07CH,030H,030H,034H,018H,000H ; L.C. T D_74
	DB	000H,000H,0CCH,0CCH,0CCH,0CCH,076H,000H ; L.C. U D_75
	DB	000H,000H,0CCH,0CCH,0CCH,078H,030H,000H ; L.C. V D_76
	DB	000H,000H,0C6H,0D6H,0FEH,0FEH,06CH,000H ; L.C. W D_77
	DB	000H,000H,0C6H,06CH,038H,06CH,0C6H,000H ; L.C. X D_78
	DB	000H,000H,0CCH,0CCH,0CCH,07CH,00CH,0F8H ; L.C. Y D_79
	DB	000H,000H,0FCH,098H,030H,064H,0FCH,000H ; L.C. Z D_7A
	DB	01CH,030H,030H,0E0H,030H,030H,01CH,000H ; { D_7B
	DB	018H,018H,018H,000H,018H,018H,018H,000H ; | D_7C
	DB	0E0H,030H,030H,01CH,030H,030H,0E0H,000H ; } D_7D
	DB	076H,0DCH,000H,000H,000H,000H,000H,000H ; ~ D_7E
	DB	000H,010H,038H,06CH,0C6H,0C6H,0FEH,000H ; DELTA D_7F

;------ TIME OF DAY

;		ORG	0FE6EH
		ORG	01E6EH
TIME_OF_DAY	EQU	$
		JMP	TIME_OF_DAY_1

;-------- TIMER INTERRUPT

;		ORG	0FEA5H
		ORG	01EA5H
TIMER_INT	EQU	$
		JMP	TIMER_INT_1

;-------- VECTOR TABLE

;		ORG	0FEF3H
		ORG	01EF3H
VECTOR_TABLE	LABEL	WORD
					; VECTOR TABLE
	DW	OFFSET TIMER_INT	; INTERRUPT 8
	DW	OFFSET	KB_INT		; INTERRUPT 9
	DW	OFFSET	D11		; INTERRUPT A (SLAVE INPUT)
	DW	OFFSET	D11		; INTERRUPT B
	DW	OFFSET	D11		; INTERRUPT C
	DW	OFFSET	D11		; INTERRUPT D
	DW	OFFSET DISK_INT 	; INTERRUPT E
	DW	OFFSET	D11		; INTERRUPT F

;------- SOFTWARE INTERRUPTS

	DW	OFFSET VIDEO_IO 	; INT 10H
	DW	OFFSET EQUIPMENT	; INT 11H
	DW	OFFSET MEMORY_SIZE_DETERMINE	; INT 12H
	DW	OFFSET DISKETTE_IO	; INT 13H
	DW	OFFSET RS232_IO 	; INT 14H
	DW	CASSETTE_IO		; INT 15H
	DW	OFFSET KEYBOARD_IO	; INT 16H
	DW	OFFSET PRINTER_IO	; INT 17H
	DW	00000H			; INT 18H
;	DW	0F600H			;  MUST BE INSERTED INTO TABLE LATER
	DW	OFFSET BOOT_STRAP	; INT 19H
	DW	TIME_OF_DAY		; INT 1AH -- TIME OF DAY
	DW	DUMMY_RETURN		; INT 1BH -- KEYBOARD BREAK ADDR
	DW	DUMMY_RETURN		; INT 1CH -- TIMER BREAK ADDR
	DW	VIDEO_PARMS		; INT 1DH -- VIDEO PARAMETERS
	DW	OFFSET DISK_BASE	; INT 1EH -- DISK PARMS
	DW	0			; INT 1FH -- POINTER TO VIDEO EXT

SLAVE_VECTOR_TABLE LABEL WORD		;(INTERRUPT 70 THRU 7F)

	DW	OFFSET	RTC_INT 	; INT 70 REAL TIME CLOCK INTERRUPT VECTOR
	DW	OFFSET	RE_DIRECT	; INT 71 REDIRECT THIS TO INT A
	DW	OFFSET	D11		; INT 72
	DW	OFFSET	D11		; INT 73
	DW	OFFSET	D11		; INT 74
	DW	OFFSET	INT_287 	; INT 75 MATH PROCESSOR INTERRUPT
	DW	OFFSET	D11		; INT 76
	DW	OFFSET	D11		; INT 77

;------- DUMMY INTERRUPT HANDLER

;		ORG	0FF53H
		ORG	01F53H
DUMMY_RETURN	EQU	$

		IRET

;------- PRINT SCREEN

;		ORG	0FF54H
		ORG	01F54H
PRINT_SCREEN	EQU	$
		JMP	PRINT_SCREEN_1
.XLIST
;		ORG	0FF5AH
		ORG	01F5AH

HRD		PROC	FAR
		CALL	DISK_SETUP
		RET
HRD		ENDP

FLOPPY		PROC	FAR
		CALL	DSKETTE_SETUP
		RET
FLOPPY		ENDP

SEEKS_1 	PROC	FAR
		CALL	SEEK
		RET
SEEKS_1 	ENDP

TUTOR:
		JMP	K16
.LIST
;------------------------------------------------
;						:
;  POWER ON RESET VECTOR			:
;						:
;------------------------------------------------
;	ORG	0FFF0H
	ORG	01FF0H
PUBLIC	 P_O_R
; -----  POWER ON RESET
P_O_R	 LABEL	FAR

	DB	0EAH			;HARD CODE JUMP
	DW	OFFSET	RESET		;OFFSET
	DW	0F000H			;SEGMENT

	DB	'01/10/84'              ;RELEASE MARKER

	ORG	01FFEH			;
	DB	0FCH			;THIS PC'S ID
CODE	ENDS
	END
