// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"

XGLLINK void XGLCALL grAlphaControlsITRGBLighting(uint32 temp) {
	log("Error: unsupported function grAlphaControlsITRGBLighting");

}

XGLLINK void XGLCALL grChromakeyValue(uint32 val) {
	vlog("Called grChromakeyValue: color=" << val);

	Voodoo.colorKey = val;
}



XGLLINK void XGLCALL grChromakeyMode(uint32 mode) {
	vlog("Called grChromakeyMode: mode=" << mode);

	if (mode == XGLCK_ENABLE) {
		_exebuffer->ColorKeyEnable(TRUE);
		DX.D3DD->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTFP_NONE);
		Voodoo.colorkeyon = 1;
	} else if (mode == XGLCK_DISABLE) {
		_exebuffer->ColorKeyEnable(FALSE);
		DX.D3DD->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTFP_POINT);
		Voodoo.colorkeyon = 0;
	}

}


XGLLINK void XGLCALL grAlphaTestFunction(uint32 func) {
	vlog("Called grAlphaTestFunction");

	_exebuffer->SetAlphaTestFunc(atest_lut[func]);
}


XGLLINK void XGLCALL grAlphaTestReferenceValue(uint8 val) {
	vlog("Called grAlphaTestReferenceValue: value=" << (int)val);

	// Zelda text thing
//	return;

	_exebuffer->Flush();

	DX.D3DD->SetRenderState(D3DRENDERSTATE_ALPHAREF, (DWORD)val);
}



XGLLINK void XGLCALL grAlphaBlendFunction(uint32 srccolor_func, uint32 destcolor_func, uint32 srcalpha_func, uint32 destalpha_func) {

	vlog("Called grAlphaBlendFunction: srccolor_func=" << srccolor_func << " destcolor_func=" << destcolor_func << " srcalpha_func=" << srcalpha_func << " destalpha_func=" << destalpha_func);

	// Zelda text thing
//	return;

	_exebuffer->Flush();

	DX.D3DD->SetRenderState(D3DRENDERSTATE_SRCBLEND, src_blend_lut[srccolor_func]);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_DESTBLEND, dst_blend_lut[destcolor_func]);
}


XGLLINK void XGLCALL grColorMask(uint32 temp1, uint32 temp2) {
	vlog("Called grColorMask: temp1=" << temp1 << " temp2=" << temp2);

}


XGLLINK void XGLCALL grAlphaCombine(uint32 temp1, uint32 temp2, uint32 temp3, uint32 temp4, uint32 temp5) {
	vlog("Called grAlphaCombine");

}


XGLLINK void XGLCALL grConstantColorValue(uint32 value) {
	vlog("Called grConstantColorValue");

	Voodoo.constantColor = colorconv(value);
	Voodoo.CCA = ((value & 0xFF000000) >> 24) / 255.0f;
	Voodoo.CCR = ((value & 0x00FF0000) >> 16) / 255.0f;
	Voodoo.CCG = ((value & 0x0000FF00) >> 8) / 255.0f;
	Voodoo.CCB = (value & 0x000000FF) / 255.0f;

	_exebuffer->Flush();

	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREFACTOR, Voodoo.constantColor);
}

XGLLINK void XGLCALL grConstantColorValue4(float a, float r, float g, float b) {

	Voodoo.CCA = a;
	Voodoo.CCR = r;
	Voodoo.CCG = g;
	Voodoo.CCB = b;
}




XGLLINK void XGLCALL grColorCombine(uint32 func, uint32 factor, uint32 local, uint32 other, uint32 invert) {

	vlog("Called grColorCombine: func=" << func << "  fac=" << factor << "  local=" << local << "  other=" << other);

	// Bounds check
	int badbounds =
		(func < 0) || (func >= XGLCOMBINEFUNC_MAX) || 
		(factor < 0) || (factor >= XGLCOMBINEFACTOR_MAX) || 
		(local < 0 ) || (local >= XGLLOCAL_MAX) || 
		(other < 0) || (other >= XGLOTHER_MAX);

	// If we have a CC state set for this mode, use it... otherwise, error.
	if (!badbounds && colorcombine_lut[func][factor][local][other].set) {
		getcolor = 	colorcombine_lut[func][factor][local][other].getcolor;
		_exebuffer->SetColorArg1(colorcombine_lut[func][factor][local][other].colorarg1);
		_exebuffer->SetColorArg2(colorcombine_lut[func][factor][local][other].colorarg2);
		_exebuffer->SetColorOp(colorcombine_lut[func][factor][local][other].colorop);
	} else {
		log("  Error in grColorCombine: func=" << func << "  fac=" << factor << "  local=" << local << "  other=" << other);
		return;
	}

//	getcolor = white;
/*
	_exebuffer->SetColorArg1(D3DTA_TEXTURE);
	_exebuffer->SetColorArg2(D3DTA_CURRENT);
//	_exebuffer->SetColorOp(D3DTOP_MODULATE);
	_exebuffer->SetColorOp(D3DTOP_SELECTARG1);
*/
}



XGLLINK void XGLCALL guAlphaSource(uint32 mode) {
	vlog("Called guAlphaSource: mode=" << mode);

//	_exebuffer->SetAlphaArg2(D3DTA_CURRENT);

	switch (mode) {
	case XGLALPHA_CONSTANT:
		_exebuffer->SetAlphaOp(D3DTOP_SELECTARG1);
		_exebuffer->SetAlphaArg1(D3DTA_TFACTOR);
		break;
	case XGLALPHA_GOURAUD:
		_exebuffer->SetAlphaOp(D3DTOP_SELECTARG2);
		_exebuffer->SetAlphaArg1(D3DTA_TEXTURE);
		break;
	case XGLALPHA_TEXTURE:
		_exebuffer->SetAlphaOp(D3DTOP_SELECTARG1);
		_exebuffer->SetAlphaArg1(D3DTA_TEXTURE);
		break;
	case XGLALPHA_GOURAUD_TEXTURE:
		// Zelda text
		if (Settings.alphaop_modulate == 0) {
			_exebuffer->SetAlphaOp(D3DTOP_SELECTARG2);
		} else {
			_exebuffer->SetAlphaOp(D3DTOP_MODULATE);
		}
		_exebuffer->SetAlphaArg1(D3DTA_TEXTURE);
		break;
	}
}



XGLLINK void XGLCALL guColorCombineFunction(uint32 func) {
	vlog("Called guColorCombineFunction: func=" << func);

//	return;
	switch (func) {
	case XGLCC_CONSTANT:					grColorCombine(XGLCOMBINEFUNC_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_CONSTANT, XGLOTHER_NONE, 0); break;
	case XGLCC_GOURAUD:						grColorCombine(XGLCOMBINEFUNC_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_NONE, 0); break;

		// Mario water...
	case XGLCC_TEXTURE:						grColorCombine(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, XGLLOCAL_NONE, XGLOTHER_TEXTURE, 0); break;
	case XGLCC_MODULATE_TEXTURE_CONSTANT:	grColorCombine(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, 0); break;
	case XGLCC_MODULATE:					grColorCombine(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, 0); break;
	case XGLCC_ADD:							grColorCombine(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, 0); break;
	default:											
		grColorCombine(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ZERO, XGLLOCAL_NONE, XGLOTHER_NONE, 0); 
		log("  Error in guColorCombineFunction, unsupported mode: " << func);
		break;
	}
}
