/*
Coordinates of Colorbar pattern:
In this source list, names of X-Window's Default Color Map are shown,
but, DO NOT USE DEFAULT COLORMAP when you program.
*/

#define NUM_BLOCKS_FOR_COLOR_BAR       58
#define BLACK   0x00
#define WHITE   0xFF
#define RED     0x01
#define GREEN   0x02
#define BLUE    0x03
#define YELLOW  0x04
#define MAGENTA 0x05
#define CYAN    0x06
#define MONO_1  0xFF
#define MONO_2  0xDB
#define MONO_3  0xB6
#define MONO_4  0x92
#define MONO_5  0x6D
#define MONO_6  0x49
#define MONO_7  0x24
#define MONO_8  0x00

/* global data structures for this file */
/* Define the structure of a block of the screen (used in color bar) */
struct screen_block {
  int upper_left_x;   /* the x coordinate of the upper left corner */
  int upper_left_y;   /* the y coordinate of the upper left corner */
  int width;          /* the width of the block */
  int height;         /* the height of the block */
  int red, green, blue;		/* the color of the block */
} ; /* end struct screen_block */

/* Declare and initialize the blocks that together make up the color bar */
/* pattern screen for the 1280 x 1024 displays.                          */
struct screen_block color_bar_table[NUM_BLOCKS_FOR_COLOR_BAR] = {
  {    0,    0, 1280, 1024, 0x0000, 0x0000, 0x0000}, /* BLACK */
  {    0,    0,  480,   64, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  800,  192,  480,   64, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {    0,  256,  160,  512, 0x0000, 0xffff, 0x0000}, /* GREEN */
  {  160,  256,  160,  512, 0xffff, 0xffff, 0x0000}, /* YELLOW */
  {  320,  256,  160,  512, 0xffff, 0x0000, 0x0000}, /* RED */
  {  480,  256,  160,  512, 0xffff, 0x0000, 0xffff}, /* MAGENTA */
  {  640,  256,  160,  512, 0x0000, 0x0000, 0xffff}, /* BLUE */
  {  800,  256,  160,  512, 0x0000, 0xffff, 0xffff}, /* CYAN */
  {  960,  256,  160,  512, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {    0,  768,  160,  128, 0xffff, 0xffff, 0xffff}, /* MONO_1 (=WHITE)*/
  {  160,  768,  160,  128, 0xdb00, 0xdb00, 0xdb00}, /* MONO_2 */
  {  320,  768,  160,  128, 0xb600, 0xb600, 0xb600}, /* MONO_3 */
  {  480,  768,  160,  128, 0x9200, 0x9200, 0x9200}, /* MONO_4 */
  {  640,  768,  160,  128, 0x6d00, 0x6d00, 0x6d00}, /* MONO_5 */
  {  800,  768,  160,  128, 0x4900, 0x4900, 0x4900}, /* MONO_6 */
  {  960,  768,  160,  128, 0x2400, 0x2400, 0x2400}, /* MONO_7 */
  { 1120,  768,  160,  128, 0x0000, 0x0000, 0x0000}, /* MONO_8 (=BLACK)*/
  {    0,  896,   96,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  192,  896,   42,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  276,  896,   42,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  360,  896,   32,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  424,  896,   32,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  488,  896,   32,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  552,  896,   32,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  616,  896,   16,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  648,  896,   16,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  680,  896,   16,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  712,  896,   16,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  744,  896,   16,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  776,  896,   16,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  808,  896,    8,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  824,  896,    8,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  840,  896,    8,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  856,  896,    8,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  872,  896,    8,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  888,  896,    8,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  904,  896,    4,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  912,  896,    4,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  920,  896,    4,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  928,  896,    4,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  936,  896,    4,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  944,  896,    4,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  960,  896,    2,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  964,  896,    2,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  968,  896,    2,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  972,  896,    2,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  976,  896,    2,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  {  980,  896,    2,  128, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1159,  927,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1159,  959,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1159,  991,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1199,  927,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1199,  959,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1199,  991,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1239,  927,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1239,  959,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
  { 1239,  991,    1,    1, 0xffff, 0xffff, 0xffff}, /* WHITE */
} ; /* end color_bar_table[] */
