
;--- dll for deb16fw for switching screen to debugger and 
;--- back to windows on win3x/win9x systems

;--- if a file deb16fwv.ini is located in the same directory
;--- as the dll, some parameters are read from there. The entries
;--- have to be in section [parms], and currently known are:
;---   VideoMode: the text mode to switch when the debugger is activated
;---   Use8x8Charset: load the 8x8 charset after switch to text mode
;--- This private profile file is never written to, so it has to be
;--- created manually if needed. In most cases the default values will
;--- do nicely.


		.286
        .model small
        .386

?USEDEATH		equ 1	;1=use Death/Resurrection, 0=use DisableOEMLayer
?SAVEGDISCREEN	equ 1	;1=save/restore screen content with BitBlt
?GETDESKTOPDC	equ 0	;1=wrap Death and Resurrection in a GetDC/ReleaseDC
?SELECTONINIT	equ 1	;1=select bitmap into compatible DC on init only
?FIXWIN31BUG	equ 1	;1=alloc bitmap 1 scan line larger than necessary
?CALLINT2F		equ 0	;1=call int 2f with ax=400x
?SETTEXTMODE	equ 1	;1=set text mode after GDI is off
?LOAD8X8CHARSET	equ 1	;1=load 8x8 charset after text mode is set
?RESETES		equ 0	;1=set ES to 0
?SWITCHSTACK	equ 1	;1=switch stack (required for win31)
?DEFINENULLSEG	equ 0	;1=define a NULL segment at start of DGROUP

?TEXTMODE		equ 83h	;text mode to set (may be a vesa mode)

;--- windows prototypes, equates, structures

GetModuleFileName   proto far pascal handle:word, lpszName:far ptr, wMax:word
GetPrivateProfileInt	proto far pascal :far ptr, :far ptr, :word, :far ptr
BitBlt				proto far pascal hDC:word, x:word, y:word, _dx:word, dy:word, :word, :word, :word, :dword
CreateDC			proto far pascal :far ptr, :far ptr, :far ptr, :far ptr
CreateCompatibleBitmap	proto far pascal hDC:word, :word, :word
CreateCompatibleDC	proto far pascal hDC:word
Death				proto far pascal hDC:word
DeleteObject    	proto far pascal hGDIObject:word
GetDeviceCaps		proto far pascal hDC:word, :word
SelectObject    	proto far pascal hDC:word,hGDIObject:word
Resurrection		proto far pascal hDC:word, w1:word, w2:word, w3:word, w4:word, w5:word, w6:word
DeleteDC			proto far pascal :word

HORZRES		equ 8
VERTRES		equ 10
SRCCOPY		equ 0CC0020h

;--------- macros to avoid too many if...endifs in the code

@SwitchStackTo macro
if ?SWITCHSTACK
		call SwitchStackTo
endif
endm
@SwitchStackBack macro
if ?SWITCHSTACK
		call SwitchStackBack
endif
endm
@ResetES macro
if ?RESETES
		push 0
        pop	 es
endif
endm

@SaveDC macro        
if ?GETDESKTOPDC
		invoke	GetDC, 0
        push	ax
endif
endm  	
@RestoreDC macro        
if ?GETDESKTOPDC
  		pop		ax
        invoke	ReleaseDC, 0, ax
endif
endm

@SelectBitmap macro
ife ?SELECTONINIT
        invoke	SelectObject, hCompDC, hBitmap
        push	ax
endif
endm
@RestoreBitmap macro        
ife ?SELECTONINIT
		pop		ax
		invoke	SelectObject, hCompDC, ax
endif
endm    

@SaveScreen macro        
if ?SAVEGDISCREEN
  		@SelectBitmap
        invoke	BitBlt, hCompDC, 0, 0, _dx, _dy, hDesktopDC, 0, 0, SRCCOPY
        @RestoreBitmap
endif
endm  
@RestoreScreen macro        
if ?SAVEGDISCREEN
		@SelectBitmap
        invoke	BitBlt, hDesktopDC, 0, 0, _dx, _dy, hCompDC, 0, 0, SRCCOPY
        @RestoreBitmap
endif        
endm

@CallInt2fIn macro        
if ?CALLINT2F
  		mov		ax,4000h
        int		2Fh
        mov		ax,4001h
        int		2Fh
endif
endm  
@CallInt2fOut macro
if ?CALLINT2F
  		mov		ax,4002h
        int		2Fh
        mov		ax,4007h
        int		2Fh
endif
endm

@SetTextMode macro        
local label1
if ?SETTEXTMODE
  		mov		ax,wTextMode
        or		ah,ah
        jz		label1
  		mov		bx,ax
  		mov		ax,4f02h
label1:        
        int		10h
        cmp		bUse8x8,0
        jz		label2
		mov		ax,1112h
        mov		bl,0
        int		10h
label2:        
endif
endm

;-------------- end of macros

if ?DEFINENULLSEG
NULL	segment word public 'BEGDATA'
		dw 0,0,5,0,0,0,0,0
NULL	ends
DGROUP	group NULL
endif

		.data
        
hDesktopDC	dw 0		;desktop DC
hCompDC		dw 0		;memory DC
hBitmap		dw 0		;bitmap to save screen contents
hBitmapOld	dw 0		;original bitmap saved from memory DC
_dx			dw 0		;screen width
_dy			dw 0		;screen height
wTextMode	dw ?TEXTMODE
bUse8x8		db ?LOAD8X8CHARSET
bFlags		db 0

FL_INIT		equ 1		;VideoInit called

		.const
        
szDisplay	db "DISPLAY",0
szSection	db "parms",0
szVideoMode	db "VideoMode",0
sz8x8		db "Use8x8Charset",0

if ?SWITCHSTACK
		.data
		align 2
wStackTop	dw top_of_stack
		.data?
		db 1000h dup (?)
top_of_stack label byte            
endif

		.code

VideoInit				proto far pascal
VideoDone				proto far pascal
SwitchToDebuggerScreen	proto far pascal
SwitchToWindowsScreen	proto far pascal

if ?SWITCHSTACK
SwitchStackTo proc
		pop		bx
		mov		dx,ss
        mov		cx,sp
        mov		ss,ax
        mov		sp,wStackTop
        sub		wStackTop, 100h
        push	dx
        push    cx
        jmp		bx
SwitchStackTo endp

SwitchStackBack proc
		pop		dx
		pop		cx
        pop		ss
        mov		sp,cx
        add		wStackTop, 100h
        jmp		dx
SwitchStackBack endp
endif

;---------------------------------
;--- void SwitchToDebuggerScreen()
;---------------------------------

SwitchToDebuggerScreen proc far pascal uses ds es gs

		mov		ax, DGROUP
        mov		ds, ax
        @ResetES
        test	bFlags, FL_INIT
        jnz		@F
        push	ax
        invoke	VideoInit
        and		ax, ax
        pop		ax
        jz		exit
@@:
		@SwitchStackTo
ife ?USEDEATH        
		invoke	DisableOemLayer
else
		@SaveScreen
  		@CallInt2fIn
  		@SaveDC
		invoke	Death, hDesktopDC
		@RestoreDC
endif
		@SwitchStackBack
        @SetTextMode
exit:        
		ret
SwitchToDebuggerScreen endp

;---------------------------------
;--- void SwitchToWindowsScreen()
;---------------------------------

SwitchToWindowsScreen proc far pascal uses ds es gs

		mov		ax, DGROUP
        mov		ds, ax
        @ResetES
		@SwitchStackTo
ife ?USEDEATH        
		invoke	EnableOemLayer
else
		@SaveDC
		invoke	Resurrection, hDesktopDC, 0, 0, 0, 0, 0, 0
		@RestoreDC
		@CallInt2fOut
		@RestoreScreen
endif
		@SwitchStackBack
		ret

SwitchToWindowsScreen endp

;---------------------------------
;--- BOOL VideoInit()
;--- returns 0 on error, else 1
;---------------------------------

VideoInit proc far pascal uses ds es gs

		mov		ax, DGROUP
        mov		ds, ax
if ?USEDEATH        
		cmp		hDesktopDC,0
        jnz		sm1
		invoke	CreateDC, addr szDisplay, 0, 0, 0
        and		ax, ax
        jz		exit
        mov		hDesktopDC, ax
        invoke	GetDeviceCaps, hDesktopDC, HORZRES
        mov		_dx, ax
        invoke	GetDeviceCaps, hDesktopDC, VERTRES
        mov		_dy, ax
sm1:
		cmp		hCompDC,0
        jnz		sm2
        invoke	CreateCompatibleDC, 0
        and		ax,ax
        jz		exit
        mov		hCompDC, ax
sm2:
		cmp		hBitmap,0
        jnz		sm3
        mov		ax, _dy	
  if ?FIXWIN31BUG        
        inc		ax				;add one scan line (bug in win31)
  endif        
        invoke	CreateCompatibleBitmap, hDesktopDC, _dx, ax
        and		ax, ax
        jz		exit
        mov		hBitmap, ax
  if ?SELECTONINIT
		invoke	SelectObject, hCompDC, ax
        mov		hBitmapOld, ax
  endif
endif
sm3:
		or		bFlags, FL_INIT
		mov		ax, 1
exit:
		ret
VideoInit endp

;---------------------------------
;--- void DestroyGDIObjects() 
;---------------------------------

DestroyGDIObjects proc        

if ?USEDEATH
		mov	cx, hDesktopDC
        jcxz @F
        invoke	DeleteDC, cx
        mov	hDesktopDC, 0
@@:        
		mov	cx, hCompDC
        jcxz @F
  if ?SELECTONINIT
		invoke	SelectObject, hCompDC, hBitmapOld
  endif
        invoke	DeleteDC, hCompDC
        mov  hCompDC, 0
@@:        
		mov	cx, hBitmap
        jcxz @F
        invoke	DeleteObject, cx
        mov hBitmap, 0
@@:
endif
		ret
DestroyGDIObjects endp        

;---------------------------------
;--- void VideoDone()
;---------------------------------

VideoDone proc far pascal uses ds es gs
		
		mov		ax, DGROUP
        mov		ds, ax
        invoke	DestroyGDIObjects
		ret
VideoDone endp

;---------------------------------
;--- int Wep(WORD wCode)
;---------------------------------

Wep		proc far pascal uses ds wCode:word

		mov		ax, DGROUP
        mov		ds, ax
		call	DestroyGDIObjects
        mov     ax,1
        ret
Wep		endp

;-------------------------------------
;--- int LibMain(). dll initialization
;-------------------------------------

LibMain	proc far pascal uses ds

local	szPath[128]:byte

		mov		ax, DGROUP
        mov		ds, ax

;--------------- check if file deb16fwv.ini exists        
        
		invoke	GetModuleFileName, ds, addr szPath, sizeof szPath
        cmp		ax,3
        jbe		@F
        sub		ax, 3
        lea		bx, szPath
		add		bx, ax        
        mov		dword ptr ss:[bx],"ini"

;--------------- yes, it exists, now try to read VideoMode and Use8x8Charset

        invoke	GetPrivateProfileInt, addr szSection, addr szVideoMode, ?TEXTMODE, addr szPath
        mov		wTextMode, ax
        invoke	GetPrivateProfileInt, addr szSection, addr sz8x8, ?LOAD8X8CHARSET, addr szPath
        mov		bUse8x8, al
@@:        
        mov     ax,1
        ret
LibMain	endp

		end    LibMain
