.model tiny
.code
org 100h

include enc.inc

Origin=EncLoadedAt-100h
;jmp 1c4h
;org 1c4h
Top:
  cld
  push di         ; di points after the decoding
                  ; this space is free since it was filled before
                  ; with the encoded original
  mov si,offset BegMoveData+Origin
  mov cx,offset EndMoveData-offset BegMoveData

  rep movsb
  pop di
  jmp di

; This stuff now had better be relocatable.  On entry di points to its
; head.
BegMoveData:
; Copy the (now) decoded programme to ds:100=cs:100=es:100
  mov cx,di
  sub cx,offset RealCode+Origin   ; length of decoded program
  inc cx
  shr cx,1    ; cx>=2*Length of decoded program
  mov si,offset RealCode+Origin
  mov di,100h
  rep movsw

  mov ax,100h
  push ax
  xor ax,ax  ; I am sure some are not needed, so I commented them out
;  mov bx,ax
  mov cx,ax
;  mov dx,ax
  mov si,ax
  mov di,ax
  mov bp,ax
  ret         ; jump to 100h
EndMoveData:

;db 0,0,0,0,0,0,0,0  ; room for 16 character version number if wanted

RealCode = $+((8+8+4)/2)
;org Top+(01e0h-01c4h)
;  mov ax,4c00h
;  int 21h

end Top
