.model tiny,C

maxline = 32
umaxline = 63/4
.data?
  in_line db ?
  sendz   db ?


.code

nencode_block proc
public nencode_block
       arg to:word, from:word, len:word
       mov cx,len
       or cx,cx
       jz ClearLine
       push si
       push di
       cld
       mov ax,ds
       mov es,ax
       mov di,to
       mov si,from
       mov dl,in_line
Top:
       lodsb
       mov ah,al
       and ax,0f00fh
       shr ah,1
       shr ah,1
       shr ah,1
       shr ah,1
       add ax,'AA'
       stosw
       inc dl
       cmp dl,maxline
       ja putCRLF
       loop Top
Return:
       mov in_line,dl
       sub di,to
       mov ax,di
       pop di
       pop si
       ret
putCRLF:
       xor dx,dx
       mov al,0ah
       stosb
       loop Top
       jmp Return
ClearLine:
       mov in_line,0
       xor ax,ax
       ret
nencode_block endp

CodeTop = 34

uuencode_block proc
public uuencode_block
       arg to:word, from:word, len:word
       mov cx,len
       or cx,cx
       jz uClearLine
       push si
       push di
       cld
       mov ax,ds
       mov es,ax
       mov di,to
       mov si,from
       cmp sendz,0
       jz Nosend
       mov al,'z'
       stosb
       mov sendz,0
Nosend:
uTop:
       xor bl,bl
       clc
       mov dh,[si+2]
       rcr dh,1
       rcl bl,1
       rcr dh,1
       rcl bl,1
                      ; Carry clear now
       mov dl,[si+1]
       rcr dl,1
       rcl bl,1
       rcr dl,1
       rcl bl,1
       lodsb
       rcr al,1
       rcl bl,1
       rcr al,1
       rcl bl,1
       mov bh,al
       inc si
       inc si

       add bx,'""'
       add dx,'""'
       mov [di],bx
       mov [di+2],dx
       add di,4

       inc in_line
       cmp in_line,umaxline
       ja uputCRLF
       loop uTop
uReturn:
       sub di,to
       mov ax,di
       pop di
       pop si
       ret
uputCRLF:
       mov in_line,0
       mov ax,0ah
       stosb
       mov al,'z'
       stosb
       loop uTop
       jmp uReturn
uClearLine:
       mov in_line,0
       mov sendz,1
       xor ax,ax
       ret
uuencode_block endp

       end
