//===========================================================
// LC.H -- Header File 
//
// Copyright (C) 1995 Ziff-Davis Publishing Company
// First published in PC Magazine by Douglas Boling
//===========================================================
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#if !defined(WIN32)
  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
#else
  #define WIN16     FALSE
#endif

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
typedef struct {
	INT sType;
	char szCmd[128];
	char szDir[128];
	char szDesc[64];
	char szIconFName[128];
	UINT wIconIndex;
	UINT wStartFlags;
	RECT rect;
} MYPROGDATA;
typedef MYPROGDATA far *LPMYPROGDATA;

typedef struct tagICONPROPS { /* ip */

    unsigned reserved:12,   /* reserved                         */
             fResponse:1,   /* always 1                         */
             fRelease:1,    /* 1 if app. frees object, else 0   */
             reserved1:1,   /* reserved                         */
             fAckReq:1;     /* 1 if app. should respond, else 0 */
    int      cfFormat;      /* clipboard format (not used)      */
    int      nWidth;        /* width, in pixels, of the icon    */
    int      nHeight;       /* height, in pixels, of the icon   */
    BYTE     nPlanes;       /* number of planes in XOR mask     */

    BYTE     nBitsPixel;    /* number of bits/pixel in XOR mask */
    LPBYTE   lpANDbits;     /* points to AND mask array         */
    LPBYTE   lpXORbits;     /* points to XOR mask array         */
} ICONPROPS;
typedef ICONPROPS far *LPICONPROPS;

//
//
//
#define MFLAG_FIRST       0x0001
#define MFLAG_LAUNCH      0x0002
#define MFLAG_DIRTY       0x0004
#define MFLAG_DOSLAUNCH   0x0010

#define START_MIN         0x0001
#define START_MAX         0x0002
#define START_DEFENV      0x0004
#define START_DEFSIZE     0x0008
#define START_DOSLAUNCH   0x0010

//
// Error numbers
//
#define ERR_LAUNCH            16
#define ERR_DOS               64

#define ERR_DISKFULL           1
#define ERR_BADFILE            2
#define ERR_CANCELED           3
#define ERR_NOCMDSPECIFIED     4
#define ERR_BADNUM             5
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK EditEnvDlgProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK SetIconDlgProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc(HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyGetFilename (HWND, char *, INT, char *, INT);
BOOL MyGetSavename (HWND, char *, INT, char *, INT);
BOOL MyWritePrivateProfileInt (char *, char *, int, int, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
void PrintError (HWND, INT);
//
// Program specific prototypes
//
INT SetControls (HWND, LPMYPROGDATA, LPSTR);
INT SaveDataFile (HWND, LPSTR, LPMYPROGDATA, LPSTR);
INT OpenDataFile (LPSTR, LPMYPROGDATA, LPSTR);
HICON GetBestIcon (LPMYPROGDATA, LPSTR);
INT ModIconList (HWND, LPSTR);
LPSTR GetEndofName (LPSTR);
INT FillLB (HWND, UINT, LPSTR);
INT SetTitle (HWND);

// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoTimerMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoLaunchProgMain (HWND, UINT, UINT, LONG);
LONG DoDDEWorkMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainMenuNew (HWND, UINT, HWND, UINT);
LONG DoMainMenuOpen (HWND, UINT, HWND, UINT);
LONG DoMainMenuSave (HWND, UINT, HWND, UINT);
LONG DoMainMenuSaveAs (HWND, UINT, HWND, UINT);
LONG DoMainCtlAbout (HWND, UINT, HWND, UINT);
LONG DoMainCtlExit (HWND, UINT, HWND, UINT);
LONG DoMainCtlCmd (HWND, UINT, HWND, UINT);
LONG DoMainCtlRButtons (HWND, UINT, HWND, UINT);
LONG DoMainCtlRBEnv (HWND, UINT, HWND, UINT);
LONG DoMainCtlRBStart (HWND, UINT, HWND, UINT);
LONG DoMainCtlChkBoxes (HWND, UINT, HWND, UINT);
LONG DoMainCtlBrowse (HWND, UINT, HWND, UINT);
LONG DoMainCtlEnvEdit (HWND, UINT, HWND, UINT);
LONG DoMainCtlSetIcon (HWND, UINT, HWND, UINT);
LONG DoMainCtlDOSIBox (HWND, UINT, HWND, UINT);
//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"

#define     PRO_TIMERFREQ "TimerFreq"
//
// Resource Idendifiers
//
#define     IDM_NEW         10
#define     IDM_OPEN        11
#define     IDM_SAVE        12
#define     IDM_SAVEAS      13
#define     IDM_EXIT        14

#define     IDM_ABOUT	    20

#define     IDD_ABOUT	   100
#define     IDD_EXIT       101

#define     IDD_CMD        102
#define     IDD_WDIR       103
#define     IDD_BROWSE     104
#define     IDD_RBENV      108
#define     IDD_RBSIZE     109
#define     IDD_RBDOS      110
#define     IDD_RBATTR     111
#define     IDD_PROPS      112

#define     IDD_ENVA       120
#define     IDD_ENVB       121
#define     IDD_ENVSPECT   122
#define     IDD_ENVSPEC    123
#define     IDD_ENVADD     124
#define     IDD_ENVDEL     125
#define     IDD_ENVEDIT    126
#define     IDD_ENVLAST    126

#define     IDD_SIZEA      130
#define     IDD_SIZEXT     132
#define     IDD_SIZEX      133
#define     IDD_SIZEYT     134
#define     IDD_SIZEY      135
#define     IDD_SIZECXT    136
#define     IDD_SIZECX     137
#define     IDD_SIZECYT    138
#define     IDD_SIZECY     139
#define     IDD_SIZELAST   139

#define     IDD_DOSA       140
#define     IDD_DOSAT      141
#define     IDD_DOSSPECT   142
#define     IDD_DOSSPEC    143
#define     IDD_DOSIBOX    144
#define     IDD_DOSICON    145
#define     IDD_DOSSETICON 146
#define     IDD_DOSLAST    146

#define     IDD_RFG        170
#define     IDD_RF1        171
#define     IDD_RF2        172
#define     IDD_RF3        173

#define     IDD_IFILE      200
#define     IDD_ILIBS      201
#define     IDD_LIST       202

#define     IDD_NEWVAR     230

#define     IDD_PROGSTR    300
#define     IDD_COPYRIGHT  301
#define     IDD_COPYDATE   302

