#include "config.h"
#include "slrnfeat.h"

#include <stdio.h>
#include <string.h>

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifndef VMS
# include <sys/types.h>
# include <sys/stat.h>
#else
# include "vms.h"
#endif

#ifndef VMS
/* I have no idea whether or not this works under VMS.  Please let me know
 * if it does.
 */
#if HAVE_DIRENT_H
# include <dirent.h>
#else
# ifdef HAVE_DIRECT_H
#  include <direct.h>
# else
#  define dirent direct
#  define NEED_D_NAMLEN
#  if HAVE_SYS_NDIR_H
#   include <sys/ndir.h>
#  endif
#  if HAVE_SYS_DIR_H
#   include <sys/dir.h>
#  endif
#  if HAVE_NDIR_H
#   include <ndir.h>
#  endif
# endif
#endif

#else				       /* VMS */
#define DIR int
#endif

#include "util.h"
#include "slrndir.h"
#include "menu.h"
#include "ttymsg.h"

struct _Slrn_Dir_Type 
{
   DIR *dp;
};

Slrn_Dir_Type *slrn_open_dir (char *dir)
{
#ifdef VMS
   slrn_error ("slrn_open_dir has not been ported to VMS");
   return NULL;
#else
   Slrn_Dir_Type *d;
   DIR *dp;

   d = (Slrn_Dir_Type *) slrn_malloc (sizeof (Slrn_Dir_Type), 1, 1);
   if (d == NULL)
     return NULL;
   
   if (NULL == (dp = opendir (dir)))
     {
	slrn_free ((char *)d);
	return NULL;
     }
   
   d->dp = dp;
   return d;
#endif
}

void slrn_close_dir (Slrn_Dir_Type *d)
{
#ifndef VMS
   if (d == NULL) return;
   closedir (d->dp);
   slrn_free ((char *)d);
#endif
}

Slrn_Dirent_Type *slrn_read_dir (Slrn_Dir_Type *d)
{
#ifdef VMS
   return NULL;
#else
   struct dirent *ep;
   unsigned int len;
   static Slrn_Dirent_Type dir;

   if (d == NULL) return NULL;
   ep = readdir (d->dp);
   if (ep == NULL)
     return NULL;
   
   memset ((char *) &dir, 0, sizeof(Slrn_Dirent_Type));
   
#ifdef NEED_D_NAMLEN
   len = ep->d_namlen;
#else
   len = strlen (ep->d_name);
#endif
   
   if (len > SLRN_MAX_PATH_LEN)
     len = SLRN_MAX_PATH_LEN;

   strncpy (dir.name, ep->d_name, len);
   dir.name [len] = 0;
   
   dir.name_len = len;

   return &dir;
#endif
}



/* This function is from JED */
char *slrn_getcwd (void)
{
   static char cwd[SLRN_MAX_PATH_LEN];
   char *c;
   
#ifdef HAVE_GETCWD
# if defined (__EMX__)
   c = _getcwd2(cwd, 254);		       /* includes drive specifier */
# else
   c = getcwd(cwd, 254);		       /* djggp includes drive specifier */
# endif
#else
   c = (char *) getwd(cwd);
#endif

   if (c == NULL)
     {
#ifndef REAL_UNIX_SYSTEM
	slrn_error ("Unable to getcwd");
	return NULL;
#else
	struct stat st1, st2;

	if ((NULL == (c = getenv ("PWD")))
	    || (-1 == stat (c, &st1))
	    || (-1 == stat (".", &st2))
	    || (st1.st_dev != st2.st_dev)
	    || (st1.st_ino != st2.st_ino))
	  {
	     slrn_error ("Unable to getcwd");
	     return NULL;
	  }

	strncpy (cwd, c, sizeof (cwd));
	cwd [sizeof (cwd) - 1] = 0;
#endif
     }

   return cwd;
}

int slrn_chdir (char *dir)
{
   unsigned int len;
   char dirbuf[SLRN_MAX_PATH_LEN + 1];

   if (dir == NULL)
     return -1;
   
   strncpy (dirbuf, dir, SLRN_MAX_PATH_LEN);
   dirbuf[SLRN_MAX_PATH_LEN] = 0;
   len = strlen (dirbuf);
   
   /* I may have to add code to handle something like C:/ */
   if ((len > 1) && (dirbuf[len - 1] == SLRN_PATH_SLASH_CHAR))
     {
	len--;
	dirbuf [len] = 0;
     }
   
#if defined(__os2__) || defined(__NT__)
   slrn_os2_convert_path (dirbuf);
#endif
   
   if (-1 == chdir (dirbuf))
     {
	slrn_error ("chdir %s failed", dirbuf);
	return -1;
     }
   
   return 0;
}
