' demo.vba
'
' An introduction script to give a brief view of the script capabilities.
'
' Copyright (C) 1996 NetManage Inc.
' All rights reserved.
'
' This code may be renamed and modified for your own purposes.
' ***************************************************************************************************************

' The following variables are Global ones and therefore they are declared outside the main subroutine

Dim hostName As String
Dim sessionName As String
Dim port As Integer
Dim row As Integer
Dim col As Integer
Dim length As Integer
Dim readScreen As String
Dim writeScreen As String
Dim searchText As String
Dim row1 As Integer
Dim col1 As Integer
Dim tryAgain As Integer
Dim quoteMark
Dim tempDataArr(20) As String	
Dim varEcho As String 			 
Dim valueEcho As String			
Dim endEcho As String			 
Dim msg As String
Dim msg1 As String
Dim msg2 As String
Dim msg3 As String
Dim num As Integer
Dim options(6) As String			
Dim selected(6) As Integer		
Dim userName As String
Dim LF As String
Dim index as Integer

' **********************************************************************************************
' * Subroutine: Main
' * Purpose: 	This subroutine calls the DemoOptionsDialog subroutine and initiates
' *  			the calls to the demo subroutines according to the user's selection.
' **********************************************************************************************

Sub Main
	LF=Chr$(13)
	quoteMark = chr$(34)
	varEcho = "String variable : " & quoteMark
	valueEcho = quoteMark & " has the value of : " & quoteMark
	endEcho = quoteMark

Again1:   
DlgStart
	DlgTitle "Welcome to the Script demo"
   	DlgItemType "In this tutorial demo you will see the power of the VBA script commands."
   	DlgItemType "Before we start, please tell us your name so we will be able to address  "
   	DlgItemType "you in a more personal fashion..."
   	DlgItemAsk "Enter your name : ", userName, 0, 15
   	DlgInquire
   	DlgGetItemValue 0, userName
DlgEnd
	DemoOptionsDialog
	If selected(0) = 1  Then
   		StringOperations
	End If
	If selected(1) = 1 Then
      		MathOperations
	End If
	If selected(2) = 1 Then
      		FileOperations
	End If
	
	If selected(3) = 1 Then
		DialogOperations
   	End If

	
	If selected(4) =1 Then
		MailOperations
	End If
	
	
   	If selected (5) =1 Then
      		TableOperations
   	End If
	
	if selected (6) =1 Then 
		VBAOperations
	End If
	
DlgStart
	DlgTitle "End of demo script"
	DlgItemType "You have reached the end of the intoduction script."
	DlgItemType "We hope that you enjoyed viewing the script capabilities."
	DlgItemType "The demo's script can be opened for viewing and changes"
	DlgItemType "This might be the beginning of your first script ......"
	DlgInquire
DlgEnd

End Sub

' *******************************************************
' *  SubRoutine : 	StringOperations            
' *  Demonstrates the commands :
' *				StrReverse
' *				StrEncypt   
' *				Instr
' *				Len
' *				Mid
' *				StrParse
'  *******************************************************

Sub StringOperations

	Dim concat As String	
	Dim reverse As String
	Dim textVar As String
	Dim pattern As String
	Dim encrypt As String
	Dim searchString As String
	Dim strLen As Integer
	Dim start As Integer
   	Dim numChrs As Integer
	Dim subString As String
	Dim stringToParse As String 
	Dim itemNumber As Integer
   	Dim delimiter As String
	Dim string1 As String
	Dim string2 As String

	string1 = "Net"
	string2 = "Manage"
	msg1 = varEcho & "String1" & valueEcho & String1 & endEcho
	msg2 = varEcho & "String2" & valueEcho & String2 & endEcho

DlgStart
	DlgTitle "String Operations Demo"
	DlgItemType "The script commands support many string operations."
	DlgItemType "We can assign values to a string variable and manipulate it... "
	DlgItemType "For example :"
	DlgItemType msg1
	DlgItemType msg2
	DlgItemType "Now let's join the two together..."
	DlgInquire
DlgEnd
  
	concat = string1 & string2
	msg = varEcho & "concat" & valueEcho & concat  & endEcho
	MsgType msg
	MsgType "How about reversing the result ?"
	StrReverse concat, reverse
	msg = varEcho & "reverse" & valueEcho & reverse & endEcho
	MsgType msg
	MsgType "OOPS!!! Lets reverse it back ..."
   	StrReverse reverse, reverse
   	msg = varEcho & "reverse" & valueEcho & reverse & endEcho
	MsgType msg
   	textVar = reverse
   	
DlgStart
	DlgItemType "You can encrypt a string (usally as an encrypted password)..."
	DlgItemAsk "Enter string to encrypt :", "NetManage", 0, 20
	DlgInquire
	DlgGetItemValue 0, encrypt
DlgEnd

   	StrEncrypt encrypt, encrypt
   	msg = varEcho & "encrypt" & valueEcho & encrypt & endEcho
   	MsgType msg

DlgStart
	DlgItemType "We can search for the first occurence of a string pattern in a text."
	DlgItemType "You can change the Text and the Pattern if you like."
	DlgItemAsk "Text:    ", "NetManage", 0, 20
	DlgItemAsk "Pattern to search :", "Man", 1, 10
	DlgInquire
	DlgGetItemValue 0, textVar
	DlgGetItemValue 1, pattern
DlgEnd

	searchString = InStr(1, textVar, pattern)
   	msg = varEcho & "searchString" & valueEcho & SearchString & endEcho
	MsgType msg

	msg = "Lets check the length of text : "& quoteMark & textVar & quoteMark
   	MsgType msg

  	strLen = Len(textVar)
   	msg = varEcho
   	msg = msg & "strLen"
   	msg = msg & valueEcho
   	msg = msg & StrLen
   	msg = msg & endEcho
   	MsgType msg

DlgStart
	DlgItemType "We can also copy characters from text, starting from a certain position."
	DlgItemType ""
	DlgItemAsk "Text : ", textVar, 0, 20
	DlgItemAsk "Start from position :",2 , 1, 5
	DlgItemAsk "Number to copy :      ",4 ,2, 5
	DlgInquire
	DlgGetItemValue 0, textVar
	DlgGetItemValue 1, start
	DlgGetItemValue 2, numChrs
DlgEnd

	subString = Mid(textVar, start, numChrs)
   	msg = varEcho
   	msg = msg & "subString"
   	msg = msg & valueEcho
   	msg = msg & subString
   	msg = msg & endEcho
   	MsgType msg

	stringToParse = "Jerry,Adam,Jim,Tom,Mike,Johan"
   	delimiter = ","
   	msg = varEcho
	msg = msg & "stringToParse"
   	msg = msg & valueEcho
   	msg = msg & stringToParse
   	msg = msg & endEcho

  	msg1 = varEcho
   	msg1 = msg1 & "delimiter"
   	msg1 = msg1 & valueEcho
	msg1 = msg1 & Delimiter
   	msg1 = msg1 & endEcho

DlgStart
	DlgItemType "We can extract a specific item from text that includes items divided by a delimiter ."
	DlgItemType msg
	DlgItemType msg1
	DlgItemAsk "Enter item number :", 2, 0, 2
	DlgItemSameLine
	DlgItemType "to be extract."
	DlgInquire
	DlgGetItemValue 0, itemNumber
DlgEnd
	
	StrParse stringToParse, delimiter, itemNumber, textVar
   	msg = varEcho
   	msg = msg & "text"
   	msg = msg & valueEcho
   	msg = msg & textVar
   	msg = msg & endEcho
   	MsgType msg

End Sub

' *******************************************************
' *  SubRoutine : 	MathOperations                     
' * Demonstrates the commands :             
' *				Sqr
' *				Rnd
' *				Abs
' *				Tan
' *				Cos
' *				Sin   
' *******************************************************

Sub MathOperations

	Dim numericVar As Integer
	Dim otherVar As Integer
	Dim counter As Integer

	msg1 = "numericVar now has the value of : "
   	numericVar = 23
   	msg1 = msg1 & numericVar
   	msg2 = "otherVar now has the value of : "
   	otherVar = 9
   	msg2 = msg2 & otherVar

DlgStart
	DlgTitle "Numeric Operations"
	DlgItemType "The script commands support many numeric operations."
   	DlgItemType "We can assign values to a numeric variable and manipulate "
   	DlgItemType "those values."
   	DlgItemType "for example ..."
   	DlgItemType msg1
   	DlgItemType msg2
      	DlgItemType "Now let's do the following calculation ..."
   	DlgItemType "(numericVar + 3) * (11 - 7) / 4 - otherVar"
   	DlgInquire
DlgEnd

	numericVar = (numericVar + 3) * (11 - 7) / 4 - otherVar
   	msg1 = "The result is (in an easier to understand format) :  "
   	msg1 = msg1 & numericVar
   	MsgType msg1
	
	msg =  "You can create random numbers using the Rnd command." & LF & LF 
	msg = msg &  "The next example emulates the rolling of two dices twice."
	MsgType msg

	Dim Dice1, Dice2
	Dice1 = CInt(6 * Rnd() + 1)	
	Dice2 = CInt(6 * Rnd() + 1)	
	msg1 = "You rolled a " & Dice1
	msg1 = msg1 & " and a " & Dice2
	msg1 = msg1 & " for a total of "
	msg1 = msg1 & Str(Dice1 + Dice2) & "."
	msgType msg1
	
	Dice1 = CInt(6 * Rnd() + 1)	
	Dice2 = CInt(6 * Rnd() + 1)	
	msg1 = "This time You rolled a " & Dice1
	msg1 = msg1 & " and a " & Dice2
	msg1 = msg1 & " for a total of "
	msg1 = msg1 & Str(Dice1 + Dice2) & "."
	msgType msg1
End Sub

' *******************************************************
' *  SubRoutine :	 FileOperations                          
' *  Demonstrates the commands :              
' *				FileRead      
' *				FileReadNext      
' *				FileWrite
' *				WriteAppend   
' *				CopyFile										
' *				DeleteFile										
' *				DirToFile
' *				RenameFile		
' *				Kill							
' *******************************************************

Sub FileOperations
	Dim appendStr As String	
	Dim lineStr As String
	Dim counter As Integer	

DlgStart
	DlgTitle "File Operations"
	DlgItemType "The script commands support file input/output operations."
   	DlgItemType "The script will now read 7 lines from the file DEMO.VBA and write "
   	DlgItemType "them to DEMO.SAV"
      	DlgItemType "At the end of the file, the string that you will enter below and your name "
   	DlgItemType "will be appended to DEMO.SAV."
   	DlgItemAsk "String to be Appended", "Add this line", 0, 15
   	DlgItemType "We will also copy ,rename and finaly delete the file ."
   	DlgInquire
   	DlgGetItemValue 0, appendStr
DlgEnd

   	FileRead "demo.vba", lineStr,0
   	FileWrite "demo.sav", lineStr
   	
	for i =1 to 5
	FileReadNext lineStr, 0
	FileAppend lineStr
   	Next i

	FileAppend appendStr
   	FileAppend userName
   	SysHide "Timer"
   	MsgType "We shall now activate the NotePad application to see the file."
   	SysWinExec "NotePad demo.sav"
   	SysDelay 1
   	SysShow "Timer"
   	
	MsgType "Copy DEMO.SAV to OLDDEMO.SAV"
   	FileCopy "demo.sav", "olddemo.sav"
   	
	MsgType "Rename demo.sav to NEWDEMO.SAV"
	FileRename "demo.sav", "newdemo.sav"
   	
	MsgType "Activate NotePad application to see the files ."
   	SysWinExec "NotePad olddemo.sav"
   	SysWinExec "NotePad newdemo.sav"
   	
	MsgType "Delete OLDDEMO & NEWDEMO.SAV"
   	Kill "olddemo.sav"
	Kill "newdemo.sav"
   	
	MsgType "You can write all filenames from the current directory to a file "
   	FileDirList "dirfile.txt"
   	
	MsgType "Activate NotePad to see the file "
   	SysWinExec "NotePad dirfile.txt"
   	SysDelay 1
	Kill "dirfile.txt"
End Sub

' *******************************************************
' * SubRoutine :	 DialogOperations                        
' * Demonstrates the commands :              
' *				MsgAsk           
' *				MsgAskQuite      
' *				MsgAskPassword
' *				MsgType
' *				MsgMenu				
' *				MsgRadio			
' *				MsgButton
' *				SysDelay 
' *				TableList
' *				DlgItemType
' *				DlgItemAsk
' *				DlgItemAskQuiet
' *				DlgItemMenu
' *				DlgItemButton
' *				DlgItemRadio
' *				DlgItemTableList
' *				DlgItemSameLine
' *				DlgItemCheckList
' *******************************************************

Sub DialogOperations
Dim result1(8) As Integer
Dim result2(1) As Integer
Dim answer As String
Dim answer1 As String
Dim num As String
Dim num1 As Integer
Dim tmpStr As String
Dim i As Integer
Dim index As Integer
Dim tableDlg As String 

DlgStart
	DlgTitle "Dialog Operations"
	DlgItemType "The script commands support many User Interface operations."
   	DlgItemType "The user interface commands can be grouped in one dialog box,"
   	DlgItemType "or they can be done one at a time."
   	DlgItemType "Here is a sample of them."
   	DlgItemType ""
   	DlgInquire
DlgEnd
	num=""
	MsgAsk "Please enter a numeric value. ", num, 20
   	answer = "you entered ... "
	answer1 = answer
   	answer1 = answer1 & num
   	MsgType answer1
	
	tmpStr=""
	MsgAsk "Please enter a string value. ", tmpStr, 20
   	answer1 = answer
   	answer1 = answer1 & tmpStr
	MsgType answer1

	MsgAskQuiet "Please enter a PASSWORD. ", num, 8
   	answer1 = answer
   	answer1 = answer1 & num
   	MsgType answer1

	tmpStr = ""
	MsgAskPassword "please enter a PASSWORD string value (to be encrypt) :", tmpStr, 20
   	StrEncrypt tmpStr, tmpStr
	answer1 = answer
   	answer1 = answer1 & "(after encrypt)  ..."
   	answer1 = answer1 & tmpStr
   	MsgType answer1

   	SysReDim tempDataArr , 8
   	tempDataArr(0) = "John"
   	tempDataArr(1) = "Jerry"
   	tempDataArr(2) = "Adam"
   	tempDataArr(3) = "Jim"
   	tempDataArr(4) = "Tom"
   	tempDataArr(5) = "Mike"
   	tempDataArr(6) = "Stewert"
   	tempDataArr(7) = "James"
   	tempDataArr(8) = "Richard"
   	MsgMenu "Please choose a name", tmpStr, tempDataArr
   	answer1 = answer
   	answer1 = answer1 & tmpStr
   	MsgType answer1

 	MsgRadio "Please choose a name", tmpStr, tempDataArr
   	answer1 = answer
   	answer1 = answer1 & tmpStr
   	MsgType answer1

   	MsgButton "Please choose a name", tmpStr, tempDataArr
   	answer1 = answer
   	answer1 = answer1 & tmpStr
   	MsgType answer1

   	MsgCheckList "Please choose names ", tempDataArr, result1
	answer1 = answer
	For i = 0 to 8
	if result1(i) = 1 Then 
			answer1 = answer1 & tempDataArr(i)
			answer1 = answer1 & ","
	End if
	Next  i 	
   	MsgType answer1
  	tableDlg = "Table in dialog"
   	SysReDim tempDataArr , 2
   	tempDataArr(0) = "Name"
   	tempDataArr(1) = "Company"
   	tempDataArr(2) = "Phone"
   	TableDefine tableDlg, tempDataArr
   	
   	tempDataArr(0) = "Noam"
   	tempDataArr(1) = "NMI"
   	tempDataArr(2) = "983874747"
   	TableAdd tableDlg, tempDataArr
   	
   	tempDataArr(0) = "Yaron"
   	tempDataArr(1) = "IBM"
   	tempDataArr(2) = "838474"
   	TableAdd tableDlg, tempDataArr
   	
   	tempDataArr(0) = "Yoram"
   	tempDataArr(1) = "INTEL"
   	tempDataArr(2) = "98327476"
   	TableAdd tableDlg, tempDataArr
   	
   	tempDataArr(0) = "Tom"
	tempDataArr(1) = "MicroSoft"
   	tempDataArr(2) = "550123"
   	TableAdd tableDlg, tempDataArr
 
DlgStart
	DlgItemType "Table can be also displayed in a dialog ."
	DlgItemType " Please , select one line from the table by clicking it "
	DlgItemType " and then click OK ."
	DlgItemTableList tableDlg, index, 1
	DlgInquire
	DlgGetItemValue 1, index
DlgEnd

	msg = "Row number "
   	msg = msg & index
   	msg = msg & " "
   	msg = msg & "containes "
   	msg = msg & " "
   
  	TableGet tableDlg, index, tempDataArr
   	
    	msg = msg & tempDataArr(0)
   	msg = msg & " "
   	msg = msg & tempDataArr(1)
 	msg = msg & " "
   	msg = msg & tempDataArr(2)
   	MsgType msg

   	MsgType "The next dialog box will pause for 20 seconds "
   	MsgType "Press the Cancel button to continue sooner..."
   	
	MsgTitle "Delay"
   	SysDelay 20

DlgStart
   	DlgTitle"Dialog Operations"
	DlgItemType "This is a collection of User Interface and text elements inside one Dialog Box"
   	DlgItemAsk "Numeric value :              ", num, 0, 20
   	DlgItemAsk "String value  :", tmpStr, 1, 10
   	DlgItemAskQuiet "PASSWORD numeric value: ", num, 2, 5
   	tempDataArr(0) = "Mary"
   	tempDataArr(1) = "Jane"
   	tempDataArr(2) = "Roger"
   	DlgItemMenu "Menu:", tmpStr, 3, tempDataArr
   	DlgItemCheckList "CheckList:", tempDataArr, result2, 4
   	DlgItemSameLine
   	SysReDim tempDataArr , 2
   	tempDataArr(0) = "Suzanne"
   	tempDataArr(1) = "Mike"
   	tempDataArr(2) = "David"
   	DlgItemButton "Button:", tmpStr, 5, tempDataArr
   	DlgInquire
DlgEnd

End Sub


' *******************************************************
' *  SubRoutine : 	MailOperations                           
' *  Demonstrates the commands :              
' *				MailPrepare 
' *				MailAttach
' *				MailSend		
' ****************************************************** 

Sub MailOperations
	Dim address As String
	Dim subject  As String
	Dim file As String 
	Dim file1 As String
	Dim relation As String
	
MailTryAgain:

DlgStart
	DlgTitle "Mail Operations"
	DlgItemType "The script also support  Mail commands."
	DlgItemType ""
	SysReDim tempDataArr , 2
	tempDataArr(0) = "To"
	tempDataArr(1) = "Cc"
	tempDataArr(2) = "Bcc"
	DlgItemRadio "Relation  :", relation, 0, tempDataArr
	DlgItemAsk "Address :        ", address, 1, 25
	DlgItemAsk "Subject :          ", subject, 2, 25
	DlgItemAsk "Mail body file:", file, 3, 25
	DlgInquire
	DlgGetItemValue 0, relation
	DlgGetItemValue 1, address
	DlgGetItemValue 2, subject
	DlgGetItemValue 3, file
DlgEnd
	
	MailPrepare relation, address, subject, file
	if NM_ResultCode <> 0 Then 
			MsgType NM_ResultText
			MsgConfirm "Do you want to try again ?",num
			If num = 1  Then
					 Goto MailTryAgain
			Else 
					Exit Sub
			End If
	End If 
	msgConfirm "Do you want to send this mail to other names ?", num
	If num = 1 Then
		Address = ""
		DlgStart
			DlgItemRadio "Relation  :", relation, 0, tempDataArr
			DlgItemAsk "Address :", address, 1, 25
			DlgInquire
			DlgGetItemValue 0, relation
			DlgGetItemValue 1, Address
		DlgEnd
		MailAddress relation, address
	End If
	msgConfirm "Do you want to attach a file ?", num
	If num =1 Then
		msgAsk "File to be attached :", file1, 25
		MailAttach file1
	End If
	MailSend
End Sub




	
		


'**********************************************************
' *  SubRoutine : TableOperations                          
' *  Demonstrats the commands :              
' *			Table
' *			TableAdd       
' *			TableErase
' *			TableGet
' *			TableList
'***********************************************************

Sub TableOperations
	Dim table As String
	Dim confirm As Integer
	Dim index As Integer
	Dim column(3) As String
	
DlgStart
	DlgTitle "Table Operations"
	DlgItemType "You can define a table with N columns."
	DlgItemType "You can add , erase and get rows from the table. "
	DlgItemType "You can display it (within a dialog or separately.)"
	DlgItemType "Each Column can be sorted by doubleclicking  on the top of the column."
	DlgItemType "You can also change the order of columns ."
	DlgItemType "Doubleclicking on a certain row will return the index of the row."
	DlgItemType "In this example, we will define a table with 3 columns."
	DlgItemAsk "Table : ", "Table", 0, 10
	DlgItemAsk "First column name:      ", "Name       ", 1, 10
	DlgItemAsk "Second column name:", "Company", 2, 10
	DlgItemAsk "Third column name:     ", "Phone      ", 3, 10
	DlgInquire
	DlgGetItemValue 0, table
	DlgGetItemValue 1, msg1	
	DlgGetItemValue 2, msg2	
	DlgGetItemValue 3, msg3	
DlgEnd
	
column(0)=msg1
column(1)=msg2
column(2)=msg3

	TableDefine table, column
	SysReDim tempDataArr, 2
DlgStart
	DlgItemType "After we define the table ,we can add a line to it , by using TableAdd command."
	DlgItemAsk column(0), "Zvi Alon", 0, 20
	DlgItemAsk column(1), "NetManage", 1, 20
	DlgItemAsk column(2), "9737171", 2, 20
	DlgInquire
	DlgGetItemValue 0, msg1
	DlgGetItemValue 1, msg2
	DlgGetItemValue 2, msg3
DlgEnd

tempDataArr(0) = msg1
tempDataArr(1) = msg2
tempDataArr(2) = msg3
	TableAdd table,TempDataArr

	tempDataArr(0) = "Yoram Nissenboim"
	tempDataArr(1) = "NMI"
	tempDataArr(2) = "550123"
	TableAdd table, tempDataArr

	tempDataArr(0) = "Tom Smith "
	tempDataArr(1) = "IBM"
	tempDataArr(2) = "5435234"
	TableAdd table, tempDataArr

	MsgConfirm "Add more ?", confirm
	If confirm =1 Then
		
			DlgStart
				DlgItemAsk column(0), "", 0, 10
				DlgItemAsk column(1), "", 1, 10
				DlgItemAsk column(2), "", 2, 10
				DlgInquire
				DlgGetItemValue 0, msg1
				DlgGetItemValue 1, msg2
				DlgGetItemValue 2, msg3
			DlgEnd
	tempDataArr(0) = msg1
	tempDataArr(1) = msg2
	tempDataArr(2) = msg3

	TableAdd table, tempDataArr
	End If

DlgStart
		DlgItemType "Now, it's time to display the table. You can double-click a row , and the index of the row "
		DlgItemType "is returned as a result."
		DlgInquire
DlgEnd

		TableList table, index

DlgStart
	DlgItemType "By using TableGet command , you can get all the "
	DlgItemType "values in a line according to its specified index."
	DlgInquire
DlgEnd

	TableGet table, index, tempDataArr
	msg = "Line number "
	msg = msg & Index
	msg = msg & " containes  "
	msg = msg & tempDataArr(0)
	msg = msg & " , "
	msg = msg &tempDataArr(1)
	msg = msg & " , "
	msg = msg &tempDataArr(2)
	MsgType msg
	MsgType "You can also delete the last line that was added."
	TableDelete table
	TableList table, index
	MsgType "And, of course,  you can erase all lines from the table."
	TableErase table
	TableList table, index
End Sub

' ***********************************************
' * Subroutine : VBAOperations Demo
' * Demonstrates the commands:
' *				Time
' *				Format
' *				UpperBound
' *				LowerBound
' *				Chdir
' *				Mkdir
' *				RmDir
' *				Shell
' *				SendKeys
' *				Begin Dialog
' *				PushButton
' *				ListBox
' *				DropListBox
' *				ListBox
' *				OKButton
' *				CancelButton
' *				ComboBox
' *				Text
' *				TextBox
' ************************************************


Sub VBAOperations

Dim dateVar As String
Dim timeVar As String

DlgStart 
	DlgTitle "VBA Operations"
	DlgItemType "The Visual Basic for Appliactions language adds many new commands to the script language."
	DlgItemType "In this part we will explore these commands."
	DlgItemType "We will start with the time handling commands."
	DlgItemType "These commands allow you to know the year, month, day and time"
	DlgInquire
DlgEnd
	
	timeVar = Format(Time,"Short time")
	dateVar= Format(date,"Short date")
	MsgTitle "Short Format"
	msg = "The time & date can be shown in a Short format : " & LF & LF 
	msg = msg & "The time is : " & timeVar & LF & LF
	msg = msg & "The date is : " & dateVar
	MsgType msg 
	
	timeVar = Format(Time, "Long time")
	dateVar = Format(Date,  "Long date")
	MsgTitle "Long Format"
	msg = "The time & date can be also shown in a Long format : " & LF & LF 
	msg = msg & "The time is : " & timeVar & LF & LF
	msg = msg & "The date is : " & dateVar
	MsgType msg

DlgStart
	DlgTitle "SendKeys Command"
	DlgItemType "You can activate Windows applications and send keys to them."
	DlgItemType "In the next example we will activate the Notepad application in maximized mode , send the word"		
	DlgItemType quoteMark & "Hello World" & quoteMark & " and save the document under"
	DlgItemType qouteMark & "demotext.txt" & quoteMark & ". Then we will close it."
	DlgInquire
DlgEnd 
	
	kill "demotext.txt"
	shell ("notepad.exe")
	SysHide "Timer"
	SendKeys "Hello World"
	SysDelay 1
	SendKeys "%F,S"
	SendKeys "demotext.txt"
	SysDelay 1
	SendKeys "{ENTER}"
	SysDelay 1
	SendKeys "%F,X"
	SysShow "Timer"
	kill "demotext.txt"

DlgStart
	DlgTitle "Arrays in VBA"
	DlgItemType "Working with Arrays is much easier with VBA."
	DlgItemType "You can create an Array of Integers, Strings or Variants."
	DlgItemType "You can Redim the Array as many time as you want during the execution of the script."
	DlgItemType "The UpperBound or LowerBound of the array can be changed too."
	DlgItemType"Finally - if you want to earse all elemants from the array use the Erase command."
	DlgInquire
DlgEnd

DlgStart
	DlgTitle "Dos commands"
	DlgItemType "There are many DOS commands that you can execute directly from the script"
	DlgItemType "For Example:"
	DlgItemType "Current default directory is: " & CurDir
	DlgItemAsk "Create New Directory by the name: ","Test", 1, 10
	DlgInquire
	DlgGetItemValue 1,msg1
DlgEnd

	ChDir "\"
	MkDir msg1
	FileDirList "temp.txt"
	MsgType "We will now open Notepad with a file created by the FileDirList command, so you can see that the directory was created" 
	shell("notepad temp.txt")
	MsgType"Now we will remove the directory we just created"
	RmDir msg1
	 
DlgStart
	DlgTitle "User Defined Dialogs"
	DlgItemType "The VBA language allows you to create sophisticated user defined Dialogs."
	DlgItemType "These Dialogs can be edited and created using the Dialog Editor found in the Tools menu" 
	DlgItemType "The 4 next Dialogs will demonstrate some of the possible fields of a VBA Dialog window."
 	DlgItemType "All of them were created using the Dialog Editor."
	DlgInquire
DlgEnd

Dim MyList(7) As String 
MyList(0) = "Array Line 1" 
MyList(1) = "Array Line 2" 
MyList(2) = "Array Line 3" 
MyList(3) = "Array Line 4" 
MyList(4) = "Array Line 5" 
MyList(5) = "Array Line 6"
MyList(6) = "Array Line 7" 
MyList(7) = "Array Line 8" 

Begin Dialog EXAMPLE1 89,44, 200, 199, "Radio Buttons , Check Boxes & Group Boxes"
	  OptionGroup .GROUP_1
	  OptionButton 16,96,60,8, "RadioButton 1"
	  OptionButton 16,116,64,8, "RadioButton 2"
	  GroupBox 8,80,76,56, "GroupBox"
	  CheckBox 112,92,52,12, "CheckBox 1", .CheckBox_1
 	 CheckBox 112,116,56,12, "CheckBox 2", .CheckBox_2
	  Text 4,16,188,28, "The two radio buttons are associated together to form a  group - therefore you can only select one of them."
	  Text 4,48,188,24, "The Check Boxes are not tied together so you can select the first one, second one or both."
	  OKButton 60,172,68,16
End Dialog

Dim ex1 As EXAMPLE1
Dialog ex1

Begin Dialog EXAMPLE2 82,55, 200, 199, "User Defined Push Buttons"
	  Text 12,12,0,0, "You c"
	  Text 12,8,168,32, "You Can create as many Push-Buttons as you like and give each of the user's choice a sepearete action later in your script."
	  Text 16,60,156,12, "Choose one of these buttons:"
	PushButton 16,88,68,16, "Push ME!", .Push1
  	PushButton 100,88,72,16, "NO - Push ME!", .Push2
  	PushButton 100,128,72,16, "Don't think about it !", .Push4
  	PushButton 16,168,68,16, "Push the right one!", .Push5
  	PushButton 100,168,72,16, "Push the left one!", .Push6
  	PushButton 16,128,68,16, "Don't Push Me!", .Push3
End Dialog

Dim ex2 As EXAMPLE2
Button = Dialog (ex2)

if Button = 1 then msg1 =" 'Push Me!' "
if button = 2 then msg1 = " 'No- Push ME!' "
if button = 3 then msg1 = " 'Don't think about it!' "
if button = 4 then msg1 = " 'Push the right one!' "
if button = 5 then msg1 = " 'Push the left one!' "
if button = 6 then msg1 = " 'Don't Push Me !' "

MsgBox "You pushed the" & msg1 & "button"

Begin Dialog EXAMPLE3 46,71, 288, 199, "Combo Boxes, Drop-Down List-Boxes & List Boxes."
  	Text 8,12,268,32, "In order to create a Drop-down list box , a Combo-box or a List box you first have to define an array that will hold the items you want to include in the list."
	ListBox 8,56,68,68, MyList(), .ListBox_1
	ComboBox 100,52,72,72, MyList(), .ComboBox_1
  	DropListBox 196,52,76,72, MyList(), .DropDown_1
  	OKButton 120,160,36,24
End Dialog

Dim ex3 As EXAMPLE3
Dialog ex3

Begin Dialog EXAMPLE4 57,62, 261, 189, "Edit Box and Cancel button."
  	TextBox 40,104,184,12, .EditBox_1
  	Text 4,4,244,28, "An edit box is useful if you want the user to enter text freely rather than choosing from a given list."
	Text 4,44,244,24, "We also included a Cancel button here to demonstrate the possiblity of allowing the user to exit the script at whatever point he is at."
  	OKButton 24,164,60,12
  	CancelButton 172,164,60,12
  	Text 40,84,84,12, "Please enter your name:"
End Dialog


Dim ex4 As EXAMPLE4
Dialog ex4

End Sub 


Sub DemoOptionsDialog 
	options(0) = "String Operations Demo"
	options(1) = "Math. Operations"
   	options(2) = "Files I/O Operations Demo"
   	options(3) = "User Interface Demo"
   	
   	options(4) = "Mail Operation Demo"
   	
	options(5) = "Table Operation Demo"
   	options(6) = "VBA Operations Demo"
	for i = 0 to 6 
	selected(i) = 1
	next i
	
DlgStart
   	OptionsDlg_s1 = "Hello " & userName & " !!!"
   	DlgItemType OptionsDlg_s1
   	DlgItemType "Please check the demo options that you would like to see. "
   	DlgItemType ""
   	DlgItemCheckList "  ", options, selected, 0
   	DlgInquire
   	DlgGetItemValue 0, selected
DlgEnd

End Sub








