{****************************************************************************

                   Copyright (c) 1995,96 by Florian Klmpfl

 ****************************************************************************}

unit systems;

  interface

    type
       { Zielbetriebssysteme }
       ttarget = (target_DOS,target_OS2,target_LINUX,target_WIN32);

       ttargetinfo = record
          target : ttarget;
          target_name : string[20];
          short_name : string[8];
          unit_env : string[20];
          system_unit : string[8];
          objext : string[4];
       end;

    var
       target_info : ttargetinfo;

    function set_string_target(const s : string) : boolean;

  implementation

    const
       target_infos : array[target_DOS..target_WIN32] of ttargetinfo = (
          (
            target : target_DOS;
            target_name : 'DOS-Extender';
            short_name : 'DOS';
            unit_env : 'DOSUNITS';
            system_unit : 'SYSTEM';
            objext : '.o'
          ),
          (
            target : target_OS2;
            target_name : 'OS/2 (32 Bit)';
            short_name : 'OS2';
            unit_env : 'OS2UNITS';
            system_unit : 'SYSOS2';
            objext : '.obj'
          ),
          (
            target : target_LINUX;
            target_name : 'Linux';
            short_name : 'LINUX';
            unit_env : 'LINUXUNITS';
            system_unit : 'SYSLINUX';
            objext : '.o'
          ),
          (
            target : target_WIN32;
            target_name : 'Win32';
            short_name : 'WIN32';
            unit_env : 'WIN32UNITS';
            system_unit : 'SYSWIN32';
            objext : '.o'
          )
       );

    procedure set_target(t : ttarget);

      begin
         target_info:=target_infos[t];
      end;

    function set_string_target(const s : string) : boolean;

      var
         t : ttarget;

      begin
         set_string_target:=false;
         for t:=target_DOS to target_WIN32 do
           if target_infos[t].short_name=s then
             begin
                set_string_target:=true;
                set_target(t);
             end;
      end;

    begin
{$ifdef tp}
       set_target(target_DOS);
{$else}
{$ifdef DOS}
       set_target(target_DOS);
{$endif}
{$ifdef OS2}
       set_target(target_OS2);
{$endif}
{$ifdef LINUX}
       set_target(target_LINUX);
{$endif}
{$ifdef WIN32}
       set_target(target_WIN32);
{$endif}
{$endif}
    end.



