/*Copyright (C) 1992, 1994 by Thomas Glen Smith.	All Rights Reserved.*/
/* vector APL2 V1.0.0 **************************************************
* Called by apleddl.                                                   *
* Converts a string of numeric constants to an APL vector.  E.g. for   *
* for "1 2 3abc" **sp is changed to point to the a.                    *
***********************************************************************/
#define INCLUDES APLCB+APLMEM
#include "includes.h"
#include "flist.h"
Aplcb vector(sp,spend,single)
char *sp[];	/* Pointer to pointer to string being parsed.		*/
char *spend;	/* Pointer to after end of string.					*/
int single;	/* =1 if only first input value is desired, else 0.	*/
{
	Cplxin; Fifo; Pop; Vectors;
	extern int aplerr;
	Flist fhdr,fcur,fnxt;
	int datacnt,datatyp,i,*ip,j,k,m,n;
	char *s,*t,*u;
	double f[2],*fp;
	Aplcb out;

	if (aplerr) return(NULL);
	s = sp[0]; /* point to input string */
	datacnt = 0;
	m = n = 0; /* will indicate data type */
	t = s; /* t==addr(input string) */
	fcur = NULL; /* start of chain */
	while(0 < (i = cplxin(t, f, &j, &k, spend))) {
		fcur = fifo(&fhdr,fcur,malloc(sizeof(struct flist)));
		fcur->fel[0] = f[0];
		fcur->fel[1] = f[1];
		fcur->iel = j;
		fcur->swel = k;
		m += k;
		if (k && (f[1] != 0e0)) n++;
		datacnt++;
		t += i;
		if (single) break; /* Stop after first if single=1 */
	}
	sp[0] = t; /* where we stopped in input */
	if	   (n) datatyp = APLCPLX;
	else if (m) datatyp = APLNUMB;
	else		  datatyp = APLINT;
     return(vectors(datacnt,datatyp,&fhdr));
}
