/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* value - APL2 V1.0.0 *************************************************
* Called by assign and newderiv.                                       *
* Returns the double floating point value of the first or only element *
* pointed to by the APLCB passed as argument.                          *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
double value(rite)
Aplcb rite;
{
	Endoper; Errinit; Real;
	extern int aplerr;
	double ret;

	if (errinit())
		return(-0.0);
	if (!(rite->aplflags & APLNUMB)) {
		rite=real(rite);
		if (aplerr)
			return(-0.0);
	}
	if (!rite->aplcount) {
		aplerr=23; /* empty variable */
		ret=-0.0;
	}
	else
		ret=*rite->aplptr.apldata;
	endoper(rite);
	return(ret);
}
