/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* takeit APL2 V1.0.0 **************************************************
* Takeit is called from both take and drop after initial processing	 *
* and error checking has been done.  Takeit does the take operation.	 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
#include "takeincl.h"
Aplcb takeit(left,rite)
Aplcb left,rite;
{
	Dtacopy; Endoper; Errstop; Takefill; Takepset; Takesub; Temp;
	Aplcb out;
	struct takeparm p;
	int tempsave;
	char *cp;

	tempsave = rite->aplflags & APLTEMP;
	if (tempsave)
		rite->aplflags -= APLTEMP; /* temporarily permanent */
	p.pilvl = p.polvl = NULL; /* takepset will store here */
	out = takepset(left,rite,&p);
	if (out != NULL && out->aplcount)
		if (out->aplrank)
			takesub(0,&p);
		else {
			cp = (rite->aplcount) ? rite->aplptr.aplchar : takefill(&p);
			dtacopy(out->aplptr.aplchar,cp,1,1,p.ptype);
		}
	if (p.pilvl != NULL)
		endoper(temp(p.pilvl));
	if (p.polvl != NULL)
		endoper(temp(p.polvl));
	if (p.aplfill != NULL)
		endoper(temp(p.aplfill));
	rite->aplflags += tempsave; /* restore temporary flag, maybe */
	return(errstop(0,temp(left),rite,out));
}
