/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* take APL2 V1.0.0 ****************************************************
* Called by first and take2.                                           *
* If a is an APLCB for a positive scalar integer and b is an APLCB for *
* a vector, then take(a,b) is a vector consisting of the first a       *
* elements of b, padded to the right with zeros if needed, e.g.        *
* take(iscalar(3),indxsub(2)) produces 1 2 0.  If a is negative,       *
* elements are taken from the right end of b, e.g take(iscalar(-2),    *
* indxsub(4)) produces 3 4.  If b is any array, take(a,b) is valid     *
* only if a has one element for each axis of b, with the Ith element   *
* determining how many to take along the Ith axis of b.                *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb take(left,rite)
Aplcb left,rite;
{
	Errstop; Takeck; Takeit; Vectin;

	if (OK != takeck(&left,&rite))
		return(errstop(0,left,rite,NULL));
	return(takeit(left,rite));
}
