/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* slashtrb APL2 V1.0.0 ************************************************
* Called from slashtra to handle compress/expand operator transform.   *
***********************************************************************/
#define INCLUDES APLTOKEN+APLTOKCD+APLCHDEF+FUNSTRUC+APLDERIV+APLCB\
+TREE+FUNCODES
#include "includes.h"
void slashtrb(tok,funtok,axistok,dp)
Apltoken tok; /* token for slash, slash bar, slope, slope bar */
Apltoken funtok; /* token left of compress, if any */
Apltoken axistok; /* axis associated with funtok, if any */
Aplderiv dp; /* derived function structure */
{
     Aplcomex; Compress; Expand; Lifo;
     extern int aplerr;
     extern Treelist treehdr;

     dp->deriv_func = aplcomex;
     switch(((Codes *)(dp->deriv_op))->funky_code) {
          case SLASH:
          case SLASH_BAR:
               dp->deriv_left.func.wax = compress;
               break;
          case SLOPE:
          case SLOPE_BAR:
               dp->deriv_left.func.wax = expand;
               break;
          default:
               aplerr = 999; /* internal error */
               exit(999);
     } /* end switch */
     tok->token_code = DERIVED_FUNCTION;
     tok->token_ptr.token_function = dp;
     if (funtok) /* put back on input stack */
          funtok = lifo(&(treehdr->avltokhd),funtok);
     if (axistok) /* put back on input stack */
          axistok = lifo(&(treehdr->avltokhd),axistok);
}
