/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* rollp APL2 V1.0.0 ***************************************************
* Returns a random selection from the whole numbers beginning with     *
* indxorg and ending with indxorg+n-1.  This version works with        *
* the zortech C++ compiler.                                            *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
void rollp(narg,ret)
double *narg,*ret;
{
	extern int aplerr;
	extern int indxorg;
	double n,r;
#if APL_DOS
	double divisor=32767.0;
#else
	double divisor=RAND_MAX;
#endif

	n = *narg;
	if (n == 0.0)
     	*ret = 0.0;
	else if (n < 0.0) {
		aplerr = 37;
		*ret = 0.0;
	}
     else {
		r = indxorg;
		*ret = r + ((double) rand())/divisor * (double) n;
     }
}
