/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* redscan APL2 V1.0.0 *************************************************
* Called by reducef and scanfrnt to complete reduce/scan processing.	 *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLDERIV+APLCB+FUNCODES
#include "includes.h"
Aplcb redscan(id,dp,rite,axis,crs,nrs)
int id;	   /* 1=reduce, 0=scan */
Aplderiv dp; /* function describing derived function */
Aplcb rite;  /* argument */
int axis;
Aplcb (*crs)(int (*oper)(char,char), int *, Aplcb, int);
Aplcb (*nrs)(Aplderiv, Aplcb, int);
{
	Aplnest; Errstop; Execdyal; Execdyam; Pickdyad; Preduces;
	extern int aplerr;
	Aplcb out=NULL;
	void *ep;
	int type;
	Scalar_dyadics *sp;
	Eqne *en;

	type = rite->aplflags & (APLMASK + APLAPL);
	if (type != APLAPL && (dp->deriv_left.func.flr == execdyal ||
		dp->deriv_left.func.flr == execdyam)) {
		if (type == APLCHAR) {
			sp = pickdyad(en = dp->deriv_left.fun);
			if (sp == NULL) aplerr = 72; /* bad scalar */
			if (en->rel.codes.funky_flags == EQNE &&
				NULL != (ep = en->ch))
				return((*crs)(ep,&(sp->identities.iid),rite,axis));
			return(errstop(75,NULL,rite,NULL));
          }
		return(preduces(id,dp,rite,axis)); /* f/ is a prim. scal. */
	}
	/* Get to here if f in f/ is not a primitive scalar. */
	if (type != APLAPL)
     	rite = aplnest(rite); /* convert to nested */
	return((*nrs)(dp,rite,axis)); /* nested reduce(call nreduce) */
}
