/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* quadoutc APL2 V1.0.0 ************************************************
* Quadoutc is common to both quadout and qquadout.  The APL2 version   *
* differs only in that it calls formdft instead of form.              *
***********************************************************************/
#define INCLUDES APLCB+STDIO
#include "includes.h"
Aplcb quadoutc(rite,nl)
Aplcb rite; /* apl variable to be printed */
int nl; /* 1 if newline is to follow output */
{
     Aplmsg; Aplnewl; Errinit; Formdft; Perm;
     extern int aplcurs,aplerr;
     int tempsave;
     char *cp;
	Aplcb out=NULL;

     if (errinit()) {
          printf("%s",aplmsg(aplerr));
          aplnewl(); /* Define new output line. */
          return(rite);
     }
     tempsave = rite->aplflags & APLTEMP;
     out = formdft(perm(rite));
     rite->aplflags += tempsave; /* restore flag */
     if (errinit()) {
          printf("%s",aplmsg(aplerr));
          aplnewl(); /* Define new output line. */
          return(rite);
     }
     if (0==out->aplcount) { /* empty? */
          printf(".");
          aplcurs++; /* Bump count of output chracters in line. */
     }
     else { /* recursively call quadrec to print data */
          cp = out->aplptr.aplchar;
          quadrec(out->aplrank,out->apldim,&cp,nl);
     }
     if (nl)
          aplnewl(); /* Define new output line. */
     endoper(out);
     return(rite);
}
