/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* popnesc APL2 V1.0.0 *************************************************
* Popnesc is called from popnest when the result is to be a simple     *
* array of data type APLCPLX.                                          *
***********************************************************************/
#define INCLUDES APLCB+APLTOKEN
#include "includes.h"
void popnesc(hdr,out)
void *hdr; /* Operand stack */
Aplcb out; /* new output operand */
{
     Endoper; Execgetp; Pop; Value;
     extern int aplerr;
     Aplcb wrk;
     int datacnt;
     double *op;


     op = out->aplptr.apldata;
     datacnt = out->aplcount;
     while( datacnt-- && aplerr == 0) {
          wrk = execgetp(pop(hdr)); /* pop token, get aplcb ptr */
          switch (wrk->aplflags & APLMASK) {
          	case APLINT:
               	*op++ = *(wrk->aplptr.aplint);
                    *op++ = 0e0;
                    break;
          	case APLNUMB:
               	*op++ = *(wrk->aplptr.apldata);
                    *op++ = 0e0;
                    break;
          	case APLCPLX:
               	*op++ = *(wrk->aplptr.apldata);
               	*op++ = *(wrk->aplptr.apldata + 1);
                    break;
               default:
               	aplerr = 123; /* item out of place */
                    break;
          } /* end switch */
          endoper(wrk);
     }
}
