/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* places APL2 V1.0.0 **************************************************
* Called by precisn.  Returns the allowable number of places to the    *
* right of the decimal point.  If there are any digits left of the     *
* decimal point, the sum of the digits left and right of the decimal   *
* point cannot exceed 8.  Otherwise, the maximum places to the right   *
* of the decimal point cannot exceed 9.                                *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
int places(val,digs,maxw)
double val;	/* Value to be evaluated. */
int digs;	/* Digits left of d.p. in val. */
int maxw;	/* Maximum width for digits left and right of decimal */
		/* point and decimal point, if needed. */
{
	extern double fuzz;
	double fraction;
	long lw;
	int iw,kw;

	if (digs >= maxw) return(0); /* No places right of d.p. */
	fraction = (val < 0.0) ? -val : val; /* absolute value */
	fraction -= floor(fraction); /* Fraction is non-integer part. */
		/* For e.g. val=1.1415926733, fraction=.1415926733. */
		/* For e.g. val=1.0000000345, fraction=.0000000343 */
	if ((1.0 - fraction) < fuzz) return(0); /* Smaller than fuzz. */
	kw = maxw - digs;
	if (digs) kw--; /* Maximum allowable places right of d.p. */
	for (iw = kw; iw > 0; iw--)
		fraction *= 10.0;
		/* kw digits for kw possible places. Say kw==9: */
		/* Then if val=1.1415926733, fraction=141592673.3. */
		/* Then if val=1.0000000343, fraction=34.3. */
	lw = .1 + fraction; /* lw==123000000 for .123. */
		/* For e.g. val=1.1415926733, lw=141592673. */
		/* For e.g. val=1.0000000343, lw=34. */
		/* lw will contain up to 9 significant digits, 1 for */
		/* each significant place to right of d.p. */
	if (lw == 0l) return(0); /* Report it as an integer. */
	while(lw % 10l == 0) {	/* This loop wil change lw from e.g. */
		lw /= 10l;	/* 123000000 to 123, reducing kw a */
		kw--;		/* corresponding amount (6). */
	}
	return(kw);
}
