/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* outrprdx APL2 V1.0.0 ************************************************
* Called by execjotd. This is outer product for the special case when  *
* one of the two operands is character and the other isn't.  The only  *
* operators will be equal and not-equal.                               *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb outrprdx(ival,left,rite)
int ival;
Aplcb left,rite;
{
	Errstop; Getcb; Intcopy;
	Aplcb out;
	int datacnt,datatyp,*ip,rank;

	datacnt = left->aplcount * rite->aplcount;
	datatyp = APLINT;
	rank = left->aplrank + rite->aplrank;
	out = getcb(NULL, datacnt, datatyp+APLTEMP, rank, NULL);
	if (out != NULL) {
		if (rank > 1) { /* set dimensions */
			ip = intcopy(out->apldim, left->apldim, left->aplrank, 1);
			ip = intcopy(ip, rite->apldim, rite->aplrank, 1);
		}
		ip = out->aplptr.aplint;
		while (datacnt--)
			*ip++ = ival;
	}
	return(errstop(0,left,rite,out));
}
