/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* newderiv APL2 V1.0.0 ************************************************
* Called by dottran, eachtran, and slashtra.                           *
* Allocates and initializes a new aplderiv structure.                  *
***********************************************************************/
#define INCLUDES APLMEM+FUNSTRUC+APLDERIV
#include "includes.h"
Aplderiv newderiv(Aplcb axcb, Aplcb lcb, Aplcb rcb)
{
	Aplcopy; Endoper; Errstop; Value;
     Aplderiv dp;

     dp = malloc(sizeof (struct aplderiv));
     if (dp == NULL) {
          endoper(errstop(0,lcb,rcb,axcb)); /* out of storage */
          return(NULL);
     }
     dp->deriv_flags = 0;
     if (dp->deriv_axis_cb = axcb) {
     	if (axcb->aplflags & APLTEMP)
          	axcb->aplflags -= APLTEMP; /* mark permanent */
          else axcb = dp->deriv_axis_cb = aplcopy(axcb);
          dp->deriv_axis_dbl = value(axcb);
          dp->deriv_axis_int = dp->deriv_axis_dbl;
     }
     else {
	     dp->deriv_axis_int = -1;
	     dp->deriv_axis_dbl = -1.0;
     }
     if (dp->deriv_left.cb = lcb)
     	if (lcb->aplflags & APLTEMP)
          	lcb->aplflags -= APLTEMP; /* mark permanent */
          else dp->deriv_left.cb = aplcopy(lcb); /* copy permanent */
     if (dp->deriv_rite.cb = rcb)
     	if (rcb->aplflags & APLTEMP)
          	rcb->aplflags -= APLTEMP; /* mark permanent */
          else dp->deriv_rite.cb = aplcopy(rcb); /* copy permanent */
     dp->deriv_op = NULL;
     dp->deriv_func = NULL;
     dp->deriv_left.funcode  = dp->deriv_rite.funcode  = 0;
     dp->deriv_left.fun      = dp->deriv_rite.fun      = NULL;
     dp->deriv_left.sdp      = dp->deriv_rite.sdp      = NULL;
     dp->deriv_left.type     = dp->deriv_rite.type     = NO_TYPE;
     dp->deriv_left.func.dix = dp->deriv_rite.func.dix = NULL;
     return(dp);
}
