/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* multset APL2 V1.0.0 *************************************************
* Called to set a multiplier array for a given set of dimensions.      *
***********************************************************************/
#include "includes.h"
void multset(
int k,   /* number of dimensions and multipliers */
int *jp, /* dimension array */
int *kp) /* multiplier array to be set */
{
     if (k--) {
          *(kp + k) = 1; /* first multiplier */
          while(k--) *(kp + k) =  *(kp + k + 1) * *(jp + k + 1);
     }
}
