/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* mdivarg APL2 V1.0.0 *************************************************
* Called by mdivide and matinv, checks the validity of arg as an       *
* argument for matrix division, and determines the number of rows and  *
* columns.                                                             *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int mdivarg(arg,prows,pcols)
Aplcb arg;
int *prows,*pcols;
{
	extern int aplerr;
	int i;

	i=OK; /* default return code */
	switch(arg->aplrank) {
		case 0: /* scalar */
			/* treat as a 1-by-1 matrix */
			*prows=*pcols=1;
			break;
		case 1: /* vector */
			/* treat as a single column matrix */
			*prows=*(arg->apldim);
			*pcols=1;
			break;
		case 2: /* matrix */
			*prows=*(arg->apldim);
			*pcols=*(1+arg->apldim);
			break;
		default: /* rank error */
			aplerr=5; /* rank m/b <= 2 */
			i=ERR;
			break;
	}
	return(i); 
}
