/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* Match APL2 V1.0.0 ***************************************************
* Yields 1 if arguments are same in structure and data, 0 otherwise.	 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb match(left,rite)
Aplcb left,rite;
{
	Errinit; Errstop; Iscalar; Matchok; Matchsub;
     extern int aplerr;
	int datatyp,i,ret=0;
     char *lp, *rp;
 
	if (errinit()) return(errstop(0,left,rite,NULL));
	for(;;) {
          if (	left->aplrank != rite->aplrank ||
          	left->aplcount != rite->aplcount) break;
          datatyp = left->aplflags & (APLMASK + APLAPL);
          if (0 == (i = left->aplcount) &&
          	datatyp != (rite->aplflags & (APLMASK + APLAPL))) break;
		if (!matchok(&left, &rite, APLMASK + APLAPL)) {
			aplerr = 0; /* reset error code set by matchok */
			break;
		}
          lp = left->aplptr.aplchar;
          rp = rite->aplptr.aplchar;
          ret = 1;
          while(i-- && ret && aplerr == 0) {
          	ret = matchsub(datatyp,lp,rp);
          	lp += left->aplsize;
               rp += rite->aplsize;
          } /* end while */
          break;
	}
	return(errstop(0,left,rite,iscalar(ret)));
}
