/*Copyright (C) 1992, 1996 by Thomas Glen Smith.	All Rights Reserved.*/
/* litvect APL2 V1.0.0 *************************************************
* The argument is a character string containing zero or more floating  *
* constants.  If all are valid, they will be converted to internal     *
* double floating point, and an aplcb will be initialized to point to  *
* this vector.  A pointer to the aplcb will be returned.  If not all   *
* valid, NULL is returned, with aplerr set to 12.                      *
***********************************************************************/
#define INCLUDES APLCB+STRING
#include "includes.h"
Aplcb litvect(sp)
char *sp;	/* Pointer to string being parsed.		*/
{
	Errinit; Errstop; Vector;
	Aplcb out;
	char *c, *d, *spend;
	int splen;

	if (errinit()) return(NULL);
	spend = sp + (splen = strlen(c = d = sp));
	out = vector(&c, spend, 0);
	if ((c - d) != splen)
		return(errstop(12,NULL,NULL,out)); /* Bad constant. */
	return(errstop(0,NULL,NULL,out));
}
