/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* integer APL2 V1.0.0 *************************************************
* Returns copy of the apl variable received as input, converting to	 *
* integer if floating or complex, and setting error if character.  To  *
* get integer, the real number is truncated down, e.g. 1.5 becomes 1,  *
* and -1.5 becomes -2.										 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb integer(rite)
Aplcb rite;
{
	Errinit; Errstop; Getcb; Intcopy; Integes;
	extern int aplerr;
	int *op;
	Aplcb out;

	for (;;) {
		if (errinit()) break;
		out=getcb(NULL,rite->aplcount,APLTEMP+APLINT,rite->aplrank,NULL);
		if (aplerr) break;
		if (rite->aplrank > 1)
			op = intcopy(out->apldim,rite->apldim,rite->aplrank,1);
		if (out->aplcount == 0) break; /* All done. */
		return(integes(rite,out));
		break; /* final break out of for(;;) loop */
	}
	return(errstop(0,NULL,rite,out));
}
