/* Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* indxsub APL2 V1.0.0 *************************************************
* Called by deal, grade, grade2, indexgen, and transpot.               *
* indxsub(3) returns a pointer to an APLCB for the vector 1 2 3 if     *
* indxorg=1, and the vector 0 1 2 if indxorg=0.  indxsub(-3) returns   *
* the vector 3 2 1 if indxorg=1, and 2 1 0 if indxorg=0.               *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb indxsub(indx)
int indx;
{
	Errinit; Errstop; Getcb;
	extern int indxorg;
	int datacnt,i,*ip;
	Aplcb out;

	if (errinit())
		return(NULL);
	datacnt = (indx>=0) ? indx : -indx;
	out = getcb(NULL, datacnt, APLTEMP + APLINT, 1, NULL);
	if (datacnt) {
		ip = out->aplptr.aplint;
		if( indx > 0) {
			i = indxorg;
			while(datacnt--) *ip++ = i++;
		}
		else {
			i = datacnt + indxorg - 1;
			while(datacnt--) *ip++ = i--;
		}
	}
	return(errstop(0,NULL,NULL,out));
}
