/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* indices APL2 V1.0.0 *************************************************
* Called by findb and disclosh to increment a set of indices pointed to*
* by ip. If rank is 2, and dimensions pointed to by jp are 2 3, and *ip*
* is 1 3 at entry, at exit *ip will be 2 1, assuming org is 1.         *
***********************************************************************/
#include "includes.h"
void indices(ip,jp,j,rank,org)
int *ip;	/* Index array, initialized to org-1.	*/
int *jp;	/* Dimension array.					*/
int *j;	/* Current dimension, origin 0. Should	*/
		/* be initialized to 1 before the first */
		/* call to indices.					*/
int rank; /* Number of dimensions.				*/
int org;	/* Index origin to use.				*/
{
     (*j)--;
     while(*j < rank) { /* loop to set indices */
          while(++(*(ip + *j)) == *(jp + *j) + org)
               *(ip + (*j)--) = org - 1; /* re-initialize */
          (*j)++;
     }
}
