/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* indexno APL2 V1.0.0 *************************************************
* Called by disclosh and pickit to obtain the element number based on  *
* indices.  Always returns the index relative 0.				   *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int indexno(n, rp, ip, jp, org)
int n;	/* Number of dimensions.			*/
int *rp;	/* Index to dimensions, or NULL.	*/
		/* If null, indices to dimensions	*/
		/* are assumed to be 0, 1, 2,...,  */
		/* plus org (index origin to use). */
int *ip;	/* Indices.					*/
int *jp;	/* Actual dimensions.			*/
int org;	/* Index origin to use.			*/
{
	int i, j, k, m, p;

	p = 0; /* w/b element number */
	m = 1; /* first multiplier */
	while(n--) { /* Loop once for each dimension. */
		k = (rp) ? *(rp + n) - org : n; /* index to index, org 0 */
		i = *(ip + k) - org;	/* next index, org 0  */
		if (i) {
			if (jp == NULL) return(-1); /* Caller's error. */
			if (i >= *(jp + n)) return(-1); /* Caller's error. */
			j = i * m;   /* next product */
			p += j;
		}
		if (jp != NULL) m *= *(jp + n);
	}
	return(p);
}
