/*Copyright (C) 1992, 1996 by Thomas Glen Smith.	All Rights Reserved.*/
/* gettcom APL2 V1.0.0 *************************************************
* Called by both gettext to handle input line editing.                 *
***********************************************************************/
#define INCLUDES STDIO+STRING
#include "includes.h"
int gettcom(line,linelen,maxline,cursor,insert)
char line[]; /* line stored here.*/ 	int linelen;/* curlength(line)*/
int maxline; /* maxlength(line). */	int cursor; /* cursor position*/
int insert;  /* 1=input inserted, 0=overlaid. */
{	Aplgetc; Aplnewl; Aplprint; Aplputch; Edlinf; Edling;
	int cc, ii, jj, lim;
#if APL_DOS
	static int aa=0;
#endif

	lim = maxline - linelen;
	while (--lim > 0 && (cc = aplgetc()) != EOF) {
#if APL_DOS
		if (cc == '\n' || cc == '\r') {
			if (aa == cc) { /* It's two consecutive empty lines. */
				cursor = linelen;
				break; /* all done */
			}
			if (aa == '\n' || aa == '\r') {
				aa = cc = aplgetc(); /* Throw away reduncancy. */
				if (EOF == cc) break;
				if (cc == '\n' || cc == '\r') { /* Two empty lines. */
					cursor = linelen;
					break; /* all done */
				}
			} else {
				cursor = linelen;
				break; /* all done */
			}
		} else aa=0;
#else
		if (cc == '\n' || cc == '\r') {
			cursor = linelen;
			break; /* all done */
		}
#endif
		switch (cc) {
		case '\b': /* backspace */
			if (cursor) { /* del, reprint */
				edling(line,&cursor,1,--linelen);
				lim++;
			}
			break;
		case '\0': /* potential left/right arrow, delete key */
			switch(aplgetc()) { /* get the real code */
			case 71: while (cursor) /* home */
				edlinf(line,&cursor,1); /* backspace */ break;
			case 75: if (cursor) /* left arrow */
				edlinf(line,&cursor,1); /* backspace */ break;
			case 77: if ( linelen > cursor ) /* right arrow */
				aplputch(line[cursor++]); break;
			case 79: while ( linelen > cursor ) /* end */
				aplputch(line[cursor++]); break;
			case 83: if (cursor < linelen) /* delete */ {
				cursor++;
				edling(line,&cursor,1,--linelen); } break;
			} /* end switch */
			break;
		default: if (cursor >= maxline) break;
			if (insert) for ( jj = linelen++; jj >= cursor; jj-- )
				line[jj+1] = line[jj];
			aplputch(line[cursor++]=cc);
			if (insert) {
				aplprint(line+cursor); /* print again */
				ii = linelen; /* cursor is at end of line */
				edlinf(line,&ii,linelen - cursor); /* backspace */
			} else if (cursor > linelen) line[linelen=cursor] = '\0';
			break;
	}	} /* end switch */
	aplnewl(); /* Start a new output line. */
	line[cursor] = '\0';
	if (cursor == 0 && cc == EOF) return(-1); /* indicate end-of-file */
	return(cursor);
}
