/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* getcode APL2 V1.0.0 *************************************************
* Called by eachtran, execfun, slashtrc,                               *
* to determine the operator/function code, and to set pfunc as         *
* as side effect.  The operator/function code can only be one of the   *
* following, anything else considered to be an error:		 		 *
*   DEFINED_FUNCTION(256): User-defined function, handled by funcmain. *
*   DERIVED_FUNCTION(-7): Operator-derived function (scan, each, etc.) *
*   LEFT_ARROW(3): assignment.								 *
*   FUNCTION_TOKEN(-10):										 *
*   APL_NULL(42): outer product								 *
*   DIERESIS(65): each										 *
*   DOT(14): inner product									 *
*   QUAD_..(-11 or less):									 *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB
#include "includes.h"
int getcode(pfunc,funtok)
void **pfunc; /* funstruc function definition structure */
Apltoken funtok;
{
	extern int aplerr;
	int code=0;

	code = funtok->token_code; /* save function/operator code */
	if (NULL != (*pfunc = funtok->token_work))
		code = DEFINED_FUNCTION;
	else switch(code) {
		case LEFT_ARROW:
		case FUNCTION_TOKEN:
		case DERIVED_FUNCTION:
			*pfunc = funtok->token_ptr.token_function;
			funtok->token_ptr.token_function = NULL;
			break;
		case APL_NULL: /* outer product */
		case DIERESIS: /* each */
		case DOT:		/* inner product */
			break;
		default:
			if (code > QUAD_AI)
				aplerr = 63; /* missing operator/function */
	} /* end switch */
	return(code);
}
