/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* getchrv APL2 V1.0.0 *************************************************
* Called by funcsusp.                                                  *
* Sends a prompt to the standard output file and obtains from standard *
* input a character string, from which an APL vector of character type *
* is constructed and returned.  The APL variable will have an element  *
* count of 0 when end-of-file is reached.                              *
***********************************************************************/
#define MAXLINE 1024
#define INCLUDES APLCB+STDIO
#include "includes.h"
Aplcb getchrv(prompt)
char *prompt;
{
	Aplnewl; Chrcopy; Errstop; Getcb; Gettext;
	char line[MAXLINE],*cp;
	int linelen;
     Aplcb out;

	line[0]='\0';
	aplnewl(); /* Skip to a new line. */
	printf("%s",prompt);
	for ( linelen = 0; linelen == 0; ) {
		line[0] = '\0'; /* empty out line */
		linelen=gettext(line,MAXLINE);
	}
	aplnewl(); /* Skip to a new line. */
	if (linelen == -1) linelen = 0; /* return null line for eof */
	out = getcb(NULL,linelen,APLCHAR+APLTEMP,1,NULL);
	if (out != NULL)
		if (out->aplcount)
			cp = chrcopy(out->aplptr.aplchar,line,out->aplcount,1);
	return(errstop(0,NULL,NULL,out));
}
