/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* funcsusp APL2 V1.0.0 ************************************************
* Called by APL mainline, funcexec, and funcexee, funcsusp gets	       *
* terminal input, and executes APL statements until a branch resumes   *
* execution of a suspended function, or )off is entered.	       *
***********************************************************************/
#define INCLUDES APLCB+APLDEBUG+APLDOS+APLFUNCI+APLTOKEN+STDIO+TREE
#include "includes.h"
int funcsusp()
{
#include "aplwkcd.h"
	Apledit; Aplmsg; Aplnewl; Aplputch; Aplscan; Aplwksp;
	Execterm; Getchrv;
#if APL_DOS
	extern size_t aplstack; /* used to check stack */
#endif
	extern Treelist treehdr;
	extern int aplerr, aplwkcd, errno;
	extern Aplcb aplwkcb;
	Aplcb out;
	int i,loop=1,stmtno=0;
#if APL_DEBUG
	void mem_check(void);
#endif

	if (treehdr->avlfun != NULL) {
		treehdr->treeflag |= SUSPNDED;
		printf("%s[%d]", treehdr->avlfname, treehdr->avlstmt);
		aplnewl(); /* Start a new output line. */
	}
	while (loop && aplerr != 998 &&
		!(aplerr == 997 && !(treehdr->treeflag & SUSPNDED))) {
#if APL_DEBUGQ
		mem_check();
#endif
		aplerr = errno = 0; /* reset any prior error */
		out = getchrv("apl>"); /* get APL statement */
		if (aplerr) {
			fprintf(stderr,"%s\n",aplmsg(aplerr));
			exit(aplerr);
		}
		if (out->aplcount == 0) {
			aplerr = 998; /* indicate eoj */
			aplwkcb = out; /* save for later */
			aplwkcd = OFF; /* defer )OFF processing */
			loop = 0; /* An empty line signals end of file */
		}
		else
			loop = funcsusq(out,&stmtno); /* process this statement */
#if APL_DOS
		if (aplstack > _chkstack()) {
			aplerr = 121; /* Remaining stack too small. */
			break; /* get out */
		}
#endif
	}
	if (treehdr->treeflag & SUSPNDED) treehdr->treeflag -= SUSPNDED;
	return(stmtno);
}
