/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* formsci APL2 V1.0.0 *************************************************
* Called by formatr when the format field indicates output is to be in *
* scientific notation.  Returns ptr to next available output position. *
***********************************************************************/
#define INCLUDES STDIO+STRING+FORM
#include "includes.h"
char *formsci(op,gch,bufptr,bufint,fldptr,fldint,neg,value,buffer)
char	*op;		/* Place to store next formatted output. */
char	*gch;	/* Ptr to Lfc data. */
char	**bufptr;	/* Array of ptrs into value to format. */
int	*bufint;	/* Array of int describing value to format. */
char **fldptr; /* Array of ptrs into fmt cntl fld left of e-not. symbol, */
	/* e.g. the "e" in 1.23e5, except End_Of_Field points to the "5". */
int	*fldint;	/* Ptr to array describing format control field left */
	/* of e-notation symbol. */
int	neg;		/* 1 if original value was negative, 0 if not. */
double value;	/* Abs(original value to be formatted). In all comments */
	/* in this routine, assume value is 123.45. */
char *buffer;	/* Work buffer in which to format value. */
{
	Formats; Formatv; Formscj; Intcopy;
	extern int aplerr;
	int bdigits,blen,expadj,expneg,fdigits,fplaces;
	char *eptr,fb[80],*fptr,*wp;
	static char blank=' ';
	int	 expint[BIALEN], fxpint[BIALEN];
	char	*expptr[BCALEN],*fxpptr[BCALEN];

	for(;;) { /* Lets me use break. */
		fplaces = PLACES(fldint);	/* Decimals right of d.p. in */
		sprintf(fb,"%%.%de",fplaces);	/* field, e.g. 4. */
		sprintf(buffer,fb,value);	/* Format as [-]m.nnnnesxx, */
								/* e.g. 1.2345e+02. */
		eptr = strchr(buffer,'e'); /* Find "e" in e-notation. */
		if (eptr == NULL) { aplerr = 999; break; }
		*eptr = '\0'; /* Make it two strings, base and exponent. */
		formats(buffer,bufptr,bufint); /* Stats on base. */
		fdigits = DIGITS(fldint); /*Places wanted left of d.p., e.g. 2.*/
		bdigits = DIGITS(bufint); /*Actual places left of d.p., e.g. 1.*/
		expadj = bdigits - fdigits; /*Amount to adj. exponent, e.g. -1.*/
		if (expadj) /* Adjustment is non-zero. */
			formscj(bufptr,bufint,buffer,expadj,eptr);
		fptr = E_FORMAT_SYMBOL(fldptr); /* Addr(e-notation symbol). */
		E_FORMAT_SYMBOL(fldptr) = NULL; /* Adjust format control. */
		FIELD_LENGTH(fldint) = fptr - START_OF_FIELD(fldptr);
		END_OF_FIELD(fldptr) = fptr;
		op = formatv(op,gch,bufptr,bufint,fldptr,fldint,neg); /*Base.*/
		*op++ = *fptr; /* Output e-notation symbol. */
		formats(fptr+1,fxpptr,fxpint); /* Stats on format cntl. */
		expneg = (*(eptr+1) == '-') ? 1 : 0; /* Test sign of exp. */
		for(eptr += 2; *eptr != '\0' && *eptr == '0'; eptr++);
		if (*eptr == '\0') eptr--; /* Back up to last 0. */
		formats(eptr,expptr,expint); /* Stats on formatted exp. */
		op = formatv(op,gch,expptr,expint,fxpptr,fxpint,expneg);
		break; /* Final break from for(;;) */
	}
	return(op);
}
