/* Copyright (C) 1996 by Thomas Glen Smith.  All Rights Reserved. */
/* formota APL2 V1.0.0 *************************************************
* Called by formato when the current format character is '0' to '9'.  *
***********************************************************************/
#define INCLUDES STRING+FORM
#include "includes.h"
void formota(cc,ch,bca,bia,four_switch,seven_switch,fcc_local)
char	*cc;			/* Pointer to current format character. */
char	ch;			/* Copy of current format character. */
char **bca;		/* Array of character pointers. */
int	*bia;		/* Array of integers */
int	*four_switch;	/* 1 if '4' format character was seen. */
int	*seven_switch;	/* 1 if '7' format character was seen. */
int	*fcc_local;	/* Format Control work area. */
{
	Formatu;
	int i=0;

	switch(ch) {
		case '1': case '2': case '3':
			formatu(&Fccflags,fcc_local,*four_switch,Decimal_Point,ch);
			break;
		case '4':
			*four_switch = 1;
			if (Decimal_Point == NULL) { /* Left of d.p. */
				if (Fccflags & FC1R) Fccflags &= ~FC1R;
				if (Fccflags & FC2R) Fccflags &= ~FC2R;
				if (Fccflags & FC3R) Fccflags &= ~FC3R;
			} else { /* Right of decimal point. */
				if (!(*fcc_local & FC1L) && (Fccflags & FC1L))
					Fccflags &= ~FC1L;
				if (!(*fcc_local & FC2L) && (Fccflags & FC2L))
					Fccflags &= ~FC2L;
				if (!(*fcc_local & FC3L) && (Fccflags & FC3L))
					Fccflags &= ~FC3L;
			}
			break;
		case '5': case '6':
			break;
		case '7': /* Signals E-format */
			*seven_switch = 1;
			break;
		case '8': /* Fill empty parts with Lfc[3] */
			Fccflags |= FC8;
			break;
		case '9': case '0':
			if (ch == '0')
				Fccflags |= FC0;
			else Fccflags |= FC9;
			if (Decimal_Point != NULL) Right_Pad_Zeros = cc;
			else if (Left_Pad_Zeros == NULL)
				Left_Pad_Zeros = cc;
			break;
	} /* end switch */
}
