/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* formldm APL2 V1.0.0 *************************************************
* Called by formatk to determine the last dimension, formatting the	 *
* real and imaginary parts of rite as separate vectors along each      *
* column, storing the result as an Aplcb in colcb.                     *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int formldm(rowcb,colcb,rite)
Aplcb rowcb;	/* RowsX1 matrix of APLNUMB, one row per row of rite. */
Aplcb colcb;	/* Vector of APLAPL, two per column of rite. */
Aplcb rite;	/* RowsXcols Matrix of complex numbers to be formatted. */
{
	Form;
	extern int aplerr;
	Aplcb *cb,cc;
	int col,cols,lastdim,row,rows;
	double *ip, *op;

	rows = *(rite->apldim);
	cols = *(rite->apldim + 1);
	lastdim = cols * 2 - 1; /* 1 for blank between columns, 1 for j. */
	cb = colcb->aplptr.aplapl;
	op = rowcb->aplptr.apldata;
	for (col = 0; aplerr == 0 && col < cols; col++) {
		ip = rite->aplptr.apldata + col * 2;
		for (row = 0; row < rows; row++) /* Set rowcb to the real part */
			*(op + row) = *(ip + row * cols * 2); /* from input column. */
		*cb++ = cc = form(NULL, rowcb); /* Format real part of column. */
		if (cc == NULL) break;
		cc->aplflags -= APLTEMP;
		lastdim += *(cc->apldim + 1); /* Bump lastdim by column width. */
		for (row = 0; row < rows; row++) /* Set rowcb to the imag. part */
			*(op + row) = *(ip + row * cols * 2 + 1); /* from input col. */
		*cb++ = cc = form(NULL, rowcb); /* Format imaginary part of col. */
		if (cc == NULL) break;
		cc->aplflags -= APLTEMP;
		lastdim += *(cc->apldim + 1); /* Bump lastdim by column width. */
	}
	return(lastdim);
}
