/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* formdfy APL2 V1.0.0 *************************************************
* Formdfy is called by formdfs and formdfw, to produce a 2-element     *
* vector dim.  dim[1] contains the product all dimensions of rite,     *
* except the last, and dim[2] is the last dimension of rite.           *
***********************************************************************/
#define INCLUDES STDIO+APLCB
#include "includes.h"
Aplcb formdfy(rite)
Aplcb rite; /* apl variable to be printed, marked permanent. */
{
     Endoper; Cat; Drop; Errstop; Ireduce; Iscalar; Itimes; Perm;
     Reshape; Shape; Take; Temp;
     extern int aplerr,indxorg;
     Aplcb dimcb,frmcb;
     int identity=1;

     frmcb = perm(cat(reshape(iscalar(2),iscalar(1)),shape(rite),indxorg));
          /* frmcb = vector of "1 1" followed by shape of rite */
     if (aplerr) return(errstop(0,NULL,NULL,frmcb));
     dimcb = cat(ireduce(itimes,&identity,drop(iscalar(-1),frmcb),indxorg),
         take(iscalar(-1),frmcb),indxorg); /* 2 dimensions */
     endoper(temp(frmcb));
     return(errstop(0,NULL,NULL,dimcb));
}
