/*Copyright (C) 1992, 1998 by Thomas Glen Smith.  All Rights Reserved.*/
/** formbfn APL2 V1.0.1 ************************************************
* Called from formath to format f-notation output.                     *
***********************************************************************/
#define INCLUDES LIMITS+STDIO+STRING
#include "includes.h"
int formbfn(d,cp,width,precisn,digits,fch,output)
double d;		/* Value t/b formatted. */
char *cp;		/* Output location. */
int width;	/* Width of output. */
int precisn;	/* Places output right of d.p. */
int digits;	/* Places output left of d.p. */
char *fch;	/* Lfc string. */
char *output;	/* Work buffer. */
{
	Chrcopy;
	extern int aplerr;
	char ch,format[80];
	int ii,jj;

	ii =	width /* Total width of field, */
		- precisn /* Less places right of decimal, */
		- ((precisn > 0) ? 1 : 0) /* Less place for d.p., */
		- ((d < 0.0) ? 1 : 0); /* Less place for sign. */
	if (ii < digits) { /* Overflow? */
		if ('0' == (ch = *(fch+3))) /* Is Lfc[4] == '0'? */
			aplerr = 29; /* model width is too small */
		else /* Fill with overflow indicator. */
			cp = chrcopy(cp,&ch,width,0); /* Fill. */
		return(1); /* Return after overflow condition. */
	}
	sprintf(format,"%%%d.%df",width,precisn);
	sprintf(output,format,d);
	ii = strlen(output);
	if (width > 1 && ii == width && output[0] == '0')
		output[0] = ' '; /* eliminate leading '0' */
	if (ii > 1 && output[ii-1] == '0') {
		for(jj=ii-2; jj; jj--) {
			if (output[jj]=='0' ||
			    output[jj]=='.') continue;
			break; /* break at first non-zero or . */
		}
		if (output[jj] == '-')
			output[jj++] = ' '; /* Eliminate '-' in '-0.0...' */
		else if (output[jj] == ' ')
			jj++; /* back up to first '0' */
		if (output[jj] == '0')
			while(jj<ii-1) output[jj++]=' '; /* wipe 0.0... */
	}
	return(0); /* Indicate no overflow condition. */
}
