/*Copyright (C) 1992, 1994 by Thomas Glen Smith.	All Rights Reserved.*/
/** formben APL2 V1.0.0 ************************************************
* Called from formath to format an element.						 *
***********************************************************************/
#define INCLUDES LIMITS+STDIO+STRING
#include "includes.h"
void formben(d,cp,width,precisn,digits,fch,output)
double d;		/* Value t/b formatted. */
char *cp;		/* Output location. */
int width;	/* Width of output. */
int precisn;	/* Places output right of d.p. */
int digits;	/* Places output left of d.p. */
char *fch;	/* Lfc string. */
char *output;	/* Work buffer. */
{
	extern int aplerr;
	char format[80],*ip,*jp,*kp;
	int i,j,k,m;

	sprintf(format,"%%%d.%de",width,-precisn-1);
	sprintf(output,format,d);
	j = strcspn(output,"eE"); /* index to e */
	ip = strchr(output,'.'); /* index to 1st dot */
	if (ip != NULL) {
		i = ip - output;
		if (i < j) {
			ip = (jp = output + j) - 1; /* digit left of e */
			while (*ip == '0') ip--;
			if (*ip != '.') ip++; /* 1st char to eliminate */
			k = jp - ip; /* count of chars to eliminate */
			if (k) {
				while('\0' != (*ip++ = *jp++));
				j -= k;
			}
		}
	}
	jp = kp = output + j + 1; /* beyond e */
	if	(*jp == '+') while('\0' != (*jp = *(jp + 1))) jp++;
	else if (*jp == '-') kp = jp + 1;
	else kp = jp;
	ip = (jp = kp) + strlen(kp) - 1; /* ip points to last char */
	while('0' == *kp && kp != ip) kp++;
	if (jp != kp) while('\0' != (*jp++ = *kp++));
	if (width <= (i = strlen(output)))
		if (i > (j = strcspn(output,"eE")))
			if ('0' == *(ip = output + j + 2)) {
				while (--ip >= output) *(ip + 1) = *ip;
				output[0] = ' '; /* left pad = blank */
			}
}
