/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* formatv APL2 V1.0.0 *************************************************
* Called by formatr after analyzing the format field, and formatting   *
* the value to be output, using sprint.  Returns a ptr to the next     *
* available output position.                                           *
***********************************************************************/
#define INCLUDES STDIO+STRING+FORM
#include "includes.h"
char *formatv(op,gch,bufptr,bufint,fldptr,fldint,neg)
char	*op;		/* Place to store next formatted output. */
char	*gch;	/* Ptr to Lfc data. */
char	**bufptr;	/* Ptr to array of ptrs into value to format. */
int	*bufint;	/* Ptr to array of int describing value to format. */
char **fldptr; /* Ptr to array of ptrs into format control field. */
int	*fldint;	/* Ptr to array of describing format control field. */
int	neg;		/* 1 if original value was negative, 0 if not. */
{
	Chrcopy; Formatw; Formbfv;
	extern int aplerr;
	int bdi,bpl,fdi,fln,fpl,i,sln;
	char *bs,ch,*cp,fch,*fs,*fct,*ofd=NULL,*old=NULL,*oq,*pz,*sp;

	if (DIGITS(fldint) < DIGITS(bufint)) { /* Overflow? */
		if ('0' == (ch = *(gch+3))) /* Is Lfc[4] == '0'? */
			aplerr = 29; /* model width is too small */
		else op = chrcopy(op,&ch,FIELD_LENGTH(fldint),0); /* Fill. */
		return(op); /* Return overflow condition */
	}
	oq = sp = op; /* Starting output location. */
	op += fln = sln = FIELD_LENGTH(fldint); /* Ending output location. */
	bs = START_OF_FIELD(bufptr);
	fs = START_OF_FIELD(fldptr); /* Start of format field. */
	bdi = DIGITS(bufint); /* Digits left of d.p. in value. */
	fdi = DIGITS(fldint); /* Digits left of d.p. in field. */
	bpl = PLACES(bufint); /* Decimals right of d.p. in value. */
	fpl = PLACES(fldint); /* Decimals right of d.p. in field. */
	formbfv(bs,fs,&old,&ofd,oq,gch,fldptr,fldint,bdi,fdi,bpl,fpl,fln);
	formatw(fldptr,fldint,neg,ofd,old); /* Float decorators. */
	if (FCCFLAGS(fldint) & FC8) { /* Replace blanks with fill. */
		ch = *(gch+2); /* Lfc[3] == fill character. */
		while(sln--) { /* Once for each field character. */
			if (' ' == *sp) *sp = ch;
			sp++;
		}
	}
	return(op);
}
