/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* formats APL2 V1.0.0 *************************************************
* Called by formatr to extract information from a format field model.  *
* Note that in the case of e-notation, the Start_Of_Field and          *
* End_Of_Field pointers will be set to encompass the entire field, but *
* the other descriptors, e.g. decimal point address and flags, apply   *
* only to the part left of the "e".                                    *
***********************************************************************/
#define INCLUDES STRING+FORM
#include "includes.h"
void formats(buf,bca,bia)
char *buf,					/* String to analyze. */
	**bca;					/* Array of character pointers. */
int	*bia;					/* Array of integers */
{
	Formato;
	int fcc_local=0,four_switch=0,i=0,seven_switch=0;
	char *cc,ch,*cp,**ip;

	Fccflags = FC4L | FC4R; /* Default is to print asis. */
	for(i = BCALEN, ip = bca; i; i--)
		*ip++ = NULL; /* initialize */
	DIgits = 0; /* Initialize. */
	PLAces = 0; /* Initialize. */
	Start_Of_Field = cp = buf; /* start of buf */
	while('\0' != (ch = *cp++)) {
		cc = cp - 1; /* current character */
		if (!(seven_switch != 0 && E_Format_Symbol != NULL))
			formato(cc,ch,bca,bia,&four_switch,&seven_switch,&fcc_local);
	}
	End_Of_Field = --cp; /* back up to end of buf = A('\0') */
	Field_Length = End_Of_Field - Start_Of_Field; /* length of buffer */
	if (Decimal_Point == NULL)
		Decimal_Point = End_Of_Field; /* if no decimal point, pretend */
}
