/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* formatr APL2 V1.0.0 *************************************************
* Called by formatq to format a value using a model.                   *
* Returns a ptr to the next available output position.                 *
***********************************************************************/
#define INCLUDES STDIO+STRING+FORM
#include "includes.h"
char *formatr(op,field,value,gch)
char		*op;		/* Place to store next formatted output. */
char		*field;	/* Field containing format control. */
double	value;	/* Value to be formatted. */
char		*gch;	/* Ptr to Lfc data. */
{
	Chrcopy; Eq; Formats; Formatt; Formatv; Formsci;
	extern int aplerr;
	int bufint[BIALEN],fldint[BIALEN];
	char *bufptr[BCALEN],*fldptr[BCALEN];
	int i,neg;
	char buffer[80],*bufp,ch;

	if (value < 0.0) {
		neg = 1; /* Save indication of negative value. */
		value = -value; /* Get absolute value. */
	}
	else neg = 0;
	formats(field,fldptr,fldint); /* Extract formatting info. */
	if (E_FORMAT_SYMBOL(fldptr) != NULL) /* Scientific notation? */
		return(formsci(op,gch,bufptr,bufint,fldptr,fldint,
			neg,value,buffer));
	if (eq(value,0.0))  /* Absolute value < fuzz? */
		if (!(FCCFLAGS(fldint) & FC0)) { /* Not zero-fill? */
			ch = (FCCFLAGS(fldint) & FC8) ? *(gch+2) : ' ';
			op = chrcopy(op,&ch,FIELD_LENGTH(fldint),0); /* Fill. */
			return(op); /* All done. */
		}
	bufp = formatt(buffer,value,PLACES(fldint)); /* Round and sprintf. */
	formats(bufp,bufptr,bufint);
	return(formatv(op,gch,bufptr,bufint,fldptr,fldint,neg));
}
