/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* formatk APL2 V1.0.0 *************************************************
* Called by form when rite is of data type APLCPLX.  Rite was reshaped *
* by form to a 2-dimensional matrix.  Dimcb contains the original	 *
* dimensions.												 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb formatk(left,rite,dimcb)
Aplcb left,rite,dimcb;
{
	Endoper; Formbtk; Formldm; Formspp; Getcb; Intcopy; Temp;
	extern int aplerr;
	Aplcb colcb=NULL,out=NULL,rowcb=NULL;
	int cols,datacnt,*dimptr,lastdim,rank,rows;

	rows = *(rite->apldim);
	cols = *(rite->apldim + 1);
	colcb = getcb(NULL, cols * 2, APLAPL + APLTEMP, 1, NULL);
	rowcb = getcb(NULL, rows, APLNUMB, 2, NULL);
	if (rowcb != NULL) {
		*(rowcb->apldim) = rows;
		*(rowcb->apldim + 1) = 1;
	}
	for (;;) { /* lets me use break */
		if (aplerr) break;
		formspp(rite); /* Make adjustments for print precison (Lpp). */
		lastdim = formldm(rowcb,colcb,rite); /* Total width of output. */
		if (aplerr) break;
		datacnt = rows * lastdim; /* Total chars in output. */
		rank = dimcb->aplcount ? dimcb->aplcount : 1;
		out = getcb(NULL, datacnt, APLCHAR + APLTEMP, rank, NULL);
		if (out == NULL) break;
		if (rank > 1) {
			dimptr = intcopy(out->apldim, dimcb->aplptr.aplint,
				out->aplrank - 1, 1);
			*dimptr = lastdim;
		}
		formbtk(rite,out,colcb); /* Finish processing. */
		break; /* final break */
	}
	endoper(colcb);
	endoper(temp(rowcb));
	endoper(temp(dimcb));
	endoper(temp(rite));
	return(out);
}
