/* Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* formatj APL2 V1.0.0 *************************************************
* Called from form to obtain descriptions of rite.                     *
***********************************************************************/
#define INCLUDES APLCB+MATH+FORM
#include "includes.h"
formatj(rite,cba)
Aplcb rite,	/* Values to be formatted. */
	cba;		/* Aplcb matrix of vectors for each column of input. */
{
	Digits; Formatx; Getcb; Log;
     extern int aplerr;
	int charcnt,charlen,charnew,col,cols,dig,i,m,n,row,rows,s;
	double log10,myfuzz=1e-11,*rp,val,valmax,valmin,wrk;

     rows = *rite->apldim;
	cols = *(rite->apldim+1);
     log10 = log(10.0);
	for (col = 0; col < cols; col++) { /* Once for each column of rite. */
		n = s = 0;
          valmax = 0e0;
          valmin = 1e0;
		charcnt = charlen = 0;
		for (row = 0; row < rows; row++) { /* once for each row */
			val = formatx(rite,row,col,cols,&charnew,&s,&m);
			if (charnew || aplerr) {
				if (charnew > charlen)
					charlen = charnew; /* Find largest char vector. */
				charcnt++; /* Count char items in column. */
			}
			else { /* Simple numeric item. */
	               n = (m > n) ? m : n; /* max places */
	               if (val > valmax) valmax = val;
	               if (val < valmin && val > myfuzz) valmin = val;
			}
          }
		m = digits(valmax); /* Max digits left of decimal point. */
		*(Precb  + col) = n; /* Max places. */
		*(Fraccb + col) = n; /* Max places. */
		*(Signcb + col) = s; /* Sign. */
		*(Digicb + col) = m; /* Max digits left of decimal. */
		*(Widcb  + col) = -(log(valmin + myfuzz) / log10);
	          /* # 0s right of dec. bef. 1st dig. */
          *(Chrcb  + col) = charlen; /* Max characters. */
		*(Chrcol + col) = (charcnt == rows); /* Is column all char? */
	}
}
