/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* findb APL2 V1.0.0 ***************************************************
* Called from finda to finish processing after working Aplcbs alloc.	 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void findb(left,rite,out,dimcb,ixcb,lccb,rccb,k,datatyp,d)
Aplcb left,rite,out,dimcb,ixcb,lccb,rccb;
int k;	   /* Count of items in out that can be 1.	    */
int datatyp; /* Data type of left and rite.			    */
int d;	   /* Difference between ranks of left and rite. */
{
	Intcopy; Matchsub;
	int i,j,m,n,p,r,s,t,u,v,*lip,*oip,*pip,*rip;
	char *lcp, *rcp;

	for(j = 1; k; k--) { /* k is # items potentially 1 in output */
		indices(ixcb->aplptr.aplint,/* bump indices */
			dimcb->aplptr.aplint, /* pseudo dimensions */
			&j,				  /* current dimension */
			ixcb->aplcount,	  /* count dimensions */
			0);				  /* index origin */
		m = indexno(ixcb->aplcount,/* index to corner */
			NULL,			  /* dimensions not indexed */
			ixcb->aplptr.aplint,  /* indices */
			out->apldim,		  /* actual dimensions */
			0);				  /* index origin */
		oip = out->aplptr.aplint + m; /* corner elment */
		t = 1;
		i = -1; /* initialize indices to left */
		pip = intcopy(lccb->aplptr.aplint, &i, lccb->aplcount, 0);
		pip = intcopy(rccb->aplptr.aplint, ixcb->aplptr.aplint, d, 1);
		for(n = left->aplcount, p = 1; n && t; n--) {
			indices(lccb->aplptr.aplint,	/* bump left indices */
				left->apldim,			/* dimension array */
				&p,					/* current dimension */
				lccb->aplcount,		/* count dimensions */
				0);					/* index origin */
			m = indexno(lccb->aplcount,	/* index to left */
				NULL,				/* dim. not indexed */
				lccb->aplptr.aplint,	/* index array */
				left->apldim,			/* dimension array */
				0);					/* index origin */
			lcp = left->aplptr.aplchar + m * left->aplsize;
			for(v = rccb->aplcount - d, lip = lccb->aplptr.aplint,
				rip = rccb->aplptr.aplint + d,
				pip = ixcb->aplptr.aplint + d; v; v--)
				*rip++ = *lip++ + *pip++;
			r = indexno(rite->aplrank,	/* index to rite */
				NULL,				/* dim. not indexed */
				rccb->aplptr.aplint,	/* index array */
				rite->apldim,			/* actual dimensions */
				0);					/* index origin */
			rcp = rite->aplptr.aplchar + r * rite->aplsize;
			t = matchsub(datatyp,lcp,rcp);
		}
		*oip = t;
	}
}
